/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.TaskExecutorService;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Task<T>
extends ExternalizableLite {
    public T execute(Context<T> var1) throws Exception;

    public static class Yield
    extends Exception {
        protected final Duration m_duration;

        private Yield(Duration duration) {
            this.m_duration = duration;
        }

        public Duration getDuration() {
            return this.m_duration;
        }

        public static Yield atLeast(Duration duration) {
            return new Yield(duration);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Yield yield = (Yield)object;
            return Objects.equals(this.m_duration, yield.m_duration);
        }

        public int hashCode() {
            return this.m_duration != null ? this.m_duration.hashCode() : 0;
        }
    }

    public static interface Subscription<T> {
        public void cancel();

        public Coordinator<T> getCoordinator();
    }

    public static interface Subscriber<T> {
        public void onComplete();

        public void onError(Throwable var1);

        public void onNext(T var1);

        public void onSubscribe(Subscription<? extends T> var1);
    }

    public static interface Properties {
        public <V extends Serializable> V get(String var1);

        public <V extends Serializable> V put(String var1, V var2);
    }

    public static interface Orchestration<T>
    extends SubscribedOrchestration<T> {
        public Orchestration<T> concurrently();

        public Orchestration<T> sequentially();

        public Orchestration<T> filter(Remote.Predicate<? super TaskExecutorService.ExecutorInfo> var1);

        public Orchestration<T> limit(int var1);

        public Orchestration<T> as(String var1);

        public Orchestration<T> with(Option ... var1);

        public <V extends Serializable> Orchestration<T> define(String var1, V var2);

        public Orchestration<T> retain(Duration var1);

        public <R> Collectable<T, R> collect(Collector<? super T, ?, R> var1);
    }

    public static interface SubscribedOrchestration<T> {
        public SubscribedOrchestration<T> subscribe(Subscriber<? super T> var1);

        public Coordinator<T> submit();
    }

    public static interface Option
    extends ExternalizableLite {
    }

    public static interface Coordinator<T> {
        public void subscribe(Subscriber<? super T> var1);

        public boolean cancel(boolean var1);

        public boolean isCancelled();

        public boolean isDone();

        public String getTaskId();

        public Properties getProperties();
    }

    public static interface Context<T> {
        public void setResult(T var1);

        public boolean isDone();

        public boolean isResuming();

        public Properties getProperties();

        public String getTaskId();

        public String getExecutorId();
    }

    public static interface CompletionRunnable<T>
    extends Consumer<T>,
    ExternalizableLite {
    }

    public static interface Completable<T, R>
    extends Collectable<T, R> {
    }

    public static interface Collector<T, A, R>
    extends ExternalizableLite {
        public BiConsumer<A, T> accumulator();

        public Function<A, R> finisher();

        public Remote.Predicate<A> finishable();

        public Supplier<A> supplier();
    }

    public static interface Collectable<T, R> {
        public Completable<T, R> until(Remote.Predicate<? super R> var1);

        public Completable<T, R> andThen(CompletionRunnable<? super R> var1);

        public Collectable<T, R> subscribe(Subscriber<? super R> var1);

        public Coordinator<R> submit();
    }
}

