/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.processors;

import com.oracle.coherence.concurrent.executor.PortableAbstractProcessor;
import com.oracle.coherence.concurrent.executor.Result;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Member;
import com.tangosol.util.InvocableMap;
import java.io.IOException;

public class LocalOnlyProcessor
extends PortableAbstractProcessor {
    protected InvocableMap.EntryProcessor m_processor;
    protected final Member f_submittingMember;

    public LocalOnlyProcessor() {
        this.f_submittingMember = CacheFactory.getCluster().getLocalMember();
    }

    public LocalOnlyProcessor(InvocableMap.EntryProcessor processor) {
        this.m_processor = processor;
        this.f_submittingMember = CacheFactory.getCluster().getLocalMember();
    }

    public Object process(InvocableMap.Entry entry) {
        Member localMember = CacheFactory.getCluster().getLocalMember();
        if (localMember.equals(this.f_submittingMember)) {
            return Result.of(this.m_processor.process(entry));
        }
        return Result.none();
    }

    public static LocalOnlyProcessor of(InvocableMap.EntryProcessor processor) {
        return new LocalOnlyProcessor(processor);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_processor = (InvocableMap.EntryProcessor)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, (Object)this.m_processor);
    }
}

