/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.AbstractCollector;
import com.oracle.coherence.concurrent.executor.PortableCollector;
import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.function.Predicates;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class TaskCollectors {
    private TaskCollectors() {
    }

    public static <T> Task.Collector<T, ?, List<T>> listOf() {
        return new ListOfCollector();
    }

    public static <T> Task.Collector<T, ?, Set<T>> setOf() {
        return new SetOfCollector();
    }

    public static <T> Task.Collector<T, ?, T> lastOf() {
        return new LastOfCollector();
    }

    public static <T> Task.Collector<? super T, ?, Integer> count() {
        return new CountCollector();
    }

    public static <T> Task.Collector<T, ?, T> firstOf() {
        return new FirstOfCollector();
    }

    public static class SetOfCollector<T>
    implements PortableCollector<T, Set<T>, Set<T>>,
    Serializable {
        @Override
        public BiConsumer<Set<T>, T> accumulator() {
            return (set, result) -> {
                try {
                    if (result != null) {
                        set.add(result);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            };
        }

        @Override
        public Function<Set<T>, Set<T>> finisher() {
            return set -> set;
        }

        @Override
        public Remote.Predicate<Set<T>> finishable() {
            return Predicates.never();
        }

        @Override
        public Supplier<Set<T>> supplier() {
            return HashSet::new;
        }
    }

    public static class ListOfCollector<T>
    implements PortableCollector<T, List<T>, List<T>>,
    Serializable {
        @Override
        public BiConsumer<List<T>, T> accumulator() {
            return (list, result) -> {
                try {
                    if (result != null) {
                        list.add(result);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            };
        }

        @Override
        public Function<List<T>, List<T>> finisher() {
            return list -> list;
        }

        @Override
        public Remote.Predicate<List<T>> finishable() {
            return Predicates.never();
        }

        @Override
        public Supplier<List<T>> supplier() {
            return ArrayList::new;
        }
    }

    public static class LastOfCollector<T>
    extends AbstractCollector<T, T> {
        @Override
        public Function<List<T>, T> finisher() {
            return results -> {
                Object last = null;
                for (Object result : results) {
                    last = result;
                }
                return last;
            };
        }
    }

    public static class FirstOfCollector<T>
    implements PortableCollector<T, AtomicReference<T>, T>,
    Serializable {
        @Override
        public BiConsumer<AtomicReference<T>, T> accumulator() {
            return AtomicReference::set;
        }

        @Override
        public Function<AtomicReference<T>, T> finisher() {
            return reference -> {
                try {
                    return reference.get();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }

        @Override
        public Remote.Predicate<AtomicReference<T>> finishable() {
            return (Remote.Predicate & Serializable)reference -> reference.get() != null;
        }

        @Override
        public Supplier<AtomicReference<T>> supplier() {
            return () -> new AtomicReference<Object>(null);
        }
    }

    public static class CountCollector<T>
    extends AbstractCollector<T, Integer> {
        @Override
        public Function<List<T>, Integer> finisher() {
            return List::size;
        }
    }
}

