/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.function.Predicates;
import com.tangosol.util.function.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConditionalCollector<T, A, R>
implements Task.Collector<T, List<T>, R> {
    protected final Remote.Predicate<? super Iterator<T>> f_predicate;
    protected final Task.Collector<T, A, R> f_collector;
    protected final R f_defaultResult;

    public ConditionalCollector(Remote.Predicate<? super Iterator<T>> predicate, Task.Collector<? super T, A, R> collector, R defaultResult) {
        this.f_predicate = predicate;
        this.f_collector = collector;
        this.f_defaultResult = defaultResult;
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return List::add;
    }

    @Override
    public Remote.Predicate<List<T>> finishable() {
        return Predicates.never();
    }

    @Override
    public Function<List<T>, R> finisher() {
        return results -> {
            if (this.f_predicate.test(results.iterator())) {
                A collectorContainer = this.f_collector.supplier().get();
                BiConsumer<A, A> collectorAccumulator = this.f_collector.accumulator();
                Remote.Predicate<A> collectorFinishable = this.f_collector.finishable();
                Function<A, R> collectorFinisher = this.f_collector.finisher();
                Iterator iterator = results.iterator();
                while (iterator.hasNext() && !collectorFinishable.test(collectorContainer)) {
                    Object result = iterator.next();
                    collectorAccumulator.accept(collectorContainer, result);
                }
                return collectorFinisher.apply(collectorContainer);
            }
            return this.f_defaultResult;
        };
    }

    @Override
    public Supplier<List<T>> supplier() {
        return ArrayList::new;
    }
}

