/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.locks;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.Member;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.UUID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public class LockOwner
implements ExternalizableLite,
PortableObject {
    private UUID m_memberId;
    private long m_threadId;
    private boolean m_fClient;

    public LockOwner() {
    }

    public LockOwner(Member member, long threadId) {
        this.m_memberId = member.getUuid();
        this.m_threadId = threadId;
        this.m_fClient = member.isRemoteClient();
    }

    public UUID getMemberId() {
        return this.m_memberId;
    }

    public long getThreadId() {
        return this.m_threadId;
    }

    public boolean isClient() {
        return this.m_fClient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockOwner lockOwner = (LockOwner)o;
        return this.m_threadId == lockOwner.m_threadId && this.m_memberId.equals((Object)lockOwner.m_memberId) && this.m_fClient == lockOwner.m_fClient;
    }

    public int hashCode() {
        return Objects.hash(this.m_memberId, this.m_threadId, this.m_fClient);
    }

    public String toString() {
        return "LockOwner{memberId=" + String.valueOf(this.m_memberId) + ", threadId=" + this.m_threadId + ", client=" + this.m_fClient + "}";
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_memberId = (UUID)ExternalizableHelper.readObject((DataInput)in);
        this.m_threadId = in.readLong();
        this.m_fClient = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_memberId);
        out.writeLong(this.m_threadId);
        out.writeBoolean(this.m_fClient);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_memberId = (UUID)in.readObject(1);
        this.m_threadId = in.readLong(2);
        this.m_fClient = in.readBoolean(3);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(1, (Object)this.m_memberId);
        out.writeLong(2, this.m_threadId);
        out.writeBoolean(3, this.m_fClient);
    }
}

