/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.Member;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.UUID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public class PermitAcquirer
implements ExternalizableLite,
PortableObject {
    private UUID f_memberId;
    private long f_threadId;
    private boolean f_client;

    public PermitAcquirer() {
    }

    public PermitAcquirer(Member member, long threadId) {
        this.f_memberId = member.getUuid();
        this.f_threadId = threadId;
        this.f_client = member.isRemoteClient();
    }

    public UUID getMemberId() {
        return this.f_memberId;
    }

    public long getThreadId() {
        return this.f_threadId;
    }

    public boolean isClient() {
        return this.f_client;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermitAcquirer acquirer = (PermitAcquirer)o;
        return this.f_threadId == acquirer.f_threadId && this.f_memberId.equals((Object)acquirer.f_memberId) && this.f_client == acquirer.f_client;
    }

    public int hashCode() {
        return Objects.hash(this.f_memberId, this.f_threadId, this.f_client);
    }

    public String toString() {
        return "PermitAcquirer{memberId=" + String.valueOf(this.f_memberId) + ", threadId=" + this.f_threadId + ", client=" + this.f_client + "}";
    }

    public void readExternal(DataInput in) throws IOException {
        this.f_memberId = (UUID)ExternalizableHelper.readObject((DataInput)in);
        this.f_threadId = ExternalizableHelper.readLong((DataInput)in);
        this.f_client = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.f_memberId);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.f_threadId);
        out.writeBoolean(this.f_client);
    }

    public void readExternal(PofReader in) throws IOException {
        this.f_memberId = (UUID)in.readObject(0);
        this.f_threadId = in.readLong(1);
        this.f_client = in.readBoolean(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, (Object)this.f_memberId);
        out.writeLong(1, this.f_threadId);
        out.writeBoolean(2, this.f_client);
    }
}

