/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.subscribers;

import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RecordingSubscriber<T>
implements Task.Subscriber<T> {
    protected boolean m_fUsed;
    protected boolean m_fCompleted;
    protected boolean m_fErrored;
    protected Throwable m_throwable;
    protected CopyOnWriteArrayList<T> f_listItems = new CopyOnWriteArrayList();
    protected Task.Subscription<? extends T> m_subscription;
    protected final ReadWriteLock f_rwLock = new ReentrantReadWriteLock();

    @Override
    public void onComplete() {
        ExecutorTrace.entering(RecordingSubscriber.class, "onComplete", new Object[0]);
        Lock wLock = this.f_rwLock.writeLock();
        try {
            wLock.lock();
            this.m_fCompleted = true;
            this.m_subscription = null;
        }
        finally {
            wLock.unlock();
        }
        ExecutorTrace.exiting(RecordingSubscriber.class, "onComplete");
    }

    @Override
    public void onError(Throwable throwable) {
        ExecutorTrace.entering(RecordingSubscriber.class, "onError", throwable);
        Lock wLock = this.f_rwLock.writeLock();
        try {
            wLock.lock();
            this.m_fErrored = true;
            this.m_subscription = null;
            this.m_throwable = throwable;
        }
        finally {
            wLock.unlock();
        }
        ExecutorTrace.exiting(RecordingSubscriber.class, "onError");
    }

    @Override
    public void onNext(T item) {
        ExecutorTrace.entering(RecordingSubscriber.class, "onNext", item);
        this.f_listItems.add(item);
        ExecutorTrace.exiting(RecordingSubscriber.class, "onNext");
    }

    @Override
    public void onSubscribe(Task.Subscription<? extends T> subscription) {
        block4: {
            ExecutorTrace.entering(RecordingSubscriber.class, "onSubscribe", subscription);
            Lock wLock = this.f_rwLock.writeLock();
            try {
                wLock.lock();
                if (!this.m_fUsed) {
                    this.m_fUsed = true;
                    this.m_subscription = subscription;
                    break block4;
                }
                throw new UnsupportedOperationException("RecordingSubscriber reuse is not supported.");
            }
            finally {
                wLock.unlock();
                ExecutorTrace.exiting(RecordingSubscriber.class, "onSubscribe");
            }
        }
    }

    public boolean isError() {
        Lock rLock = this.f_rwLock.readLock();
        try {
            rLock.lock();
            boolean bl = this.m_fErrored;
            return bl;
        }
        finally {
            rLock.unlock();
        }
    }

    public boolean isCompleted() {
        Lock rLock = this.f_rwLock.readLock();
        try {
            rLock.lock();
            boolean bl = this.m_fCompleted;
            return bl;
        }
        finally {
            rLock.unlock();
        }
    }

    public boolean isSubscribed() {
        Lock rLock = this.f_rwLock.readLock();
        try {
            rLock.lock();
            boolean bl = this.m_subscription != null;
            return bl;
        }
        finally {
            rLock.unlock();
        }
    }

    public boolean received(T item) {
        return this.f_listItems.contains(item);
    }

    public T getFirst() {
        return this.f_listItems.get(0);
    }

    public T getLast() {
        int size = this.f_listItems.size();
        return size == 0 ? null : (T)this.f_listItems.get(size - 1);
    }

    public int size() {
        return this.f_listItems.size();
    }

    public Throwable getThrowable() {
        Lock rLock = this.f_rwLock.readLock();
        try {
            rLock.lock();
            Throwable throwable = this.m_throwable;
            return throwable;
        }
        finally {
            rLock.unlock();
        }
    }
}

