/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.config;

import com.oracle.coherence.concurrent.config.NamedExecutorService;
import com.oracle.coherence.concurrent.executor.ClusteredExecutorService;
import com.oracle.coherence.concurrent.executor.options.CloseExecutor;
import com.oracle.coherence.concurrent.executor.options.Description;
import com.oracle.coherence.concurrent.executor.options.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ConcurrentConfiguration {
    private static final ConcurrentConfiguration INSTANCE = new ConcurrentConfiguration();
    private final Map<String, NamedExecutorService> f_mapNamedExecutorServices = new HashMap<String, NamedExecutorService>();
    private volatile ClusteredExecutorService m_executorService;

    private ConcurrentConfiguration() {
    }

    public List<NamedExecutorService> getNamedExecutorServices() {
        return Collections.unmodifiableList(new ArrayList<NamedExecutorService>(this.f_mapNamedExecutorServices.values()));
    }

    public NamedExecutorService getNamedExecutorService(String sName) {
        Objects.requireNonNull(sName, "sName cannot be null");
        return this.f_mapNamedExecutorServices.get(sName);
    }

    public synchronized void setExecutorService(ClusteredExecutorService executorService) {
        Objects.requireNonNull(executorService, "executorService cannot be null");
        this.m_executorService = executorService;
        for (NamedExecutorService service : this.f_mapNamedExecutorServices.values()) {
            executorService.register(service.getExecutorService(), Name.of(service.getName()), new CloseExecutor(), Description.of(service.getDescription()));
        }
    }

    public synchronized void reset() {
        this.m_executorService = null;
        this.f_mapNamedExecutorServices.clear();
    }

    public synchronized void addNamedExecutorService(NamedExecutorService service) {
        Objects.requireNonNull(service, "service cannot be null");
        String sName = service.getName();
        NamedExecutorService existing = this.f_mapNamedExecutorServices.putIfAbsent(service.getName(), service);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Named executor service already registered to name [%s]", sName));
        }
        if (this.m_executorService != null) {
            this.m_executorService.register(service.getExecutorService(), Name.of(sName), new CloseExecutor());
        }
    }

    public boolean isExecutorNameRegistered(String sName) {
        Objects.requireNonNull(sName, "sName cannot be null");
        return this.f_mapNamedExecutorServices.containsKey(sName);
    }

    public static ConcurrentConfiguration get() {
        return INSTANCE;
    }
}

