/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.AsyncAtomicReference;
import com.tangosol.util.function.Remote;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public class AsyncLocalAtomicReference<V>
implements AsyncAtomicReference<V> {
    private final AtomicReference<V> f_value;

    protected AsyncLocalAtomicReference(AtomicReference<V> value) {
        this.f_value = value;
    }

    @Override
    public CompletableFuture<V> get() {
        return CompletableFuture.completedFuture(this.f_value.get());
    }

    @Override
    public CompletableFuture<Void> set(V newValue) {
        this.f_value.set(newValue);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<V> getAndSet(V newValue) {
        return CompletableFuture.completedFuture(this.f_value.getAndSet(newValue));
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(V expectedValue, V newValue) {
        return CompletableFuture.completedFuture(this.f_value.compareAndSet(expectedValue, newValue));
    }

    @Override
    public CompletableFuture<V> getAndUpdate(Remote.UnaryOperator<V> updateFunction) {
        return this.getAndUpdate((UnaryOperator<V>)updateFunction);
    }

    @Override
    public CompletableFuture<V> getAndUpdate(UnaryOperator<V> updateFunction) {
        return CompletableFuture.completedFuture(this.f_value.getAndUpdate(updateFunction));
    }

    @Override
    public CompletableFuture<V> updateAndGet(Remote.UnaryOperator<V> updateFunction) {
        return this.updateAndGet((UnaryOperator<V>)updateFunction);
    }

    @Override
    public CompletableFuture<V> updateAndGet(UnaryOperator<V> updateFunction) {
        return CompletableFuture.completedFuture(this.f_value.updateAndGet(updateFunction));
    }

    @Override
    public CompletableFuture<V> getAndAccumulate(V x, Remote.BinaryOperator<V> accumulatorFunction) {
        return this.getAndAccumulate(x, (BinaryOperator<V>)accumulatorFunction);
    }

    @Override
    public CompletableFuture<V> getAndAccumulate(V x, BinaryOperator<V> accumulatorFunction) {
        return CompletableFuture.completedFuture(this.f_value.getAndAccumulate(x, accumulatorFunction));
    }

    @Override
    public CompletableFuture<V> accumulateAndGet(V x, Remote.BinaryOperator<V> accumulatorFunction) {
        return this.accumulateAndGet(x, (BinaryOperator<V>)accumulatorFunction);
    }

    @Override
    public CompletableFuture<V> accumulateAndGet(V x, BinaryOperator<V> accumulatorFunction) {
        return CompletableFuture.completedFuture(this.f_value.accumulateAndGet(x, accumulatorFunction));
    }

    @Override
    public CompletableFuture<V> compareAndExchange(V expectedValue, V newValue) {
        return CompletableFuture.completedFuture(this.f_value.compareAndExchange(expectedValue, newValue));
    }

    public String toString() {
        return String.valueOf(this.get().join());
    }
}

