/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent;

import com.oracle.coherence.concurrent.LocalCountDownLatch;
import com.oracle.coherence.concurrent.RemoteCountDownLatch;
import com.oracle.coherence.concurrent.config.ConcurrentServicesSessionConfiguration;
import com.oracle.coherence.concurrent.internal.LatchCounter;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.util.InvocableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Latches {
    public static final String SESSION_NAME = ConcurrentServicesSessionConfiguration.SESSION_NAME;
    private static final Map<String, LocalCountDownLatch> f_mapLatchLocal = new ConcurrentHashMap<String, LocalCountDownLatch>();
    private static final Map<String, RemoteCountDownLatch> f_mapLatch = new ConcurrentHashMap<String, RemoteCountDownLatch>();

    public static RemoteCountDownLatch remoteCountDownLatch(String sName, int count) {
        NamedMap<String, LatchCounter> map = Latches.latchesMap();
        return f_mapLatch.compute(sName, (k, v) -> {
            if (v == null) {
                long existingInitialCount = (Long)map.invoke((Object)sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                    if (entry.isPresent()) {
                        return ((LatchCounter)entry.getValue()).getInitialCount();
                    }
                    entry.setValue((Object)new LatchCounter(count));
                    return 0L;
                });
                if (existingInitialCount > 0L && existingInitialCount != (long)count) {
                    throw new IllegalArgumentException("The latch " + sName + " with a different initial count " + existingInitialCount + " already exists.");
                }
                return new RemoteCountDownLatch((String)k, count, map);
            }
            if (v.getInitialCount() != (long)count) {
                throw new IllegalArgumentException("The latch " + sName + " with a different initial count " + v.getInitialCount() + " already exists.");
            }
            return v;
        });
    }

    public static LocalCountDownLatch localCountDownLatch(String sName, int count) {
        return f_mapLatchLocal.computeIfAbsent(sName, k -> new LocalCountDownLatch(count));
    }

    protected static void removeCountDownLatch(String sName) {
        f_mapLatch.remove(sName);
    }

    protected static Session session() {
        return (Session)Coherence.findSession((String)SESSION_NAME).orElseThrow(() -> new IllegalStateException(String.format("The session '%s' has not been initialized", SESSION_NAME)));
    }

    protected static NamedMap<String, LatchCounter> latchesMap() {
        return Latches.session().getMap("latches-countdown", new NamedMap.Option[0]);
    }
}

