/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.ExtractorProducer;
import com.oracle.coherence.cdi.FilterProducer;
import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.SessionName;
import com.oracle.coherence.cdi.View;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;

@ApplicationScoped
public class NamedCacheProducer {
    private final BeanManager f_beanManager;
    private final FilterProducer f_filterProducer;
    private final ExtractorProducer f_extractorProducer;

    @Inject
    NamedCacheProducer(BeanManager beanManager, FilterProducer filterProducer, ExtractorProducer extractorProducer) {
        this.f_beanManager = beanManager;
        this.f_filterProducer = filterProducer;
        this.f_extractorProducer = extractorProducer;
    }

    @Produces
    <K, V> AsyncNamedCache<K, V> getNonQualifiedAsyncNamedCache(InjectionPoint injectionPoint) {
        return this.getAsyncNamedCache(injectionPoint);
    }

    @Produces
    @Name(value="")
    @SessionName(value="")
    <K, V> AsyncNamedCache<K, V> getAsyncNamedCache(InjectionPoint injectionPoint) {
        NamedCache<K, V> cache = this.getCache(injectionPoint);
        return cache.async();
    }

    @Produces
    <K, V> NamedCache<K, V> getNonQualifiedNamedCache(InjectionPoint injectionPoint) {
        return this.getCache(injectionPoint);
    }

    @Produces
    @Name(value="")
    @View
    @SessionName(value="")
    <K, V> NamedCache<K, V> getCache(InjectionPoint injectionPoint) {
        return this.getCacheInternal(injectionPoint, false);
    }

    @Produces
    @Typed(value={ContinuousQueryCache.class})
    <K, V_BACK, V_FRONT> ContinuousQueryCache<K, V_BACK, V_FRONT> getNonQualifiedCQC(InjectionPoint injectionPoint) {
        return this.getCQC(injectionPoint);
    }

    @Produces
    @Name(value="")
    @View
    @SessionName(value="")
    @Typed(value={ContinuousQueryCache.class})
    <K, V_BACK, V_FRONT> ContinuousQueryCache<K, V_BACK, V_FRONT> getCQC(InjectionPoint injectionPoint) {
        return (ContinuousQueryCache)this.getCacheInternal(injectionPoint, true);
    }

    <K, V_BACK, V_FRONT> void destroyCQC(@Disposes ContinuousQueryCache<K, V_BACK, V_FRONT> cqc) {
        this.destroyQualifiedCQC(cqc);
    }

    <K, V_BACK, V_FRONT> void destroyQualifiedCQC(@Disposes @Name(value="") @View @SessionName(value="") ContinuousQueryCache<K, V_BACK, V_FRONT> cqc) {
        cqc.destroy();
    }

    private <K, V, C extends NamedCache<K, V>> C getCacheInternal(InjectionPoint injectionPoint, boolean fView) {
        String sName = null;
        String sSession = "";
        boolean fCacheValues = true;
        for (Annotation annotation : injectionPoint.getQualifiers()) {
            if (Name.class.equals(annotation.annotationType())) {
                sName = ((Name)annotation).value();
                continue;
            }
            if (SessionName.class.equals(annotation.annotationType())) {
                sSession = ((SessionName)annotation).value();
                continue;
            }
            if (!View.class.equals(annotation.annotationType())) continue;
            fView = true;
            fCacheValues = ((View)annotation).cacheValues();
        }
        Member member = injectionPoint.getMember();
        if (sName == null || sName.trim().isEmpty()) {
            if (member == null) {
                throw new DefinitionException("Cannot determine cache name. No @Cache qualifier and injection point member is null");
            }
            sName = member.getName();
        }
        String sSessionName = sSession;
        Instance instance = this.f_beanManager.createInstance().select(Session.class, new Annotation[]{Name.Literal.of(sSessionName)});
        Session session = (Session)instance.get();
        NamedCache cache = session.getCache(sName, new NamedMap.Option[0]);
        if (fView) {
            Filter filter = this.f_filterProducer.getFilter(injectionPoint);
            ValueExtractor extractor = this.f_extractorProducer.getValueExtractor(injectionPoint);
            return (C)new ContinuousQueryCache(cache, filter, fCacheValues, null, extractor);
        }
        return (C)cache;
    }
}

