/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.AbstractCacheInterceptor;
import com.oracle.coherence.cdi.CoherenceExtension;
import com.oracle.coherence.cdi.Name;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;

@Interceptor
@Priority(value=1005)
public class CacheRemoveInterceptor
extends AbstractCacheInterceptor {
    @Inject
    public CacheRemoveInterceptor(@Name(value="") Coherence coherence, CoherenceExtension extension) {
        super(coherence, extension);
    }

    @AroundInvoke
    public Object cacheRemove(InvocationContext ctxInvocation) throws Exception {
        CoherenceExtension.MethodInterceptorInfo mi = this.getExtension().interceptorInfo(ctxInvocation.getMethod());
        if (mi == null) {
            throw new IllegalStateException("Method interceptor data not ready in CDI extension for method " + String.valueOf(ctxInvocation.getMethod()));
        }
        Session session = this.getSession(mi.sessionName());
        NamedCache cache = session.getCache(mi.cacheName(), new NamedMap.Option[0]);
        Object oKey = mi.cacheKeyFunction().apply(ctxInvocation.getParameters());
        cache.remove(oKey);
        return ctxInvocation.proceed();
    }
}

