/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.AnnotationInstance;
import com.oracle.coherence.cdi.ChainedExtractor;
import com.oracle.coherence.cdi.ExtractorBinding;
import com.oracle.coherence.cdi.ExtractorFactory;
import com.oracle.coherence.cdi.PofExtractor;
import com.oracle.coherence.cdi.PropertyExtractor;
import com.tangosol.util.Extractors;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@ApplicationScoped
public class ExtractorProducer {
    private final BeanManager f_beanManager;
    private final ValueExtractorFactoryResolver f_extractorFactoryResolver;

    @Inject
    ExtractorProducer(BeanManager beanManager, ValueExtractorFactoryResolver extractorFactoryResolver) {
        this.f_beanManager = beanManager;
        this.f_extractorFactoryResolver = extractorFactoryResolver;
    }

    @Produces
    public <T, E> ValueExtractor<T, E> getValueExtractor(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated != null) {
            return this.resolve(annotated.getAnnotations());
        }
        return null;
    }

    <T, E> ValueExtractor<T, E> resolve(Set<Annotation> annotations) {
        ArrayList list = new ArrayList();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(ExtractorBinding.class)) continue;
            Class<ExtractorFactory<Annotation, ?, ?>> clazz = this.f_extractorFactoryResolver.resolve(annotation);
            if (clazz != null) {
                ExtractorFactory supplier = (ExtractorFactory)this.f_beanManager.createInstance().select(clazz, new Annotation[0]).get();
                if (supplier == null) continue;
                ValueExtractor extractor = supplier.create(annotation);
                if (extractor instanceof MultiExtractor) {
                    Collections.addAll(list, ((MultiExtractor)extractor).getExtractors());
                    continue;
                }
                list.add(extractor);
                continue;
            }
            throw new DefinitionException("unsatisfied dependency - no ValueExtractorFactory bean found annotated with " + annotation);
        }
        ValueExtractor[] aExtractors = list.toArray(new ValueExtractor[0]);
        if (aExtractors.length == 0) {
            return null;
        }
        if (aExtractors.length == 1) {
            return aExtractors[0];
        }
        return Extractors.multi((ValueExtractor[])aExtractors);
    }

    static class ValueExtractorFactoryResolver {
        private Map<AnnotationInstance, Class<? extends ExtractorFactory<?, ?, ?>>> m_mapExtractorFactory;

        ValueExtractorFactoryResolver(Map<AnnotationInstance, Class<? extends ExtractorFactory<?, ?, ?>>> mapExtractorFactory) {
            this.m_mapExtractorFactory = mapExtractorFactory;
        }

        <A extends Annotation> Class<? extends ExtractorFactory<A, ?, ?>> resolve(A annotation) {
            AnnotationInstance instance = AnnotationInstance.create(annotation);
            return this.m_mapExtractorFactory.get(instance);
        }
    }

    @PofExtractor.Extractors(value={})
    @ApplicationScoped
    public static class PofExtractorsSupplier
    implements ExtractorFactory<PofExtractor.Extractors, Object, Object> {
        private final PofExtractorSupplier f_extractorSupplier = new PofExtractorSupplier();

        @Override
        public ValueExtractor<Object, Object> create(PofExtractor.Extractors annotation) {
            ValueExtractor[] extractors = (ValueExtractor[])Arrays.stream(annotation.value()).map(this.f_extractorSupplier::create).toArray(ValueExtractor[]::new);
            return Extractors.multi((ValueExtractor[])extractors);
        }
    }

    @PofExtractor
    @ApplicationScoped
    public static class PofExtractorSupplier
    implements ExtractorFactory<PofExtractor, Object, Object> {
        @Override
        public ValueExtractor<Object, Object> create(PofExtractor annotation) {
            Class<?> clazz = annotation.type().equals(Object.class) ? null : annotation.type();
            String sPath = annotation.path();
            int[] anIndex = annotation.index();
            if (sPath.length() == 0 && anIndex.length == 0) {
                throw new IllegalArgumentException("Neither 'index' nor 'path' are defined within @PofExtractor annotation. One is required.");
            }
            if (sPath.length() > 0 && anIndex.length > 0) {
                throw new IllegalArgumentException("Both 'index' and 'path' are defined within @PofExtractor annotation. Only one is allowed.");
            }
            if (sPath.length() > 0 && clazz == null) {
                throw new IllegalArgumentException("'type' must be specified within @PofExtractor annotation when property path is used.");
            }
            return sPath.length() > 0 ? Extractors.fromPof(clazz, (String)sPath) : Extractors.fromPof(clazz, (int[])anIndex);
        }
    }

    @ChainedExtractor.Extractors(value={})
    @ApplicationScoped
    public static class ChainedExtractorsSupplier
    implements ExtractorFactory<ChainedExtractor.Extractors, Object, Object> {
        private final ChainedExtractorSupplier f_ExtractorSupplier = new ChainedExtractorSupplier();

        @Override
        public ValueExtractor<Object, Object> create(ChainedExtractor.Extractors annotation) {
            ValueExtractor[] extractors = (ValueExtractor[])Arrays.stream(annotation.value()).map(this.f_ExtractorSupplier::create).toArray(ValueExtractor[]::new);
            return Extractors.multi((ValueExtractor[])extractors);
        }
    }

    @ChainedExtractor(value={""})
    @ApplicationScoped
    public static class ChainedExtractorSupplier
    implements ExtractorFactory<ChainedExtractor, Object, Object> {
        @Override
        public ValueExtractor<Object, Object> create(ChainedExtractor annotation) {
            return Extractors.chained((String[])annotation.value());
        }
    }

    @PropertyExtractor.Extractors(value={})
    @ApplicationScoped
    public static class UniversalExtractorsSupplier
    implements ExtractorFactory<PropertyExtractor.Extractors, Object, Object> {
        private final UniversalExtractorSupplier f_extractorSupplier = new UniversalExtractorSupplier();

        @Override
        public ValueExtractor<Object, Object> create(PropertyExtractor.Extractors annotation) {
            ValueExtractor[] extractors = (ValueExtractor[])Arrays.stream(annotation.value()).map(this.f_extractorSupplier::create).toArray(ValueExtractor[]::new);
            return Extractors.multi((ValueExtractor[])extractors);
        }
    }

    @PropertyExtractor(value="")
    @ApplicationScoped
    public static class UniversalExtractorSupplier
    implements ExtractorFactory<PropertyExtractor, Object, Object> {
        @Override
        public ValueExtractor<Object, Object> create(PropertyExtractor annotation) {
            return Extractors.extract((String)annotation.value());
        }
    }
}

