/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.AbstractCacheInterceptor;
import com.oracle.coherence.cdi.CoherenceExtension;
import com.oracle.coherence.cdi.Name;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@Priority(value=1005)
public class CacheGetInterceptor
extends AbstractCacheInterceptor {
    @Inject
    public CacheGetInterceptor(@Name(value="") Coherence coherence, CoherenceExtension extension) {
        super(coherence, extension);
    }

    @AroundInvoke
    public Object cacheGet(InvocationContext ctxInvocation) throws Exception {
        Object oKey;
        CoherenceExtension.MethodInterceptorInfo mi = this.getExtension().interceptorInfo(ctxInvocation.getMethod());
        if (mi == null) {
            throw new IllegalStateException("Method interceptor data not ready in CDI extension for method " + ctxInvocation.getMethod());
        }
        Session session = this.getSession(mi.sessionName());
        NamedCache cache = session.getCache(mi.cacheName(), new NamedMap.Option[0]);
        Object oValue = cache.get(oKey = mi.cacheKeyFunction().apply(ctxInvocation.getParameters()));
        if (oValue == null) {
            oValue = ctxInvocation.proceed();
            cache.put(oKey, oValue);
        }
        return oValue;
    }
}

