/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.RemoteMapLifecycleEvent;
import com.oracle.coherence.cdi.events.Created;
import com.oracle.coherence.cdi.events.Destroyed;
import com.oracle.coherence.cdi.events.Truncated;
import com.tangosol.net.NamedMap;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;

@ApplicationScoped
class RemoteMapLifecycleEventProducer
implements RemoteMapLifecycleEvent.Dispatcher {
    private final Event<RemoteMapLifecycleEvent> f_createdEventDispatcher;
    private final Event<RemoteMapLifecycleEvent> f_truncatedEventDispatcher;
    private final Event<RemoteMapLifecycleEvent> f_destroyedEventDispatcher;

    @Inject
    public RemoteMapLifecycleEventProducer(@Created Event<RemoteMapLifecycleEvent> created, @Truncated Event<RemoteMapLifecycleEvent> truncated, @Destroyed Event<RemoteMapLifecycleEvent> destroyed) {
        this.f_createdEventDispatcher = created;
        this.f_truncatedEventDispatcher = truncated;
        this.f_destroyedEventDispatcher = destroyed;
    }

    @Override
    public void dispatch(NamedMap<?, ?> map, String sScope, String sSession, String sService, RemoteMapLifecycleEvent.Type type) {
        RemoteMapEvent mapEvent = new RemoteMapEvent(map, sScope, sSession, sService, type);
        switch (type) {
            case Created: {
                this.f_createdEventDispatcher.fireAsync((Object)mapEvent);
                this.f_createdEventDispatcher.fire((Object)mapEvent);
                break;
            }
            case Truncated: {
                this.f_truncatedEventDispatcher.fireAsync((Object)mapEvent);
                this.f_truncatedEventDispatcher.fire((Object)mapEvent);
                break;
            }
            case Destroyed: {
                this.f_destroyedEventDispatcher.fireAsync((Object)mapEvent);
                this.f_destroyedEventDispatcher.fire((Object)mapEvent);
                break;
            }
        }
    }

    private static class RemoteMapEvent
    implements RemoteMapLifecycleEvent {
        private final NamedMap<?, ?> f_map;
        private final String f_sScope;
        private final String f_sSession;
        private final String f_sService;
        private final RemoteMapLifecycleEvent.Type f_type;

        private RemoteMapEvent(NamedMap<?, ?> map, String sScope, String sSession, String sService, RemoteMapLifecycleEvent.Type type) {
            this.f_map = Objects.requireNonNull(map);
            this.f_sScope = sScope == null ? "" : sScope;
            this.f_sSession = sSession == null ? "default" : sSession;
            this.f_sService = sService;
            this.f_type = Objects.requireNonNull(type);
        }

        @Override
        public String getMapName() {
            return this.f_map.getName();
        }

        @Override
        public String getScope() {
            return this.f_sScope;
        }

        @Override
        public String getSessionName() {
            return this.f_sSession;
        }

        @Override
        public String getServiceName() {
            return this.f_sService;
        }

        @Override
        public NamedMap<?, ?> getMap() {
            return this.f_map;
        }

        @Override
        public RemoteMapLifecycleEvent.Type getType() {
            return this.f_type;
        }
    }
}

