/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.ExtractorBinding;
import com.oracle.coherence.cdi.FilterBinding;
import com.oracle.coherence.cdi.FilterProducer;
import com.oracle.coherence.cdi.MapEventTransformerBinding;
import com.oracle.coherence.cdi.MapEventTransformerProducer;
import com.oracle.coherence.cdi.Remote;
import com.oracle.coherence.cdi.events.CacheName;
import com.oracle.coherence.cdi.events.Deleted;
import com.oracle.coherence.cdi.events.Inserted;
import com.oracle.coherence.cdi.events.Lite;
import com.oracle.coherence.cdi.events.MapName;
import com.oracle.coherence.cdi.events.ScopeName;
import com.oracle.coherence.cdi.events.ServiceName;
import com.oracle.coherence.cdi.events.Synchronous;
import com.oracle.coherence.cdi.events.Updated;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.MapListener;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.ObserverMethod;

public class CdiMapListener<K, V>
implements MapListener<K, V> {
    public static final String WILD_CARD = "*";
    private final ObserverMethod<MapEvent<K, V>> m_observer;
    private final String m_sCacheName;
    private final String m_sServiceName;
    private final String m_sScopeName;
    private final EnumSet<Type> m_setTypes = EnumSet.noneOf(Type.class);
    private final Set<Annotation> m_setAnnFilter;
    private final Set<Annotation> m_setAnnTransformer;
    private final Set<Annotation> m_setAnnExtractor;
    private String m_sRemoteSession;
    private boolean m_fLite;
    private boolean m_fSync;
    private Filter<?> m_filter;
    private MapEventTransformer<K, V, ?> m_transformer;

    CdiMapListener(ObserverMethod<MapEvent<K, V>> observer, Set<Annotation> annotations) {
        this.m_observer = observer;
        String sCache = WILD_CARD;
        String sService = WILD_CARD;
        String sScope = null;
        for (Annotation a2 : observer.getObservedQualifiers()) {
            if (a2 instanceof CacheName) {
                sCache = ((CacheName)a2).value();
                continue;
            }
            if (a2 instanceof MapName) {
                sCache = ((MapName)a2).value();
                continue;
            }
            if (a2 instanceof ServiceName) {
                sService = ((ServiceName)a2).value();
                continue;
            }
            if (a2 instanceof ScopeName) {
                sScope = ((ScopeName)a2).value();
                continue;
            }
            if (a2 instanceof Inserted) {
                this.addType(Type.INSERTED);
                continue;
            }
            if (a2 instanceof Updated) {
                this.addType(Type.UPDATED);
                continue;
            }
            if (a2 instanceof Deleted) {
                this.addType(Type.DELETED);
                continue;
            }
            if (!(a2 instanceof Remote)) continue;
            this.m_sRemoteSession = ((Remote)a2).value();
        }
        if (annotations.contains(Lite.Literal.INSTANCE)) {
            this.m_fLite = true;
        }
        if (annotations.contains(Synchronous.Literal.INSTANCE)) {
            this.m_fSync = true;
        }
        this.m_setAnnFilter = annotations.stream().filter(a -> a.annotationType().isAnnotationPresent(FilterBinding.class)).collect(Collectors.toSet());
        this.m_setAnnExtractor = annotations.stream().filter(a -> a.annotationType().isAnnotationPresent(ExtractorBinding.class)).collect(Collectors.toSet());
        this.m_setAnnTransformer = annotations.stream().filter(a -> a.annotationType().isAnnotationPresent(MapEventTransformerBinding.class)).collect(Collectors.toSet());
        this.m_sCacheName = sCache;
        this.m_sServiceName = sService;
        this.m_sScopeName = sScope;
    }

    public void entryInserted(MapEvent<K, V> event) {
        this.handle(Type.INSERTED, event);
    }

    public void entryUpdated(MapEvent<K, V> event) {
        this.handle(Type.UPDATED, event);
    }

    public void entryDeleted(MapEvent<K, V> event) {
        this.handle(Type.DELETED, event);
    }

    public boolean isRemote() {
        return this.m_sRemoteSession != null;
    }

    public String getRemoteSessionName() {
        return this.m_sRemoteSession;
    }

    public boolean hasFilterAnnotation() {
        return this.m_setAnnFilter != null && !this.m_setAnnFilter.isEmpty();
    }

    public void resolveFilter(FilterProducer producer) {
        if (this.m_filter == null && this.m_setAnnFilter != null && !this.m_setAnnFilter.isEmpty()) {
            this.m_filter = producer.resolve(this.m_setAnnFilter);
        }
    }

    public boolean hasTransformerAnnotation() {
        return !this.m_setAnnTransformer.isEmpty() || !this.m_setAnnExtractor.isEmpty();
    }

    public void resolveTransformer(MapEventTransformerProducer producer) {
        if (this.m_transformer != null) {
            return;
        }
        if (!this.m_setAnnTransformer.isEmpty()) {
            this.m_transformer = producer.resolve(this.m_setAnnTransformer);
        } else if (!this.m_setAnnExtractor.isEmpty()) {
            this.m_transformer = producer.resolve(this.m_setAnnExtractor);
        }
    }

    public Filter<?> getFilter() {
        return this.m_filter;
    }

    public MapEventTransformer getTransformer() {
        return this.m_transformer;
    }

    public String getCacheName() {
        return this.m_sCacheName;
    }

    public boolean isWildCardCacheName() {
        return WILD_CARD.equals(this.m_sCacheName);
    }

    public String getServiceName() {
        return this.m_sServiceName;
    }

    public boolean isWildCardServiceName() {
        return WILD_CARD.equals(this.m_sServiceName);
    }

    public String getScopeName() {
        return this.m_sScopeName;
    }

    public boolean isLite() {
        return this.m_fLite;
    }

    public boolean isSynchronous() {
        return this.m_fSync;
    }

    private void addType(Type type) {
        this.m_setTypes.add(type);
    }

    private boolean isSupported(Type type) {
        return this.m_setTypes.isEmpty() || this.m_setTypes.contains((Object)type);
    }

    private void handle(Type type, MapEvent<K, V> event) {
        if (this.isSupported(type)) {
            if (this.m_observer.isAsync()) {
                CompletableFuture.supplyAsync(() -> {
                    this.m_observer.notify((Object)event);
                    return event;
                });
            } else {
                this.m_observer.notify(event);
            }
        }
    }

    static enum Type {
        INSERTED,
        UPDATED,
        DELETED;

    }
}

