/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.AnnotationInstance;
import com.oracle.coherence.cdi.ExtractorBinding;
import com.oracle.coherence.cdi.ExtractorProducer;
import com.oracle.coherence.cdi.MapEventTransformerBinding;
import com.oracle.coherence.cdi.MapEventTransformerFactory;
import com.oracle.coherence.cdi.events.AnnotatedMapListener;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.transformer.ExtractorEventTransformer;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class MapEventTransformerProducer
implements AnnotatedMapListener.MapEventTransformerProducer {
    private final BeanManager f_beanManager;
    private final ExtractorProducer f_extractorProducer;
    private final MapEventTransformerFactoryResolver f_resolver;

    @Inject
    MapEventTransformerProducer(BeanManager beanManager, ExtractorProducer extractorProducer, MapEventTransformerFactoryResolver resolver) {
        this.f_beanManager = beanManager;
        this.f_extractorProducer = extractorProducer;
        this.f_resolver = resolver;
    }

    @Produces
    public <K, V, U> MapEventTransformer<K, V, U> getTransformer(InjectionPoint ip) {
        Annotated annotated = ip.getAnnotated();
        if (annotated != null) {
            return this.resolve(annotated.getAnnotations());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <K, V, U> MapEventTransformer<K, V, U> resolve(Set<Annotation> annotations) {
        Optional<Annotation> optional = annotations.stream().filter(a -> a.annotationType().isAnnotationPresent(MapEventTransformerBinding.class)).findFirst();
        if (optional.isPresent()) {
            Annotation annotation = optional.get();
            Class<MapEventTransformerFactory<Annotation, ?, ?, ?>> clazz = this.f_resolver.resolve(annotation);
            if (clazz == null) throw new DefinitionException("Unsatisfied dependency - no MapEventTransformerFactory bean found annotated with " + String.valueOf(annotation));
            MapEventTransformerFactory supplier = (MapEventTransformerFactory)this.f_beanManager.createInstance().select(clazz, new Annotation[0]).get();
            if (supplier == null) return null;
            return supplier.create(annotation);
        }
        if (!annotations.stream().anyMatch(a -> a.annotationType().isAnnotationPresent(ExtractorBinding.class))) return null;
        ValueExtractor extractor = this.f_extractorProducer.resolve(annotations);
        return new ExtractorEventTransformer(extractor);
    }

    static class MapEventTransformerFactoryResolver {
        private final Map<AnnotationInstance, Class<? extends MapEventTransformerFactory<?, ?, ?, ?>>> f_mapFactory;

        MapEventTransformerFactoryResolver(Map<AnnotationInstance, Class<? extends MapEventTransformerFactory<?, ?, ?, ?>>> map) {
            this.f_mapFactory = map;
        }

        <A extends Annotation> Class<? extends MapEventTransformerFactory<A, ?, ?, ?>> resolve(A annotation) {
            AnnotationInstance instance = AnnotationInstance.create(annotation);
            return this.f_mapFactory.get(instance);
        }
    }
}

