/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.AnnotationInstance;
import com.oracle.coherence.cdi.CacheAdd;
import com.oracle.coherence.cdi.CacheAddInterceptor;
import com.oracle.coherence.cdi.CacheGet;
import com.oracle.coherence.cdi.CacheGetInterceptor;
import com.oracle.coherence.cdi.CachePut;
import com.oracle.coherence.cdi.CachePutInterceptor;
import com.oracle.coherence.cdi.CacheRemove;
import com.oracle.coherence.cdi.CacheRemoveInterceptor;
import com.oracle.coherence.cdi.CacheValue;
import com.oracle.coherence.cdi.CdiEventObserver;
import com.oracle.coherence.cdi.CdiHelpers;
import com.oracle.coherence.cdi.CdiMapEventObserver;
import com.oracle.coherence.cdi.ExtractorBinding;
import com.oracle.coherence.cdi.ExtractorFactory;
import com.oracle.coherence.cdi.ExtractorProducer;
import com.oracle.coherence.cdi.FilterBinding;
import com.oracle.coherence.cdi.FilterFactory;
import com.oracle.coherence.cdi.FilterProducer;
import com.oracle.coherence.cdi.MapEventTransformerBinding;
import com.oracle.coherence.cdi.MapEventTransformerFactory;
import com.oracle.coherence.cdi.MapEventTransformerProducer;
import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.events.AnnotatedMapListener;
import com.oracle.coherence.cdi.events.EventObserverSupport;
import com.tangosol.net.Coherence;
import com.tangosol.net.SessionProvider;
import com.tangosol.net.events.CoherenceLifecycleEvent;
import com.tangosol.net.events.NamedEventInterceptor;
import com.tangosol.net.events.SessionLifecycleEvent;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.util.MapEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;

public class CoherenceExtension
implements Extension {
    private final Map<AnnotationInstance, Class<? extends FilterFactory<?, ?>>> m_mapFilterSupplier = new HashMap();
    private final Map<AnnotationInstance, Class<? extends ExtractorFactory<?, ?, ?>>> m_mapExtractorSupplier = new HashMap();
    private final Map<AnnotationInstance, Class<? extends MapEventTransformerFactory<?, ?, ?, ?>>> m_mapMapEventTransformerSupplier = new HashMap();
    private Coherence m_coherence;
    private final List<EventObserverSupport.EventHandler<?, ?>> m_listInterceptors = new ArrayList();
    private final List<AnnotatedMapListener<?, ?>> m_listListener = new ArrayList();
    private final Map<String, MethodInterceptorInfo> m_mapInterceptorCache = new HashMap<String, MethodInterceptorInfo>();

    private void processCoherenceLifecycleEventObservers(@Observes ProcessObserverMethod<CoherenceLifecycleEvent, ?> event) {
        this.m_listInterceptors.add(new EventObserverSupport.CoherenceLifecycleEventHandler(new CdiEventObserver<CoherenceLifecycleEvent>(event)));
    }

    private void processSessionLifecycleEventObservers(@Observes ProcessObserverMethod<SessionLifecycleEvent, ?> event) {
        this.m_listInterceptors.add(new EventObserverSupport.SessionLifecycleEventHandler(new CdiEventObserver<SessionLifecycleEvent>(event)));
    }

    private void processLifecycleEventObservers(@Observes ProcessObserverMethod<LifecycleEvent, ?> event) {
        this.m_listInterceptors.add(new EventObserverSupport.LifecycleEventHandler(new CdiEventObserver<LifecycleEvent>(event)));
    }

    private void processCacheLifecycleEventObservers(@Observes ProcessObserverMethod<CacheLifecycleEvent, ?> event) {
        this.m_listInterceptors.add(new EventObserverSupport.CacheLifecycleEventHandler(new CdiEventObserver<CacheLifecycleEvent>(event)));
    }

    private <K, V> void processMapEventObservers(@Observes ProcessObserverMethod<MapEvent<K, V>, ?> event) {
        this.m_listListener.add(new AnnotatedMapListener<K, V>(new CdiMapEventObserver<K, V>(event), event.getAnnotatedMethod().getAnnotations()));
    }

    private <T extends FilterFactory<?, ?>> void processFilterInjectionPoint(@Observes @WithAnnotations(value={FilterBinding.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        type.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(FilterBinding.class)).map(AnnotationInstance::create).forEach(a -> this.m_mapFilterSupplier.put((AnnotationInstance)a, type.getJavaClass()));
    }

    private <T extends ExtractorFactory<?, ?, ?>> void processValueExtractorInjectionPoint(@Observes @WithAnnotations(value={ExtractorBinding.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        type.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(ExtractorBinding.class)).map(AnnotationInstance::create).forEach(a -> this.m_mapExtractorSupplier.put((AnnotationInstance)a, type.getJavaClass()));
    }

    private <T extends MapEventTransformerFactory<?, ?, ?, ?>> void processMapEventTransformerInjectionPoint(@Observes @WithAnnotations(value={MapEventTransformerBinding.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        type.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(MapEventTransformerBinding.class)).map(AnnotationInstance::create).forEach(a -> this.m_mapMapEventTransformerSupplier.put((AnnotationInstance)a, type.getJavaClass()));
    }

    <T> void processCacheAnnotatedTypes(@Observes @WithAnnotations(value={CacheGet.class, CacheAdd.class, CachePut.class, CacheRemove.class}) ProcessAnnotatedType<T> event) {
        AnnotatedTypeConfigurator annotatedTypeConfigurator = event.configureAnnotatedType();
        AnnotatedType annotatedType = annotatedTypeConfigurator.getAnnotated();
        Set methods = annotatedTypeConfigurator.methods();
        for (AnnotatedMethodConfigurator methodConfigurator : methods) {
            String interceptorKey;
            AnnotatedMethod method = methodConfigurator.getAnnotated();
            if (method.getAnnotation(CacheGet.class) != null) {
                interceptorKey = this.makeInterceptorKey(method);
                this.m_mapInterceptorCache.put(interceptorKey, this.createInterceptorInfo((Annotated)annotatedType, method));
            }
            if (method.getAnnotation(CacheAdd.class) != null) {
                interceptorKey = this.makeInterceptorKey(method);
                this.m_mapInterceptorCache.put(interceptorKey, this.createInterceptorInfo((Annotated)annotatedType, method));
            }
            if (method.getAnnotation(CachePut.class) != null) {
                interceptorKey = this.makeInterceptorKey(method);
                MethodInterceptorInfo info = this.createInterceptorInfo((Annotated)annotatedType, method);
                if (info.getValueParameterIndex() == null) {
                    throw new IllegalStateException("@CacheValue annotation is missing on a parameter on @CachePut method " + interceptorKey);
                }
                this.m_mapInterceptorCache.put(interceptorKey, info);
            }
            if (method.getAnnotation(CacheRemove.class) == null) continue;
            interceptorKey = this.makeInterceptorKey(method);
            this.m_mapInterceptorCache.put(interceptorKey, this.createInterceptorInfo((Annotated)annotatedType, method));
        }
    }

    private String makeInterceptorKey(AnnotatedMethod<?> method) {
        String interceptorKey = this.methodCacheKey(method.getJavaMember());
        if (this.m_mapInterceptorCache.containsKey(interceptorKey)) {
            throw new IllegalStateException("Multiple cache annotation are not allowed on a method " + interceptorKey);
        }
        return interceptorKey;
    }

    private MethodInterceptorInfo createInterceptorInfo(Annotated annotatedType, AnnotatedMethod<?> method) {
        String cacheNameDef = CdiHelpers.cacheName(annotatedType, method);
        String sessionNameDef = CdiHelpers.sessionName(annotatedType, method);
        Function<Object[], Object> cacheKeyFunction = CdiHelpers.cacheKeyFunction(method);
        Integer valueParameterIndex = CdiHelpers.annotatedParameterIndex(method.getParameters(), CacheValue.class);
        return new MethodInterceptorInfo(cacheNameDef, sessionNameDef, cacheKeyFunction, valueParameterIndex);
    }

    MethodInterceptorInfo interceptorInfo(Method method) {
        return this.m_mapInterceptorCache.get(this.methodCacheKey(method));
    }

    private String methodCacheKey(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName() + "(" + Arrays.toString(method.getParameterTypes()) + ")";
    }

    void registerInterceptorBindings(@Observes BeforeBeanDiscovery event) {
        event.addInterceptorBinding(CacheGet.class, new Annotation[0]);
        event.addAnnotatedType(CacheGetInterceptor.class, CacheGetInterceptor.class.getName()).add((Annotation)CacheGet.Literal.INSTANCE).add((Annotation)Dependent.Literal.INSTANCE);
        event.addInterceptorBinding(CacheAdd.class, new Annotation[0]);
        event.addAnnotatedType(CacheAddInterceptor.class, CacheAddInterceptor.class.getName()).add((Annotation)CacheAdd.Literal.INSTANCE).add((Annotation)Dependent.Literal.INSTANCE);
        event.addInterceptorBinding(CachePut.class, new Annotation[0]);
        event.addAnnotatedType(CachePutInterceptor.class, CachePutInterceptor.class.getName()).add((Annotation)CachePut.Literal.INSTANCE).add((Annotation)Dependent.Literal.INSTANCE);
        event.addInterceptorBinding(CacheRemove.class, new Annotation[0]);
        event.addAnnotatedType(CacheRemoveInterceptor.class, CacheRemoveInterceptor.class.getName()).add((Annotation)CacheRemove.Literal.INSTANCE).add((Annotation)Dependent.Literal.INSTANCE);
    }

    private void addBeans(@Observes AfterBeanDiscovery event) {
        FilterProducer.FilterFactoryResolver filterResolver = new FilterProducer.FilterFactoryResolver(this.m_mapFilterSupplier);
        event.addBean().produceWith(i -> filterResolver).types(new Type[]{FilterProducer.FilterFactoryResolver.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).scope(ApplicationScoped.class).beanClass(FilterProducer.FilterFactoryResolver.class);
        ExtractorProducer.ValueExtractorFactoryResolver extractorResolver = new ExtractorProducer.ValueExtractorFactoryResolver(this.m_mapExtractorSupplier);
        event.addBean().produceWith(i -> extractorResolver).types(new Type[]{ExtractorProducer.ValueExtractorFactoryResolver.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).scope(ApplicationScoped.class).beanClass(ExtractorProducer.ValueExtractorFactoryResolver.class);
        MapEventTransformerProducer.MapEventTransformerFactoryResolver mapEventTransformerResolver = new MapEventTransformerProducer.MapEventTransformerFactoryResolver(this.m_mapMapEventTransformerSupplier);
        event.addBean().produceWith(i -> mapEventTransformerResolver).types(new Type[]{MapEventTransformerProducer.MapEventTransformerFactoryResolver.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).scope(ApplicationScoped.class).beanClass(MapEventTransformerProducer.MapEventTransformerFactoryResolver.class);
    }

    public List<AnnotatedMapListener<?, ?>> getMapListeners() {
        return this.m_listListener;
    }

    synchronized void startServer(@Observes @Priority(value=1) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        this.m_coherence = CoherenceExtension.ensureCoherence(beanManager);
    }

    List<EventObserverSupport.EventHandler<?, ?>> getInterceptors() {
        return this.m_listInterceptors;
    }

    public static Coherence ensureCoherence(BeanManager beanManager) {
        Instance instance = beanManager.createInstance().select(Coherence.class, new Annotation[]{Name.Literal.of("")});
        if (instance.isResolvable()) {
            return (Coherence)instance.get();
        }
        throw new IllegalStateException("Cannot resolve default Coherence instance");
    }

    synchronized void stopServer(@Observes BeforeShutdown event) {
        SessionProvider.get().close();
        if (this.m_coherence != null) {
            this.m_coherence.close();
        }
        Coherence.closeAll();
    }

    public Coherence getCoherence() {
        return this.m_coherence;
    }

    static class MethodInterceptorInfo {
        private final String m_cacheName;
        private final String m_sessionName;
        private final Function<Object[], Object> m_cacheKeyFunction;
        private final Integer m_valueParameterIndex;

        MethodInterceptorInfo(String cacheName, String sessionName, Function<Object[], Object> cacheKeyFunction, Integer valueParameterIndex) {
            this.m_cacheName = cacheName;
            this.m_cacheKeyFunction = cacheKeyFunction;
            this.m_sessionName = sessionName;
            this.m_valueParameterIndex = valueParameterIndex;
        }

        String cacheName() {
            return this.m_cacheName;
        }

        String sessionName() {
            return this.m_sessionName;
        }

        Function<Object[], Object> cacheKeyFunction() {
            return this.m_cacheKeyFunction;
        }

        public Integer getValueParameterIndex() {
            return this.m_valueParameterIndex;
        }
    }

    public static interface InterceptorProvider {
        public Iterable<NamedEventInterceptor<?>> getInterceptors();
    }
}

