/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import com.oracle.coherence.cdi.events.Backlog;
import com.oracle.coherence.cdi.events.CommittingLocal;
import com.oracle.coherence.cdi.events.CommittingRemote;
import com.oracle.coherence.cdi.events.Connecting;
import com.oracle.coherence.cdi.events.Disconnected;
import com.oracle.coherence.cdi.events.Error;
import com.oracle.coherence.cdi.events.EventObserverSupport;
import com.oracle.coherence.cdi.events.ParticipantName;
import com.oracle.coherence.cdi.events.Replicating;
import com.oracle.coherence.cdi.events.Synced;
import com.oracle.coherence.cdi.events.Syncing;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.federation.FederatedChangeEvent;
import com.tangosol.net.events.federation.FederatedConnectionEvent;
import com.tangosol.net.events.federation.FederatedPartitionEvent;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Function;

public class FederationEventHandlers {

    static class FederatedPartitionEventHandler
    extends FederationEventHandler<FederatedPartitionEvent, FederatedPartitionEvent.Type> {
        FederatedPartitionEventHandler(EventObserverSupport.EventObserver<FederatedPartitionEvent> observer) {
            super(observer, FederatedPartitionEvent.Type.class, FederatedPartitionEvent::getParticipant);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Syncing) {
                    this.addType((Enum)FederatedPartitionEvent.Type.SYNCING);
                    continue;
                }
                if (!(a instanceof Synced)) continue;
                this.addType((Enum)FederatedPartitionEvent.Type.SYNCED);
            }
        }
    }

    static class FederatedChangeEventHandler
    extends FederationEventHandler<FederatedChangeEvent, FederatedChangeEvent.Type> {
        FederatedChangeEventHandler(EventObserverSupport.EventObserver<FederatedChangeEvent> observer) {
            super(observer, FederatedChangeEvent.Type.class, FederatedChangeEvent::getParticipant);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof CommittingLocal) {
                    this.addType((Enum)FederatedChangeEvent.Type.COMMITTING_LOCAL);
                    continue;
                }
                if (a instanceof CommittingRemote) {
                    this.addType((Enum)FederatedChangeEvent.Type.COMMITTING_REMOTE);
                    continue;
                }
                if (!(a instanceof Replicating)) continue;
                this.addType((Enum)FederatedChangeEvent.Type.REPLICATING);
            }
        }
    }

    static class FederatedConnectionEventHandler
    extends FederationEventHandler<FederatedConnectionEvent, FederatedConnectionEvent.Type> {
        FederatedConnectionEventHandler(EventObserverSupport.EventObserver<FederatedConnectionEvent> observer) {
            super(observer, FederatedConnectionEvent.Type.class, FederatedConnectionEvent::getParticipantName);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Connecting) {
                    this.addType((Enum)FederatedConnectionEvent.Type.CONNECTING);
                    continue;
                }
                if (a instanceof Disconnected) {
                    this.addType((Enum)FederatedConnectionEvent.Type.DISCONNECTED);
                    continue;
                }
                if (a instanceof Backlog) {
                    Backlog backlog = (Backlog)a;
                    if (backlog.value() == Backlog.Type.EXCESSIVE) {
                        this.addType((Enum)FederatedConnectionEvent.Type.BACKLOG_EXCESSIVE);
                        continue;
                    }
                    this.addType((Enum)FederatedConnectionEvent.Type.BACKLOG_NORMAL);
                    continue;
                }
                if (!(a instanceof Error)) continue;
                this.addType((Enum)FederatedConnectionEvent.Type.ERROR);
            }
        }
    }

    static abstract class FederationEventHandler<E extends Event<T>, T extends Enum<T>>
    extends EventObserverSupport.ServiceEventHandler<E, T> {
        protected final String m_participantName;
        protected final Function<E, String> m_fnParticipantName;

        protected FederationEventHandler(EventObserverSupport.EventObserver<E> observer, Class<T> classType, Function<E, String> fnParticipantName) {
            super(observer, classType);
            this.m_fnParticipantName = fnParticipantName;
            String participantName = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (!(a instanceof ParticipantName)) continue;
                participantName = ((ParticipantName)a).value();
            }
            this.m_participantName = participantName;
        }

        protected boolean isApplicable(EventDispatcher dispatcher, String sScopeName) {
            Set setSupported = dispatcher.getSupportedTypes();
            boolean fMatch = this.m_setTypes.stream().anyMatch(setSupported::contains);
            return fMatch && super.isApplicable(dispatcher, sScopeName);
        }

        protected boolean shouldFire(E event) {
            return this.m_participantName == null || this.m_participantName.equals(this.m_fnParticipantName.apply(event));
        }
    }
}

