/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.CDI;

public class BeanBuilder
implements ParameterizedBuilder<Object>,
ParameterizedBuilder.ReflectionSupport {
    private final Expression<String> f_exprBeanName;
    private final CDI<Object> f_cdi;

    BeanBuilder(CDI<Object> cdi, String exprBeanName) {
        this.f_cdi = Objects.requireNonNull(cdi);
        this.f_exprBeanName = new LiteralExpression((Object)exprBeanName);
    }

    public Object realize(ParameterResolver resolver, ClassLoader loader, ParameterList parameterList) {
        String beanName = (String)this.f_exprBeanName.evaluate(resolver);
        Instance instance = this.f_cdi.select(new Annotation[]{NamedLiteral.of((String)beanName)});
        if (instance.isResolvable()) {
            return instance.get();
        }
        throw new ConfigurationException(String.format("CDI bean [%s] cannot be resolved", beanName), "Please ensure that a bean with that name exists and can be discovered by CDI.");
    }

    public boolean realizes(Class<?> aClass, ParameterResolver resolver, ClassLoader loader) {
        String beanName = (String)this.f_exprBeanName.evaluate(resolver);
        Instance instance = this.f_cdi.select(aClass, new Annotation[]{NamedLiteral.of((String)beanName)});
        return instance.isResolvable();
    }
}

