/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import com.oracle.coherence.cdi.server.CdiInterceptorSupport;
import com.oracle.coherence.cdi.server.ScopeInitializer;
import com.oracle.coherence.common.collections.ConcurrentHashMap;
import com.tangosol.config.ConfigurationException;
import com.tangosol.net.CacheFactoryBuilder;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultCacheServer;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.ScopedCacheFactoryBuilder;
import com.tangosol.net.ServiceMonitor;
import com.tangosol.net.SimpleServiceMonitor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.net.events.partition.TransactionEvent;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.events.partition.UnsolicitedCommitEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.net.events.partition.cache.EntryProcessorEvent;
import com.tangosol.util.RegistrationBehavior;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;

public class CoherenceServerExtension
implements Extension {
    private BeanManager m_beanManager;
    private CdiCacheFactoryBuilder m_cacheFactoryBuilder;
    private final List<ConfigurableCacheFactory> f_listCCF = new ArrayList<ConfigurableCacheFactory>();
    private final List<ServiceMonitor> f_listServiceMonitors = new ArrayList<ServiceMonitor>();
    private ConfigurableCacheFactory m_ccfSys;
    private ConfigurableCacheFactory m_ccfApp;
    private final List<CdiInterceptorSupport.EventHandler<?, ?>> m_listInterceptors = new ArrayList();

    private void processLifecycleEventObservers(@Observes ProcessObserverMethod<LifecycleEvent, ?> event) {
        this.m_listInterceptors.add(new CdiInterceptorSupport.LifecycleEventHandler((ObserverMethod<LifecycleEvent>)event.getObserverMethod()));
    }

    private void processCacheLifecycleEventObservers(@Observes ProcessObserverMethod<CacheLifecycleEvent, ?> event) {
        this.m_listInterceptors.add(new CdiInterceptorSupport.CacheLifecycleEventHandler((ObserverMethod<CacheLifecycleEvent>)event.getObserverMethod()));
    }

    private <K, V> void processEntryEventObservers(@Observes ProcessObserverMethod<EntryEvent<K, V>, ?> event) {
        this.m_listInterceptors.add(new CdiInterceptorSupport.EntryEventHandler(event.getObserverMethod()));
    }

    private void processEntryProcessorEventObservers(@Observes ProcessObserverMethod<EntryProcessorEvent, ?> event) {
        this.m_listInterceptors.add(new CdiInterceptorSupport.EntryProcessorEventHandler((ObserverMethod<EntryProcessorEvent>)event.getObserverMethod()));
    }

    private void processTransactionEventObservers(@Observes ProcessObserverMethod<TransactionEvent, ?> event) {
        this.m_listInterceptors.add(new CdiInterceptorSupport.TransactionEventHandler((ObserverMethod<TransactionEvent>)event.getObserverMethod()));
    }

    private void processTransferEventObservers(@Observes ProcessObserverMethod<TransferEvent, ?> event) {
        this.m_listInterceptors.add(new CdiInterceptorSupport.TransferEventHandler((ObserverMethod<TransferEvent>)event.getObserverMethod()));
    }

    private void processUnsolicitedCommitEventObservers(@Observes ProcessObserverMethod<UnsolicitedCommitEvent, ?> event) {
        this.m_listInterceptors.add(new CdiInterceptorSupport.UnsolicitedCommitEventHandler((ObserverMethod<UnsolicitedCommitEvent>)event.getObserverMethod()));
    }

    synchronized void startServer(@Observes @Priority(value=1) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        this.m_beanManager = beanManager;
        CdiCacheFactoryBuilder cfb = this.m_cacheFactoryBuilder = new CdiCacheFactoryBuilder();
        ConfigurableCacheFactory ccfSys = this.m_ccfSys = cfb.getConfigurableCacheFactory("coherence-system-config.xml", null);
        this.initializeConfigurableCacheFactory(ccfSys);
        Instance initializers = beanManager.createInstance().select(ScopeInitializer.class, new Annotation[]{Any.Literal.INSTANCE});
        for (ScopeInitializer initializer : initializers) {
            ConfigurableCacheFactory ccf = initializer.getConfigurableCacheFactory((CacheFactoryBuilder)cfb);
            if (ccf == null) continue;
            this.initializeConfigurableCacheFactory(ccf);
        }
        ConfigurableCacheFactory ccfApp = this.m_ccfApp = cfb.getConfigurableCacheFactory(null);
        this.initializeConfigurableCacheFactory(ccfApp);
        DefaultCacheServer.startServerDaemon((ConfigurableCacheFactory)ccfApp).waitForServiceStart();
    }

    synchronized void stopServer(@Observes BeforeShutdown event) {
        this.f_listServiceMonitors.forEach(ServiceMonitor::stopMonitoring);
        this.f_listCCF.forEach(ConfigurableCacheFactory::dispose);
        DefaultCacheServer.shutdown();
    }

    public void initializeConfigurableCacheFactory(ConfigurableCacheFactory ccf) {
        this.registerInterceptors(ccf);
        ccf.getResourceRegistry().registerResource(BeanManager.class, "beanManager", (Object)this.m_beanManager);
        ccf.activate();
        this.f_listCCF.add(0, ccf);
        if (ccf instanceof ExtensibleConfigurableCacheFactory) {
            ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)ccf;
            SimpleServiceMonitor serviceMon = new SimpleServiceMonitor();
            serviceMon.setConfigurableCacheFactory((ConfigurableCacheFactory)eccf);
            serviceMon.registerServices(eccf.getServiceMap());
            this.f_listServiceMonitors.add(0, (ServiceMonitor)serviceMon);
        }
    }

    public CdiCacheFactoryBuilder getCacheFactoryBuilder() {
        return this.m_cacheFactoryBuilder;
    }

    public ConfigurableCacheFactory getDefaultCacheFactory() {
        return this.m_ccfApp;
    }

    ConfigurableCacheFactory getSystemCacheFactory() {
        return this.m_ccfSys;
    }

    ConfigurableCacheFactory registerInterceptors(ConfigurableCacheFactory ccf) {
        InterceptorRegistry registry = ccf.getInterceptorRegistry();
        for (CdiInterceptorSupport.EventHandler<?, ?> handler : this.m_listInterceptors) {
            if (handler.getScopeName() != null && !handler.getScopeName().equals(ccf.getScopeName())) continue;
            registry.registerEventInterceptor(handler.getId(), handler, RegistrationBehavior.FAIL);
        }
        return ccf;
    }

    static class CdiCacheFactoryBuilder
    extends ScopedCacheFactoryBuilder {
        private static final String DEFAULT_CONFIG = "coherence-config.xml";
        private final Map<String, ConfigurableCacheFactory> f_mapByScope = new ConcurrentHashMap();

        public CdiCacheFactoryBuilder() {
            super((sConfigURI, loader, sScopeName) -> {
                String[] asParts = sConfigURI.split("@");
                return asParts.length > 1 ? asParts[0] : sScopeName;
            });
        }

        protected String resolveURI(String sConfigURI) {
            String[] asParts = sConfigURI.split("@");
            if (asParts.length > 1) {
                sConfigURI = asParts[1];
            }
            return "$Default$".equals(sConfigURI) ? DEFAULT_CONFIG : super.resolveURI(sConfigURI);
        }

        protected ConfigurableCacheFactory buildFactory(String sConfigURI, ClassLoader loader) {
            ConfigurableCacheFactory previous;
            ConfigurableCacheFactory ccf = super.buildFactory(sConfigURI, loader);
            String sScope = ccf.getScopeName();
            if (sScope != null && !sScope.isEmpty() && (previous = this.f_mapByScope.putIfAbsent(sScope, ccf)) != null) {
                throw new ConfigurationException("Non-unique ConfigurableCacheFactory scope", "Make sure that each scoped cache factory has a unique scope name.");
            }
            return ccf;
        }

        ConfigurableCacheFactory getConfigurableCacheFactory(String sScopeName) {
            return this.f_mapByScope.get(sScopeName);
        }
    }
}

