/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.CDI;

public class BeanBuilder
implements ParameterizedBuilder<Object>,
ParameterizedBuilder.ReflectionSupport {
    private final Expression<String> m_exprBeanName;

    BeanBuilder(String exprBeanName) {
        this.m_exprBeanName = new LiteralExpression((Object)exprBeanName);
    }

    public Object realize(ParameterResolver resolver, ClassLoader loader, ParameterList parameterList) {
        String beanName = (String)this.m_exprBeanName.evaluate(resolver);
        Instance instance = CDI.current().select(new Annotation[]{NamedLiteral.of((String)beanName)});
        if (instance.isResolvable()) {
            return instance.get();
        }
        throw new ConfigurationException(String.format("CDI bean [%s] cannot be resolved", beanName), "Please ensure that a bean with that name exists and can be discovered by CDI.");
    }

    public boolean realizes(Class<?> aClass, ParameterResolver resolver, ClassLoader loader) {
        String beanName = (String)this.m_exprBeanName.evaluate(resolver);
        Instance instance = CDI.current().select(aClass, new Annotation[]{NamedLiteral.of((String)beanName)});
        return instance.isResolvable();
    }
}

