/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import com.oracle.coherence.cdi.Scope;
import com.oracle.coherence.cdi.server.CoherenceServerExtension;
import com.oracle.coherence.cdi.server.ConfigurableCacheFactoryProducer;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Session;
import com.tangosol.util.Base;
import java.lang.reflect.Member;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class SessionProducer {
    private final ConfigurableCacheFactoryProducer f_ccfProducer;
    private final CoherenceServerExtension f_extension;

    @Inject
    SessionProducer(CoherenceServerExtension extension, ConfigurableCacheFactoryProducer ccfProducer) {
        this.f_extension = extension;
        this.f_ccfProducer = ccfProducer;
    }

    @Produces
    public Session getDefaultSession(InjectionPoint injectionPoint) {
        return this.getScopedSession(injectionPoint);
    }

    @Produces
    @Scope
    public Session getScopedSession(InjectionPoint injectionPoint) {
        String sScope = injectionPoint.getQualifiers().stream().filter(q -> q.annotationType().isAssignableFrom(Scope.class)).map(q -> ((Scope)q).value().trim()).findFirst().orElse(null);
        Member member = injectionPoint.getMember();
        ClassLoader loader = member == null ? Base.getContextClassLoader() : member.getDeclaringClass().getClassLoader();
        ConfigurableCacheFactory ccf = sScope == null || sScope.isEmpty() ? this.f_extension.getDefaultCacheFactory() : this.f_ccfProducer.getConfigurableCacheFactory(sScope, injectionPoint);
        return new ConfigurableCacheFactorySession(ccf, loader);
    }
}

