/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import com.oracle.coherence.cdi.ExtractorProducer;
import com.oracle.coherence.cdi.FilterProducer;
import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.Scope;
import com.oracle.coherence.cdi.View;
import com.oracle.coherence.cdi.server.ConfigurableCacheFactoryProducer;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
class NamedCacheProducer {
    private final ConfigurableCacheFactoryProducer m_cacheFactoryProducer;
    private final FilterProducer m_filterProducer;
    private final ExtractorProducer m_extractorProducer;

    @Inject
    NamedCacheProducer(ConfigurableCacheFactoryProducer cacheFactoryProducer, FilterProducer filterProducer, ExtractorProducer extractorProducer) {
        this.m_cacheFactoryProducer = cacheFactoryProducer;
        this.m_filterProducer = filterProducer;
        this.m_extractorProducer = extractorProducer;
    }

    @Produces
    <K, V> AsyncNamedCache<K, V> getNonQualifiedAsyncNamedCache(InjectionPoint injectionPoint) {
        return this.getAsyncNamedCache(injectionPoint);
    }

    @Produces
    @Name(value="")
    @Scope(value="")
    <K, V> AsyncNamedCache<K, V> getAsyncNamedCache(InjectionPoint injectionPoint) {
        NamedCache<K, V> cache = this.getCache(injectionPoint);
        return cache.async();
    }

    @Produces
    <K, V> NamedCache<K, V> getNonQualifiedNamedCache(InjectionPoint injectionPoint) {
        return this.getCache(injectionPoint);
    }

    @Produces
    @Name(value="")
    @View
    @Scope(value="")
    <K, V> NamedCache<K, V> getCache(InjectionPoint injectionPoint) {
        return this.getCacheInternal(injectionPoint, false);
    }

    @Produces
    @Typed(value={ContinuousQueryCache.class})
    <K, V_BACK, V_FRONT> ContinuousQueryCache<K, V_BACK, V_FRONT> getNonQualifiedCQC(InjectionPoint injectionPoint) {
        return this.getCQC(injectionPoint);
    }

    @Produces
    @Name(value="")
    @View
    @Scope(value="")
    @Typed(value={ContinuousQueryCache.class})
    <K, V_BACK, V_FRONT> ContinuousQueryCache<K, V_BACK, V_FRONT> getCQC(InjectionPoint injectionPoint) {
        return (ContinuousQueryCache)this.getCacheInternal(injectionPoint, true);
    }

    <K, V_BACK, V_FRONT> void destroyCQC(@Disposes ContinuousQueryCache<K, V_BACK, V_FRONT> cqc) {
        this.destroyQualifiedCQC(cqc);
    }

    <K, V_BACK, V_FRONT> void destroyQualifiedCQC(@Disposes @Name(value="") @View @Scope(value="") ContinuousQueryCache<K, V_BACK, V_FRONT> cqc) {
        cqc.destroy();
    }

    private <K, V, C extends NamedCache<K, V>> C getCacheInternal(InjectionPoint injectionPoint, boolean fView) {
        String sName = null;
        String sSession = null;
        boolean fCacheValues = true;
        for (Annotation annotation : injectionPoint.getQualifiers()) {
            if (Name.class.equals(annotation.annotationType())) {
                sName = ((Name)annotation).value();
                continue;
            }
            if (Scope.class.equals(annotation.annotationType())) {
                sSession = ((Scope)annotation).value();
                continue;
            }
            if (!View.class.equals(annotation.annotationType())) continue;
            fView = true;
            fCacheValues = ((View)annotation).cacheValues();
        }
        Member member = injectionPoint.getMember();
        if (sName == null || sName.trim().isEmpty()) {
            if (member == null) {
                throw new DefinitionException("Cannot determine cache name. No @Cache qualifier and injection point member is null");
            }
            sName = member.getName();
        }
        ConfigurableCacheFactory ccf = this.m_cacheFactoryProducer.getConfigurableCacheFactory(sSession, injectionPoint);
        ClassLoader loader = member == null ? Base.getContextClassLoader() : member.getDeclaringClass().getClassLoader();
        NamedCache cache = ccf.ensureCache(sName, loader);
        if (fView) {
            Filter filter = this.m_filterProducer.getFilter(injectionPoint);
            ValueExtractor extractor = this.m_extractorProducer.getValueExtractor(injectionPoint);
            return (C)new ContinuousQueryCache(cache, filter, fCacheValues, null, extractor);
        }
        return (C)cache;
    }
}

