/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.Service;
import java.util.Collection;

public class GetExtendConnectionCount
implements RemoteCallable<Integer> {
    private final String m_sProxyServiceName;

    public GetExtendConnectionCount(String sProxyServiceName) {
        this.m_sProxyServiceName = sProxyServiceName;
    }

    public Integer call() throws Exception {
        Cluster cluster = CacheFactory.getCluster();
        Service service = cluster.getService(this.m_sProxyServiceName);
        if (service instanceof SafeService) {
            service = ((SafeService)service).getService();
        }
        if (service instanceof ProxyService) {
            Collection colConnection = ((ProxyService)service).getAcceptor().getConnections();
            return colConnection == null ? 0 : colConnection.size();
        }
        throw new IllegalArgumentException("Service " + this.m_sProxyServiceName + " is not a ProxyService");
    }
}

