/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import java.util.Objects;

public class WellKnownAddress
implements Profile,
Option {
    public static final String PROPERTY = "coherence.wka";
    public static final String PROPERTY_PORT = "coherence.wka.port";
    private final String address;

    private WellKnownAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public static WellKnownAddress of(String address) {
        return new WellKnownAddress(address);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (String)this.address, (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WellKnownAddress)) {
            return false;
        }
        WellKnownAddress that = (WellKnownAddress)o;
        return !Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        return this.address != null ? this.address.hashCode() : 0;
    }

    public String toString() {
        return "WellKnownAddress(" + this.address + "')";
    }
}

