/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import java.util.Objects;

public class WellKnownAddress
implements Profile,
Option {
    public static final String PROPERTY = "coherence.wka";
    public static final String PROPERTY_PORT = "coherence.wka.port";
    private final String m_sAddress;

    private WellKnownAddress(String address) {
        this.m_sAddress = address;
    }

    public String getsAddress() {
        return this.m_sAddress;
    }

    public static WellKnownAddress loopback() {
        return new WellKnownAddress("127.0.0.1");
    }

    public static WellKnownAddress of(String address) {
        return new WellKnownAddress(address);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (String)this.m_sAddress, (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WellKnownAddress that = (WellKnownAddress)o;
        return Objects.equals(this.m_sAddress, that.m_sAddress);
    }

    public int hashCode() {
        return Objects.hash(this.m_sAddress);
    }

    public String toString() {
        return "WellKnownAddress(" + this.m_sAddress + "')";
    }
}

