/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.profiles;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;

public class LambdaModeProfile
implements Profile,
Option {
    public static final String PROP_LAMBDAS = "coherence.lambdas";
    private final String m_sValue;

    @OptionsByType.Default
    public LambdaModeProfile(String sParam) {
        if (!"static".equals(sParam) && !"dynamic".equals(sParam)) {
            throw new IllegalStateException("Invalid lambda mode parameter, must be \"static\" or \"dynamic\"");
        }
        this.m_sValue = sParam;
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties properties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        SystemProperty property = properties.get(PROP_LAMBDAS);
        if (property == null) {
            optionsByType.add((Option)SystemProperty.of((String)PROP_LAMBDAS, (String)this.m_sValue, (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }
}

