/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.Service;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class FindExtendProxyPort
implements RemoteCallable<Integer> {
    public static final FindExtendProxyPort INSTANCE = new FindExtendProxyPort();
    private final String m_sServiceName;

    public FindExtendProxyPort() {
        this("Proxy");
    }

    public FindExtendProxyPort(String sServiceName) {
        this.m_sServiceName = sServiceName;
    }

    public Integer call() {
        return this.findPort(this.m_sServiceName);
    }

    private int findPort(String sServiceName) {
        Cluster cluster = CacheFactory.getCluster();
        Service service = cluster.getService(sServiceName);
        if (service instanceof SafeService) {
            service = ((SafeService)service).getService();
        }
        if (service instanceof ProxyService) {
            ProxyService proxyService = (ProxyService)service;
            TcpAcceptor acceptor = (TcpAcceptor)proxyService.getAcceptor();
            SocketAddress address = acceptor.getLocalAddress();
            if (address instanceof InetSocketAddress) {
                return ((InetSocketAddress)address).getPort();
            }
            if (address instanceof InetSocketAddress32) {
                return ((InetSocketAddress32)address).getPort();
            }
        }
        return -1;
    }

    public static int local() {
        return FindExtendProxyPort.local("Proxy");
    }

    public static int local(String sServiceName) {
        return INSTANCE.findPort(sServiceName);
    }
}

