/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.Platform;

public interface MetaClass<A extends Application> {
    public Class<? extends A> getImplementationClass(Platform var1, OptionsByType var2);

    public void onLaunching(Platform var1, OptionsByType var2);

    public void onLaunch(Platform var1, OptionsByType var2);

    public void onLaunched(Platform var1, A var2, OptionsByType var3);

    public static <A extends Application> MetaClass<A> of(Class<?> applicationClass) {
        Class<?> metaClassClass = null;
        Class<?>[] declaredClasses = applicationClass.getDeclaredClasses();
        for (int i = 0; i < declaredClasses.length && metaClassClass == null; ++i) {
            if (!MetaClass.class.isAssignableFrom(declaredClasses[i])) continue;
            metaClassClass = declaredClasses[i];
        }
        if (metaClassClass == null) {
            Class<?> superClass;
            MetaClass<A> metaClass = null;
            Class<?>[] interfaces = applicationClass.getInterfaces();
            for (int i = 0; i < interfaces.length && metaClass == null; ++i) {
                metaClass = MetaClass.of(interfaces[i]);
            }
            if (metaClass == null && (superClass = applicationClass.getSuperclass()) != null && !superClass.equals(Object.class)) {
                metaClass = MetaClass.of(superClass);
            }
            return metaClass;
        }
        try {
            return (MetaClass)metaClassClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to create MetaClass instance for " + String.valueOf(applicationClass), e);
        }
    }
}

