/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.profiles;

import be.frma.langguess.LangProfileReader;
import com.optimaize.langdetect.profiles.BuiltInLanguages;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.OldLangProfileConverter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LanguageProfileReader {
    private static final LangProfileReader internalReader = new LangProfileReader();
    private static final String PROFILES_DIR = "languages";

    public LanguageProfile read(File profileFile) throws IOException {
        return OldLangProfileConverter.convert(internalReader.read(profileFile));
    }

    public LanguageProfile read(InputStream inputStream) throws IOException {
        return OldLangProfileConverter.convert(internalReader.read(inputStream));
    }

    public List<LanguageProfile> read(ClassLoader classLoader, String profileDirectory, Collection<String> languages) throws IOException {
        ArrayList<LanguageProfile> loaded = new ArrayList<LanguageProfile>(languages.size());
        for (String language : languages) {
            String fullpath = profileDirectory + '/' + language;
            InputStream in = classLoader.getResourceAsStream(fullpath);
            Throwable throwable = null;
            try {
                if (in == null) {
                    throw new IOException("No language file available for language " + language + "!");
                }
                loaded.add(this.read(in));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                in.close();
            }
        }
        return loaded;
    }

    public List<LanguageProfile> read(String profileDirectory, Collection<String> languages) throws IOException {
        return this.read(LanguageProfileReader.class.getClassLoader(), profileDirectory, languages);
    }

    public List<LanguageProfile> read(Collection<String> languages) throws IOException {
        return this.read(LanguageProfileReader.class.getClassLoader(), PROFILES_DIR, languages);
    }

    public List<LanguageProfile> readAll() throws IOException {
        List<String> strings = BuiltInLanguages.getLanguages();
        return this.read(strings);
    }

    public List<LanguageProfile> readAll(File path) throws IOException {
        if (!path.exists()) {
            throw new IOException("No such folder: " + path);
        }
        if (!path.canRead()) {
            throw new IOException("Folder not readable: " + path);
        }
        File[] listFiles = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return LanguageProfileReader.this.looksLikeLanguageProfileFile(pathname);
            }
        });
        if (listFiles == null) {
            throw new IOException("Failed reading from folder: " + path);
        }
        ArrayList<LanguageProfile> profiles = new ArrayList<LanguageProfile>(listFiles.length);
        for (File file : listFiles) {
            if (!this.looksLikeLanguageProfileFile(file)) continue;
            profiles.add(this.read(file));
        }
        return profiles;
    }

    private boolean looksLikeLanguageProfileFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        return this.looksLikeLanguageProfileName(file.getName());
    }

    private boolean looksLikeLanguageProfileName(String fileName) {
        if (fileName.startsWith(".")) {
            return false;
        }
        return fileName.matches("^[a-z]{2,3}$") || fileName.matches("^[a-z]{2}\\-[a-z]{2}$");
    }
}

