/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.profiles;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.optimaize.langdetect.profiles.LanguageProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class LanguageProfileImpl
implements LanguageProfile {
    @NotNull
    private final String language;
    @NotNull
    private final Map<Integer, Map<String, Integer>> ngrams;
    @NotNull
    private final Map<Integer, Long> numOccurrences;

    LanguageProfileImpl(@NotNull String language, @NotNull Map<Integer, Map<String, Integer>> ngrams) {
        this.language = language;
        this.ngrams = ImmutableMap.copyOf(ngrams);
        this.numOccurrences = LanguageProfileImpl.computeNumOccurrences(ngrams);
    }

    private static Map<Integer, Long> computeNumOccurrences(Map<Integer, Map<String, Integer>> ngrams) {
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(6);
        for (Map.Entry<Integer, Map<String, Integer>> entry : ngrams.entrySet()) {
            long count = 0L;
            for (Integer integer : entry.getValue().values()) {
                count += (long)integer.intValue();
            }
            map.put(entry.getKey(), count);
        }
        return map;
    }

    @Override
    @NotNull
    public String getLanguage() {
        return this.language;
    }

    @Override
    @NotNull
    public List<Integer> getGramLengths() {
        ArrayList<Integer> lengths = new ArrayList<Integer>(this.ngrams.keySet());
        Collections.sort(lengths);
        return lengths;
    }

    @Override
    public int getFrequency(String gram) {
        Map<String, Integer> map = this.ngrams.get(gram.length());
        if (map == null) {
            return 0;
        }
        Integer freq = map.get(gram);
        if (freq == null) {
            return 0;
        }
        return freq;
    }

    @Override
    public int getNumGrams(int gramLength) {
        if (gramLength < 1) {
            throw new IllegalArgumentException("" + gramLength);
        }
        Map<String, Integer> map = this.ngrams.get(gramLength);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    @Override
    public int getNumGrams() {
        int ret = 0;
        for (Map<String, Integer> stringIntegerMap : this.ngrams.values()) {
            ret += stringIntegerMap.size();
        }
        return ret;
    }

    @Override
    public long getNumGramOccurrences(int gramLength) {
        Long aLong = this.numOccurrences.get(gramLength);
        if (aLong == null) {
            return 0L;
        }
        return aLong;
    }

    @Override
    @NotNull
    public Iterable<Map.Entry<String, Integer>> iterateGrams() {
        Iterable[] arr = new Iterable[this.ngrams.size()];
        int i = 0;
        for (Map<String, Integer> stringIntegerMap : this.ngrams.values()) {
            arr[i] = stringIntegerMap.entrySet();
            ++i;
        }
        return Iterables.concat((Iterable[])arr);
    }

    @Override
    @NotNull
    public Iterable<Map.Entry<String, Integer>> iterateGrams(int gramLength) {
        return this.ngrams.get(gramLength).entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LanguageProfile{lang=");
        sb.append(this.language);
        for (Integer integer : this.getGramLengths()) {
            sb.append(",");
            sb.append(integer);
            sb.append("-grams=");
            sb.append(this.getNumGrams(integer));
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageProfileImpl that = (LanguageProfileImpl)o;
        if (!this.language.equals(that.language)) {
            return false;
        }
        if (!this.ngrams.equals(that.ngrams)) {
            return false;
        }
        return this.numOccurrences.equals(that.numOccurrences);
    }

    public int hashCode() {
        int result = this.language.hashCode();
        result = 31 * result + this.ngrams.hashCode();
        result = 31 * result + this.numOccurrences.hashCode();
        return result;
    }
}

