/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.share;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.android.Contents;
import com.google.zxing.client.android.R;
import com.google.zxing.client.android.clipboard.ClipboardInterface;
import com.google.zxing.client.android.share.AppPickerActivity;
import com.google.zxing.client.android.share.BookmarkPickerActivity;

public final class ShareActivity
extends Activity {
    private static final String TAG = ShareActivity.class.getSimpleName();
    private static final int PICK_BOOKMARK = 0;
    private static final int PICK_CONTACT = 1;
    private static final int PICK_APP = 2;
    private View clipboardButton;
    private final View.OnClickListener contactListener = new View.OnClickListener(){

        public void onClick(View v) {
            Intent intent = new Intent("android.intent.action.PICK", ContactsContract.Contacts.CONTENT_URI);
            intent.addFlags(524288);
            ShareActivity.this.startActivityForResult(intent, 1);
        }
    };
    private final View.OnClickListener bookmarkListener = new View.OnClickListener(){

        public void onClick(View v) {
            Intent intent = new Intent("android.intent.action.PICK");
            intent.addFlags(524288);
            intent.setClassName((Context)ShareActivity.this, BookmarkPickerActivity.class.getName());
            ShareActivity.this.startActivityForResult(intent, 0);
        }
    };
    private final View.OnClickListener appListener = new View.OnClickListener(){

        public void onClick(View v) {
            Intent intent = new Intent("android.intent.action.PICK");
            intent.addFlags(524288);
            intent.setClassName((Context)ShareActivity.this, AppPickerActivity.class.getName());
            ShareActivity.this.startActivityForResult(intent, 2);
        }
    };
    private final View.OnClickListener clipboardListener = new View.OnClickListener(){

        public void onClick(View v) {
            CharSequence text = ClipboardInterface.getText((Context)ShareActivity.this);
            if (text != null) {
                ShareActivity.this.launchSearch(text.toString());
            }
        }
    };
    private final View.OnKeyListener textListener = new View.OnKeyListener(){

        public boolean onKey(View view, int keyCode, KeyEvent event) {
            if (keyCode == 66 && event.getAction() == 0) {
                String text = ((TextView)view).getText().toString();
                if (text != null && !text.isEmpty()) {
                    ShareActivity.this.launchSearch(text);
                }
                return true;
            }
            return false;
        }
    };

    private void launchSearch(String text) {
        Intent intent = new Intent("com.google.zxing.client.android.ENCODE");
        intent.addFlags(524288);
        intent.putExtra("ENCODE_TYPE", "TEXT_TYPE");
        intent.putExtra("ENCODE_DATA", text);
        intent.putExtra("ENCODE_FORMAT", BarcodeFormat.QR_CODE.toString());
        this.startActivity(intent);
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(R.layout.share);
        this.findViewById(R.id.share_contact_button).setOnClickListener(this.contactListener);
        if (Build.VERSION.SDK_INT >= 23) {
            this.findViewById(R.id.share_bookmark_button).setEnabled(false);
        } else {
            this.findViewById(R.id.share_bookmark_button).setOnClickListener(this.bookmarkListener);
        }
        this.findViewById(R.id.share_app_button).setOnClickListener(this.appListener);
        this.clipboardButton = this.findViewById(R.id.share_clipboard_button);
        this.clipboardButton.setOnClickListener(this.clipboardListener);
        this.findViewById(R.id.share_text_view).setOnKeyListener(this.textListener);
    }

    protected void onResume() {
        super.onResume();
        this.clipboardButton.setEnabled(ClipboardInterface.hasText((Context)this));
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 0: 
                case 2: {
                    this.showTextAsBarcode(intent.getStringExtra("url"));
                    break;
                }
                case 1: {
                    this.showContactAsBarcode(intent.getData());
                }
            }
        }
    }

    private void showTextAsBarcode(String text) {
        Log.i((String)TAG, (String)("Showing text as barcode: " + text));
        if (text == null) {
            return;
        }
        Intent intent = new Intent("com.google.zxing.client.android.ENCODE");
        intent.addFlags(524288);
        intent.putExtra("ENCODE_TYPE", "TEXT_TYPE");
        intent.putExtra("ENCODE_DATA", text);
        intent.putExtra("ENCODE_FORMAT", BarcodeFormat.QR_CODE.toString());
        this.startActivity(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showContactAsBarcode(Uri contactUri) {
        Cursor emailCursor;
        Cursor methodsCursor;
        Cursor phonesCursor;
        boolean hasPhone;
        String name;
        String id2;
        Cursor cursor;
        Log.i((String)TAG, (String)("Showing contact URI as barcode: " + contactUri));
        if (contactUri == null) {
            return;
        }
        ContentResolver resolver = this.getContentResolver();
        try {
            cursor = resolver.query(contactUri, null, null, null, null);
        }
        catch (IllegalArgumentException ignored) {
            return;
        }
        if (cursor == null) {
            return;
        }
        try {
            if (!cursor.moveToFirst()) {
                return;
            }
            id2 = cursor.getString(cursor.getColumnIndex("_id"));
            name = cursor.getString(cursor.getColumnIndex("display_name"));
            hasPhone = cursor.getInt(cursor.getColumnIndex("has_phone_number")) > 0;
        }
        finally {
            cursor.close();
        }
        Bundle bundle = new Bundle();
        if (name != null && !name.isEmpty()) {
            bundle.putString("name", ShareActivity.massageContactData(name));
        }
        if (hasPhone && (phonesCursor = resolver.query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, "contact_id=" + id2, null, null)) != null) {
            try {
                int phonesNumberColumn = phonesCursor.getColumnIndex("data1");
                int phoneTypeColumn = phonesCursor.getColumnIndex("data2");
                for (int foundPhone = 0; phonesCursor.moveToNext() && foundPhone < Contents.PHONE_KEYS.length; ++foundPhone) {
                    String number = phonesCursor.getString(phonesNumberColumn);
                    if (number != null && !number.isEmpty()) {
                        bundle.putString(Contents.PHONE_KEYS[foundPhone], ShareActivity.massageContactData(number));
                    }
                    int type = phonesCursor.getInt(phoneTypeColumn);
                    bundle.putInt(Contents.PHONE_TYPE_KEYS[foundPhone], type);
                }
            }
            finally {
                phonesCursor.close();
            }
        }
        if ((methodsCursor = resolver.query(ContactsContract.CommonDataKinds.StructuredPostal.CONTENT_URI, null, "contact_id=" + id2, null, null)) != null) {
            try {
                String data;
                if (methodsCursor.moveToNext() && (data = methodsCursor.getString(methodsCursor.getColumnIndex("data1"))) != null && !data.isEmpty()) {
                    bundle.putString("postal", ShareActivity.massageContactData(data));
                }
            }
            finally {
                methodsCursor.close();
            }
        }
        if ((emailCursor = resolver.query(ContactsContract.CommonDataKinds.Email.CONTENT_URI, null, "contact_id=" + id2, null, null)) != null) {
            try {
                int emailColumn = emailCursor.getColumnIndex("data1");
                for (int foundEmail = 0; emailCursor.moveToNext() && foundEmail < Contents.EMAIL_KEYS.length; ++foundEmail) {
                    String email = emailCursor.getString(emailColumn);
                    if (email == null || email.isEmpty()) continue;
                    bundle.putString(Contents.EMAIL_KEYS[foundEmail], ShareActivity.massageContactData(email));
                }
            }
            finally {
                emailCursor.close();
            }
        }
        Intent intent = new Intent("com.google.zxing.client.android.ENCODE");
        intent.addFlags(524288);
        intent.putExtra("ENCODE_TYPE", "CONTACT_TYPE");
        intent.putExtra("ENCODE_DATA", bundle);
        intent.putExtra("ENCODE_FORMAT", BarcodeFormat.QR_CODE.toString());
        Log.i((String)TAG, (String)("Sending bundle for encoding: " + bundle));
        this.startActivity(intent);
    }

    private static String massageContactData(String data) {
        if (data.indexOf(10) >= 0) {
            data = data.replace("\n", " ");
        }
        if (data.indexOf(13) >= 0) {
            data = data.replace("\r", " ");
        }
        return data;
    }
}

