/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.ContactsContract;
import android.util.Log;
import com.google.zxing.FakeR;
import com.google.zxing.Result;
import com.google.zxing.client.android.Contents;
import com.google.zxing.client.android.LocaleManager;
import com.google.zxing.client.android.book.SearchBookContentsActivity;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;
import com.google.zxing.client.result.ResultParser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;

public abstract class ResultHandler {
    private static final String TAG = ResultHandler.class.getSimpleName();
    protected static FakeR fakeR;
    private static final String[] EMAIL_TYPE_STRINGS;
    private static final String[] PHONE_TYPE_STRINGS;
    private static final String[] ADDRESS_TYPE_STRINGS;
    private static final int[] EMAIL_TYPE_VALUES;
    private static final int[] PHONE_TYPE_VALUES;
    private static final int[] ADDRESS_TYPE_VALUES;
    private static final int NO_TYPE = -1;
    public static final int MAX_BUTTON_COUNT = 4;
    private final ParsedResult result;
    private final Activity activity;
    private final Result rawResult;
    private final String customProductSearch;

    ResultHandler(Activity activity, ParsedResult result) {
        this(activity, result, null);
    }

    ResultHandler(Activity activity, ParsedResult result, Result rawResult) {
        this.result = result;
        this.activity = activity;
        this.rawResult = rawResult;
        this.customProductSearch = this.parseCustomSearchURL();
        fakeR = new FakeR(activity);
    }

    public final ParsedResult getResult() {
        return this.result;
    }

    final boolean hasCustomProductSearch() {
        return this.customProductSearch != null;
    }

    final Activity getActivity() {
        return this.activity;
    }

    public abstract int getButtonCount();

    public abstract int getButtonText(int var1);

    public Integer getDefaultButtonID() {
        return null;
    }

    public abstract void handleButtonPress(int var1);

    public boolean areContentsSecure() {
        return false;
    }

    public CharSequence getDisplayContents() {
        String contents = this.result.getDisplayResult();
        return contents.replace("\r", "");
    }

    public abstract int getDisplayTitle();

    public final ParsedResultType getType() {
        return this.result.getType();
    }

    final void addPhoneOnlyContact(String[] phoneNumbers, String[] phoneTypes) {
        this.addContact(null, null, null, phoneNumbers, phoneTypes, null, null, null, null, null, null, null, null, null, null, null);
    }

    final void addEmailOnlyContact(String[] emails, String[] emailTypes) {
        this.addContact(null, null, null, null, null, emails, emailTypes, null, null, null, null, null, null, null, null, null);
    }

    final void addContact(String[] names, String[] nicknames, String pronunciation, String[] phoneNumbers, String[] phoneTypes, String[] emails, String[] emailTypes, String note, String instantMessenger, String address, String addressType, String org, String title, String[] urls, String birthday, String[] geo) {
        int type;
        ContentValues row;
        Intent intent = new Intent("android.intent.action.INSERT_OR_EDIT", ContactsContract.Contacts.CONTENT_URI);
        intent.setType("vnd.android.cursor.item/contact");
        ResultHandler.putExtra(intent, "name", names != null ? names[0] : null);
        ResultHandler.putExtra(intent, "phonetic_name", pronunciation);
        int phoneCount = Math.min(phoneNumbers != null ? phoneNumbers.length : 0, Contents.PHONE_KEYS.length);
        for (int x = 0; x < phoneCount; ++x) {
            int type2;
            ResultHandler.putExtra(intent, Contents.PHONE_KEYS[x], phoneNumbers[x]);
            if (phoneTypes == null || x >= phoneTypes.length || (type2 = ResultHandler.toPhoneContractType(phoneTypes[x])) < 0) continue;
            intent.putExtra(Contents.PHONE_TYPE_KEYS[x], type2);
        }
        int emailCount = Math.min(emails != null ? emails.length : 0, Contents.EMAIL_KEYS.length);
        for (int x = 0; x < emailCount; ++x) {
            int type3;
            ResultHandler.putExtra(intent, Contents.EMAIL_KEYS[x], emails[x]);
            if (emailTypes == null || x >= emailTypes.length || (type3 = ResultHandler.toEmailContractType(emailTypes[x])) < 0) continue;
            intent.putExtra(Contents.EMAIL_TYPE_KEYS[x], type3);
        }
        ArrayList<ContentValues> data = new ArrayList<ContentValues>();
        if (urls != null) {
            for (String url : urls) {
                if (url == null || url.isEmpty()) continue;
                row = new ContentValues(2);
                row.put("mimetype", "vnd.android.cursor.item/website");
                row.put("data1", url);
                data.add(row);
                break;
            }
        }
        if (birthday != null) {
            ContentValues row2 = new ContentValues(3);
            row2.put("mimetype", "vnd.android.cursor.item/contact_event");
            row2.put("data2", Integer.valueOf(3));
            row2.put("data1", birthday);
            data.add(row2);
        }
        if (nicknames != null) {
            for (String nickname : nicknames) {
                if (nickname == null || nickname.isEmpty()) continue;
                row = new ContentValues(3);
                row.put("mimetype", "vnd.android.cursor.item/nickname");
                row.put("data2", Integer.valueOf(1));
                row.put("data1", nickname);
                data.add(row);
                break;
            }
        }
        if (!data.isEmpty()) {
            intent.putParcelableArrayListExtra("data", data);
        }
        StringBuilder aggregatedNotes = new StringBuilder();
        if (note != null) {
            aggregatedNotes.append('\n').append(note);
        }
        if (geo != null) {
            aggregatedNotes.append('\n').append(geo[0]).append(',').append(geo[1]);
        }
        if (aggregatedNotes.length() > 0) {
            ResultHandler.putExtra(intent, "notes", aggregatedNotes.substring(1));
        }
        ResultHandler.putExtra(intent, "im_handle", instantMessenger);
        ResultHandler.putExtra(intent, "postal", address);
        if (addressType != null && (type = ResultHandler.toAddressContractType(addressType)) >= 0) {
            intent.putExtra("postal_type", type);
        }
        ResultHandler.putExtra(intent, "company", org);
        ResultHandler.putExtra(intent, "job_title", title);
        this.launchIntent(intent);
    }

    private static int toEmailContractType(String typeString) {
        return ResultHandler.doToContractType(typeString, EMAIL_TYPE_STRINGS, EMAIL_TYPE_VALUES);
    }

    private static int toPhoneContractType(String typeString) {
        return ResultHandler.doToContractType(typeString, PHONE_TYPE_STRINGS, PHONE_TYPE_VALUES);
    }

    private static int toAddressContractType(String typeString) {
        return ResultHandler.doToContractType(typeString, ADDRESS_TYPE_STRINGS, ADDRESS_TYPE_VALUES);
    }

    private static int doToContractType(String typeString, String[] types, int[] values) {
        if (typeString == null) {
            return -1;
        }
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (!typeString.startsWith(type) && !typeString.startsWith(type.toUpperCase(Locale.ENGLISH))) continue;
            return values[i];
        }
        return -1;
    }

    final void shareByEmail(String contents) {
        this.sendEmail(null, null, null, null, contents);
    }

    final void sendEmail(String[] to, String[] cc, String[] bcc, String subject, String body) {
        Intent intent = new Intent("android.intent.action.SEND", Uri.parse((String)"mailto:"));
        if (to != null && to.length != 0) {
            intent.putExtra("android.intent.extra.EMAIL", to);
        }
        if (cc != null && cc.length != 0) {
            intent.putExtra("android.intent.extra.CC", cc);
        }
        if (bcc != null && bcc.length != 0) {
            intent.putExtra("android.intent.extra.BCC", bcc);
        }
        ResultHandler.putExtra(intent, "android.intent.extra.SUBJECT", subject);
        ResultHandler.putExtra(intent, "android.intent.extra.TEXT", body);
        intent.setType("text/plain");
        this.launchIntent(intent);
    }

    final void shareBySMS(String contents) {
        this.sendSMSFromUri("smsto:", contents);
    }

    final void sendSMS(String phoneNumber, String body) {
        this.sendSMSFromUri("smsto:" + phoneNumber, body);
    }

    private void sendSMSFromUri(String uri, String body) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)uri));
        ResultHandler.putExtra(intent, "sms_body", body);
        intent.putExtra("compose_mode", true);
        this.launchIntent(intent);
    }

    final void sendMMS(String phoneNumber, String subject, String body) {
        this.sendMMSFromUri("mmsto:" + phoneNumber, subject, body);
    }

    private void sendMMSFromUri(String uri, String subject, String body) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)uri));
        if (subject == null || subject.isEmpty()) {
            ResultHandler.putExtra(intent, "subject", this.activity.getString(fakeR.getId("string", "msg_default_mms_subject")));
        } else {
            ResultHandler.putExtra(intent, "subject", subject);
        }
        ResultHandler.putExtra(intent, "sms_body", body);
        intent.putExtra("compose_mode", true);
        this.launchIntent(intent);
    }

    final void dialPhone(String phoneNumber) {
        this.launchIntent(new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber))));
    }

    final void dialPhoneFromUri(String uri) {
        this.launchIntent(new Intent("android.intent.action.DIAL", Uri.parse((String)uri)));
    }

    final void openMap(String geoURI) {
        this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)geoURI)));
    }

    final void searchMap(String address) {
        this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)("geo:0,0?q=" + Uri.encode((String)address)))));
    }

    final void getDirections(double latitude, double longitude) {
        this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)("http://maps.google." + LocaleManager.getCountryTLD((Context)this.activity) + "/maps?f=d&daddr=" + latitude + ',' + longitude))));
    }

    final void openProductSearch(String upc) {
        Uri uri = Uri.parse((String)("http://www.google." + LocaleManager.getProductSearchCountryTLD((Context)this.activity) + "/m/products?q=" + upc + "&source=zxing"));
        this.launchIntent(new Intent("android.intent.action.VIEW", uri));
    }

    final void openBookSearch(String isbn) {
        Uri uri = Uri.parse((String)("http://books.google." + LocaleManager.getBookSearchCountryTLD((Context)this.activity) + "/books?vid=isbn" + isbn));
        this.launchIntent(new Intent("android.intent.action.VIEW", uri));
    }

    final void searchBookContents(String isbnOrUrl) {
        Intent intent = new Intent("com.google.zxing.client.android.SEARCH_BOOK_CONTENTS");
        intent.setClassName((Context)this.activity, SearchBookContentsActivity.class.getName());
        ResultHandler.putExtra(intent, "ISBN", isbnOrUrl);
        this.launchIntent(intent);
    }

    final void openURL(String url) {
        if (url.startsWith("HTTP://")) {
            url = "http" + url.substring(4);
        } else if (url.startsWith("HTTPS://")) {
            url = "https" + url.substring(5);
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        try {
            this.launchIntent(intent);
        }
        catch (ActivityNotFoundException ignored) {
            Log.w((String)TAG, (String)("Nothing available to handle " + intent));
        }
    }

    final void webSearch(String query) {
        Intent intent = new Intent("android.intent.action.WEB_SEARCH");
        intent.putExtra("query", query);
        this.launchIntent(intent);
    }

    final void rawLaunchIntent(Intent intent) {
        if (intent != null) {
            intent.addFlags(524288);
            Log.d((String)TAG, (String)("Launching intent: " + intent + " with extras: " + intent.getExtras()));
            this.activity.startActivity(intent);
        }
    }

    final void launchIntent(Intent intent) {
        try {
            this.rawLaunchIntent(intent);
        }
        catch (ActivityNotFoundException ignored) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
            builder.setTitle(fakeR.getId("string", "app_name"));
            builder.setMessage(fakeR.getId("string", "msg_intent_failed"));
            builder.setPositiveButton(fakeR.getId("string", "button_ok"), null);
            builder.show();
        }
    }

    private static void putExtra(Intent intent, String key, String value) {
        if (value != null && !value.isEmpty()) {
            intent.putExtra(key, value);
        }
    }

    private String parseCustomSearchURL() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        String customProductSearch = prefs.getString("preferences_custom_product_search", null);
        if (customProductSearch != null && customProductSearch.trim().isEmpty()) {
            return null;
        }
        return customProductSearch;
    }

    final String fillInCustomSearchURL(String text) {
        if (this.customProductSearch == null) {
            return text;
        }
        try {
            text = URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String url = this.customProductSearch;
        if (this.rawResult != null && (url = url.replaceFirst("%f(?![0-9a-f])", this.rawResult.getBarcodeFormat().toString())).contains("%t")) {
            ParsedResult parsedResultAgain = ResultParser.parseResult(this.rawResult);
            url = url.replace("%t", parsedResultAgain.getType().toString());
        }
        return url.replace("%s", text);
    }

    static {
        EMAIL_TYPE_STRINGS = new String[]{"home", "work", "mobile"};
        PHONE_TYPE_STRINGS = new String[]{"home", "work", "mobile", "fax", "pager", "main"};
        ADDRESS_TYPE_STRINGS = new String[]{"home", "work"};
        EMAIL_TYPE_VALUES = new int[]{1, 2, 4};
        PHONE_TYPE_VALUES = new int[]{1, 3, 2, 4, 6, 12};
        ADDRESS_TYPE_VALUES = new int[]{1, 2};
    }
}

