/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.encode;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import android.view.Display;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.zxing.FakeR;
import com.google.zxing.WriterException;
import com.google.zxing.client.android.FinishListener;
import com.google.zxing.client.android.encode.QRCodeEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;

public final class EncodeActivity
extends Activity {
    private static FakeR fakeR;
    private static final String TAG;
    private static final int MAX_BARCODE_FILENAME_LENGTH = 24;
    private static final Pattern NOT_ALPHANUMERIC;
    private static final String USE_VCARD_KEY = "USE_VCARD";
    private QRCodeEncoder qrCodeEncoder;

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        fakeR = new FakeR(this);
        Intent intent = this.getIntent();
        if (intent == null) {
            this.finish();
        } else {
            String action = intent.getAction();
            if ("com.google.zxing.client.android.ENCODE".equals(action) || "android.intent.action.SEND".equals(action)) {
                this.setContentView(fakeR.getId("layout", "encode"));
            } else {
                this.finish();
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(fakeR.getId("menu", "encode"), menu2);
        boolean useVcard = this.qrCodeEncoder != null && this.qrCodeEncoder.isUseVCard();
        int encodeNameResource = useVcard ? fakeR.getId("string", "menu_encode_mecard") : fakeR.getId("string", "menu_encode_vcard");
        MenuItem encodeItem = menu2.findItem(fakeR.getId("id", "menu_encode"));
        encodeItem.setTitle(encodeNameResource);
        Intent intent = this.getIntent();
        if (intent != null) {
            String type = intent.getStringExtra("ENCODE_TYPE");
            encodeItem.setVisible("CONTACT_TYPE".equals(type));
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == fakeR.getId("id", "menu_share")) {
            this.share();
            return true;
        }
        if (itemId == fakeR.getId("id", "menu_encode")) {
            Intent intent = this.getIntent();
            if (intent == null) {
                return false;
            }
            intent.putExtra(USE_VCARD_KEY, !this.qrCodeEncoder.isUseVCard());
            this.startActivity(intent);
            this.finish();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void share() {
        Bitmap bitmap;
        QRCodeEncoder encoder = this.qrCodeEncoder;
        if (encoder == null) {
            Log.w((String)TAG, (String)"No existing barcode to send?");
            return;
        }
        String contents = encoder.getContents();
        if (contents == null) {
            Log.w((String)TAG, (String)"No existing barcode to send?");
            return;
        }
        try {
            bitmap = encoder.encodeAsBitmap();
        }
        catch (WriterException we) {
            Log.w((String)TAG, (Throwable)we);
            return;
        }
        if (bitmap == null) {
            return;
        }
        File bsRoot = new File(Environment.getExternalStorageDirectory(), "BarcodeScanner");
        File barcodesRoot = new File(bsRoot, "Barcodes");
        if (!barcodesRoot.exists() && !barcodesRoot.mkdirs()) {
            Log.w((String)TAG, (String)("Couldn't make dir " + barcodesRoot));
            this.showErrorMessage(fakeR.getId("string", "msg_unmount_usb"));
            return;
        }
        File barcodeFile = new File(barcodesRoot, EncodeActivity.makeBarcodeFileName(contents) + ".png");
        if (!barcodeFile.delete()) {
            Log.w((String)TAG, (String)("Could not delete " + barcodeFile));
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(barcodeFile);
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)fos);
        }
        catch (FileNotFoundException fnfe) {
            Log.w((String)TAG, (String)("Couldn't access file " + barcodeFile + " due to " + fnfe));
            this.showErrorMessage(fakeR.getId("string", "msg_unmount_usb"));
            return;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        Intent intent = new Intent("android.intent.action.SEND", Uri.parse((String)"mailto:"));
        intent.putExtra("android.intent.extra.SUBJECT", this.getString(fakeR.getId("string", "app_name")) + " - " + encoder.getTitle());
        intent.putExtra("android.intent.extra.TEXT", contents);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)("file://" + barcodeFile.getAbsolutePath())));
        intent.setType("image/png");
        intent.addFlags(524288);
        this.startActivity(Intent.createChooser((Intent)intent, null));
    }

    private static CharSequence makeBarcodeFileName(CharSequence contents) {
        String fileName = NOT_ALPHANUMERIC.matcher(contents).replaceAll("_");
        if (fileName.length() > 24) {
            fileName = fileName.substring(0, 24);
        }
        return fileName;
    }

    protected void onResume() {
        super.onResume();
        WindowManager manager = (WindowManager)this.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        Point displaySize = new Point();
        display.getSize(displaySize);
        int width = displaySize.x;
        int height = displaySize.y;
        int smallerDimension = width < height ? width : height;
        smallerDimension = smallerDimension * 7 / 8;
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        try {
            boolean useVCard = intent.getBooleanExtra(USE_VCARD_KEY, false);
            this.qrCodeEncoder = new QRCodeEncoder((Context)this, intent, smallerDimension, useVCard);
            Bitmap bitmap = this.qrCodeEncoder.encodeAsBitmap();
            if (bitmap == null) {
                Log.w((String)TAG, (String)"Could not encode barcode");
                this.showErrorMessage(fakeR.getId("string", "msg_encode_contents_failed"));
                this.qrCodeEncoder = null;
                return;
            }
            ImageView view = (ImageView)this.findViewById(fakeR.getId("id", "image_view"));
            view.setImageBitmap(bitmap);
            TextView contents = (TextView)this.findViewById(fakeR.getId("id", "contents_text_view"));
            if (intent.getBooleanExtra("ENCODE_SHOW_CONTENTS", true)) {
                contents.setText((CharSequence)this.qrCodeEncoder.getDisplayContents());
                this.setTitle(this.qrCodeEncoder.getTitle());
            } else {
                contents.setText((CharSequence)"");
                this.setTitle("");
            }
        }
        catch (WriterException e) {
            Log.w((String)TAG, (String)"Could not encode barcode", (Throwable)e);
            this.showErrorMessage(fakeR.getId("string", "msg_encode_contents_failed"));
            this.qrCodeEncoder = null;
        }
    }

    private void showErrorMessage(int message) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setMessage(message);
        builder.setPositiveButton(fakeR.getId("string", "button_ok"), (DialogInterface.OnClickListener)new FinishListener(this));
        builder.setOnCancelListener((DialogInterface.OnCancelListener)new FinishListener(this));
        builder.show();
    }

    static {
        TAG = EncodeActivity.class.getSimpleName();
        NOT_ALPHANUMERIC = Pattern.compile("[^A-Za-z0-9]");
    }
}

