/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FakeR;
import com.google.zxing.Result;
import com.google.zxing.client.android.CaptureActivity;
import com.google.zxing.client.android.DecodeThread;
import com.google.zxing.client.android.ViewfinderResultPointCallback;
import com.google.zxing.client.android.camera.CameraManager;
import java.util.Collection;
import java.util.Map;

public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = CaptureActivityHandler.class.getSimpleName();
    private final CaptureActivity activity;
    private final DecodeThread decodeThread;
    private State state;
    private final CameraManager cameraManager;
    private static FakeR fakeR;

    CaptureActivityHandler(CaptureActivity activity, Collection<BarcodeFormat> decodeFormats, Map<DecodeHintType, ?> baseHints, String characterSet, CameraManager cameraManager) {
        fakeR = new FakeR(activity);
        this.activity = activity;
        this.decodeThread = new DecodeThread(activity, decodeFormats, baseHints, characterSet, new ViewfinderResultPointCallback(activity.getViewfinderView()));
        this.decodeThread.start();
        this.state = State.SUCCESS;
        this.cameraManager = cameraManager;
        cameraManager.startPreview();
        this.restartPreviewAndDecode();
    }

    public CaptureActivityHandler(CaptureActivity activity, Collection<BarcodeFormat> decodeFormats, String characterSet, CameraManager cameraManager2) {
        fakeR = new FakeR(activity);
        this.activity = activity;
        this.decodeThread = new DecodeThread(activity, decodeFormats, null, characterSet, new ViewfinderResultPointCallback(activity.getViewfinderView()));
        this.decodeThread.start();
        this.state = State.SUCCESS;
        this.cameraManager = cameraManager2;
        this.cameraManager.startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        if (message.what == fakeR.getId("id", "restart_preview")) {
            Log.d((String)TAG, (String)"Got restart preview message");
            this.restartPreviewAndDecode();
        } else if (message.what == fakeR.getId("id", "decode_succeeded")) {
            Log.d((String)TAG, (String)"Got decode succeeded message");
            this.state = State.SUCCESS;
            Bundle bundle = message.getData();
            Bitmap barcode = null;
            float scaleFactor = 1.0f;
            if (bundle != null) {
                byte[] compressedBitmap = bundle.getByteArray("barcode_bitmap");
                if (compressedBitmap != null) {
                    barcode = BitmapFactory.decodeByteArray((byte[])compressedBitmap, (int)0, (int)compressedBitmap.length, null);
                    barcode = barcode.copy(Bitmap.Config.ARGB_8888, true);
                }
                scaleFactor = bundle.getFloat("barcode_scaled_factor");
            }
            this.activity.handleDecode((Result)message.obj, barcode, scaleFactor);
        } else if (message.what == fakeR.getId("id", "decode_failed")) {
            this.state = State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), fakeR.getId("id", "decode"));
        } else if (message.what == fakeR.getId("id", "return_scan_result")) {
            Log.d((String)TAG, (String)"Got return scan result message");
            this.activity.setResult(-1, (Intent)message.obj);
            this.activity.finish();
        } else if (message.what == fakeR.getId("id", "launch_product_query")) {
            Log.d((String)TAG, (String)"Got product query message");
            String url = (String)message.obj;
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(524288);
            intent.setData(Uri.parse((String)url));
            ResolveInfo resolveInfo = this.activity.getPackageManager().resolveActivity(intent, 65536);
            String browserPackageName = null;
            if (resolveInfo != null && resolveInfo.activityInfo != null) {
                browserPackageName = resolveInfo.activityInfo.packageName;
                Log.d((String)TAG, (String)("Using browser in package " + browserPackageName));
            }
            if ("com.android.browser".equals(browserPackageName) || "com.android.chrome".equals(browserPackageName)) {
                intent.setPackage(browserPackageName);
                intent.addFlags(0x10000000);
                intent.putExtra("com.android.browser.application_id", browserPackageName);
            }
            try {
                this.activity.startActivity(intent);
            }
            catch (ActivityNotFoundException ignored) {
                Log.w((String)TAG, (String)("Can't find anything to handle VIEW of URI " + url));
            }
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        this.cameraManager.stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)fakeR.getId("id", "quit"));
        quit.sendToTarget();
        try {
            this.decodeThread.join(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(fakeR.getId("id", "decode_succeeded"));
        this.removeMessages(fakeR.getId("id", "decode_failed"));
    }

    private void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), fakeR.getId("id", "decode"));
            this.activity.drawViewfinder();
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

