/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.mediacapture;

import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.file.FileUtils;
import org.apache.cordova.file.LocalFilesystemURL;
import org.apache.cordova.mediacapture.FileHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Capture
extends CordovaPlugin {
    private static final String VIDEO_3GPP = "video/3gpp";
    private static final String VIDEO_MP4 = "video/mp4";
    private static final String AUDIO_3GPP = "audio/3gpp";
    private static final String IMAGE_JPEG = "image/jpeg";
    private static final int CAPTURE_AUDIO = 0;
    private static final int CAPTURE_IMAGE = 1;
    private static final int CAPTURE_VIDEO = 2;
    private static final String LOG_TAG = "Capture";
    private static final int CAPTURE_INTERNAL_ERR = 0;
    private static final int CAPTURE_NO_MEDIA_FILES = 3;
    private CallbackContext callbackContext;
    private long limit;
    private int duration;
    private JSONArray results;
    private int numPics;

    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        this.callbackContext = callbackContext;
        this.limit = 1L;
        this.duration = 0;
        this.results = new JSONArray();
        JSONObject options = args.optJSONObject(0);
        if (options != null) {
            this.limit = options.optLong("limit", 1L);
            this.duration = options.optInt("duration", 0);
        }
        if (action.equals("getFormatData")) {
            JSONObject obj = this.getFormatData(args.getString(0), args.getString(1));
            callbackContext.success(obj);
            return true;
        }
        if (action.equals("captureAudio")) {
            this.captureAudio();
        } else if (action.equals("captureImage")) {
            this.captureImage();
        } else if (action.equals("captureVideo")) {
            this.captureVideo(this.duration);
        } else {
            return false;
        }
        return true;
    }

    private JSONObject getFormatData(String filePath, String mimeType) throws JSONException {
        Uri fileUrl = filePath.startsWith("file:") ? Uri.parse((String)filePath) : Uri.fromFile((File)new File(filePath));
        JSONObject obj = new JSONObject();
        obj.put("height", 0);
        obj.put("width", 0);
        obj.put("bitrate", 0);
        obj.put("duration", 0);
        obj.put("codecs", (Object)"");
        if (mimeType == null || mimeType.equals("") || "null".equals(mimeType)) {
            mimeType = FileHelper.getMimeType(fileUrl, this.cordova);
        }
        Log.d((String)LOG_TAG, (String)("Mime type = " + mimeType));
        if (mimeType.equals(IMAGE_JPEG) || filePath.endsWith(".jpg")) {
            obj = this.getImageData(fileUrl, obj);
        } else if (mimeType.endsWith(AUDIO_3GPP)) {
            obj = this.getAudioVideoData(filePath, obj, false);
        } else if (mimeType.equals(VIDEO_3GPP) || mimeType.equals(VIDEO_MP4)) {
            obj = this.getAudioVideoData(filePath, obj, true);
        }
        return obj;
    }

    private JSONObject getImageData(Uri fileUrl, JSONObject obj) throws JSONException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)fileUrl.getPath(), (BitmapFactory.Options)options);
        obj.put("height", options.outHeight);
        obj.put("width", options.outWidth);
        return obj;
    }

    private JSONObject getAudioVideoData(String filePath, JSONObject obj, boolean video) throws JSONException {
        MediaPlayer player = new MediaPlayer();
        try {
            player.setDataSource(filePath);
            player.prepare();
            obj.put("duration", player.getDuration() / 1000);
            if (video) {
                obj.put("height", player.getVideoHeight());
                obj.put("width", player.getVideoWidth());
            }
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"Error: loading video file");
        }
        return obj;
    }

    private void captureAudio() {
        Intent intent = new Intent("android.provider.MediaStore.RECORD_SOUND");
        this.cordova.startActivityForResult(this, intent, 0);
    }

    private String getTempDirectoryPath() {
        File cache = null;
        cache = this.cordova.getActivity().getCacheDir();
        cache.mkdirs();
        return cache.getAbsolutePath();
    }

    private void captureImage() {
        this.numPics = this.queryImgDB(this.whichContentStore()).getCount();
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File photo = new File(this.getTempDirectoryPath(), "Capture.jpg");
        try {
            Capture.createWritableFile(photo);
        }
        catch (IOException ex) {
            this.fail(this.createErrorObject(0, ex.toString()));
            return;
        }
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)photo));
        this.cordova.startActivityForResult(this, intent, 1);
    }

    private static void createWritableFile(File file) throws IOException {
        file.createNewFile();
        file.setWritable(true, false);
    }

    private void captureVideo(int duration) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (Build.VERSION.SDK_INT > 7) {
            intent.putExtra("android.intent.extra.durationLimit", duration);
        }
        this.cordova.startActivityForResult(this, intent, 2);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, final Intent intent) {
        if (resultCode == -1) {
            if (requestCode == 0) {
                final Capture that = this;
                Runnable captureAudio = new Runnable(){

                    @Override
                    public void run() {
                        Uri data = intent.getData();
                        Capture.this.results.put((Object)Capture.this.createMediaFile(data));
                        if ((long)Capture.this.results.length() >= Capture.this.limit) {
                            that.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, Capture.this.results));
                        } else {
                            Capture.this.captureAudio();
                        }
                    }
                };
                this.cordova.getThreadPool().execute(captureAudio);
            } else if (requestCode == 1) {
                final Capture that = this;
                Runnable captureImage = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int len;
                            ContentValues values = new ContentValues();
                            values.put("mime_type", Capture.IMAGE_JPEG);
                            Uri uri = null;
                            try {
                                uri = that.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                            }
                            catch (UnsupportedOperationException e) {
                                LOG.d(Capture.LOG_TAG, "Can't write to external media storage.");
                                try {
                                    uri = that.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
                                }
                                catch (UnsupportedOperationException ex) {
                                    LOG.d(Capture.LOG_TAG, "Can't write to internal media storage.");
                                    that.fail(Capture.this.createErrorObject(0, "Error capturing image - no media storage found."));
                                    return;
                                }
                            }
                            FileInputStream fis = new FileInputStream(Capture.this.getTempDirectoryPath() + "/Capture.jpg");
                            OutputStream os = that.cordova.getActivity().getContentResolver().openOutputStream(uri);
                            byte[] buffer = new byte[4096];
                            while ((len = fis.read(buffer)) != -1) {
                                os.write(buffer, 0, len);
                            }
                            os.flush();
                            os.close();
                            fis.close();
                            Capture.this.results.put((Object)Capture.this.createMediaFile(uri));
                            Capture.this.checkForDuplicateImage();
                            if ((long)Capture.this.results.length() >= Capture.this.limit) {
                                that.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, Capture.this.results));
                            } else {
                                Capture.this.captureImage();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            that.fail(Capture.this.createErrorObject(0, "Error capturing image."));
                        }
                    }
                };
                this.cordova.getThreadPool().execute(captureImage);
            } else if (requestCode == 2) {
                final Capture that = this;
                Runnable captureVideo = new Runnable(){

                    @Override
                    public void run() {
                        Uri data = null;
                        if (intent != null) {
                            data = intent.getData();
                        }
                        if (data == null) {
                            File movie = new File(Capture.this.getTempDirectoryPath(), "Capture.avi");
                            data = Uri.fromFile((File)movie);
                        }
                        if (data == null) {
                            that.fail(Capture.this.createErrorObject(3, "Error: data is null"));
                        } else {
                            Capture.this.results.put((Object)Capture.this.createMediaFile(data));
                            if ((long)Capture.this.results.length() >= Capture.this.limit) {
                                that.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, Capture.this.results));
                            } else {
                                Capture.this.captureVideo(Capture.this.duration);
                            }
                        }
                    }
                };
                this.cordova.getThreadPool().execute(captureVideo);
            }
        } else if (resultCode == 0) {
            if (this.results.length() > 0) {
                this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.results));
            } else {
                this.fail(this.createErrorObject(3, "Canceled."));
            }
        } else if (this.results.length() > 0) {
            this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.results));
        } else {
            this.fail(this.createErrorObject(3, "Did not complete!"));
        }
    }

    private JSONObject createMediaFile(Uri data) {
        File fp = this.webView.getResourceApi().mapUriToFile(data);
        JSONObject obj = new JSONObject();
        Class<?> webViewClass = this.webView.getClass();
        PluginManager pm = null;
        try {
            Method gpm = webViewClass.getMethod("getPluginManager", new Class[0]);
            pm = (PluginManager)gpm.invoke((Object)this.webView, new Object[0]);
        }
        catch (NoSuchMethodException gpm) {
        }
        catch (IllegalAccessException gpm) {
        }
        catch (InvocationTargetException gpm) {
            // empty catch block
        }
        if (pm == null) {
            try {
                Field pmf = webViewClass.getField("pluginManager");
                pm = (PluginManager)pmf.get(this.webView);
            }
            catch (NoSuchFieldException pmf) {
            }
            catch (IllegalAccessException pmf) {
                // empty catch block
            }
        }
        FileUtils filePlugin = (FileUtils)pm.getPlugin("File");
        LocalFilesystemURL url = filePlugin.filesystemURLforLocalPath(fp.getAbsolutePath());
        try {
            obj.put("name", (Object)fp.getName());
            obj.put("fullPath", (Object)fp.toURI().toString());
            if (url != null) {
                obj.put("localURL", (Object)url.toString());
            }
            if (fp.getAbsoluteFile().toString().endsWith(".3gp") || fp.getAbsoluteFile().toString().endsWith(".3gpp")) {
                if (data.toString().contains("/audio/")) {
                    obj.put("type", (Object)AUDIO_3GPP);
                } else {
                    obj.put("type", (Object)VIDEO_3GPP);
                }
            } else {
                obj.put("type", (Object)FileHelper.getMimeType(Uri.fromFile((File)fp), this.cordova));
            }
            obj.put("lastModifiedDate", fp.lastModified());
            obj.put("size", fp.length());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    private JSONObject createErrorObject(int code, String message) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("code", code);
            obj.put("message", (Object)message);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return obj;
    }

    public void fail(JSONObject err) {
        this.callbackContext.error(err);
    }

    private Cursor queryImgDB(Uri contentStore) {
        return this.cordova.getActivity().getContentResolver().query(contentStore, new String[]{"_id"}, null, null, null);
    }

    private void checkForDuplicateImage() {
        Uri contentStore = this.whichContentStore();
        Cursor cursor = this.queryImgDB(contentStore);
        int currentNumOfImages = cursor.getCount();
        if (currentNumOfImages - this.numPics == 2) {
            cursor.moveToLast();
            int id2 = Integer.valueOf(cursor.getString(cursor.getColumnIndex("_id"))) - 1;
            Uri uri = Uri.parse((String)(contentStore + "/" + id2));
            this.cordova.getActivity().getContentResolver().delete(uri, null, null);
        }
    }

    private Uri whichContentStore() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        }
        return MediaStore.Images.Media.INTERNAL_CONTENT_URI;
    }
}

