/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.media;

import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.cordova.media.AudioHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class AudioPlayer
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnErrorListener {
    private static final String LOG_TAG = "AudioPlayer";
    private static int MEDIA_STATE = 1;
    private static int MEDIA_DURATION = 2;
    private static int MEDIA_POSITION = 3;
    private static int MEDIA_ERROR = 9;
    private static int MEDIA_ERR_NONE_ACTIVE = 0;
    private static int MEDIA_ERR_ABORTED = 1;
    private AudioHandler handler;
    private String id;
    private MODE mode = MODE.NONE;
    private STATE state = STATE.MEDIA_NONE;
    private String audioFile = null;
    private float duration = -1.0f;
    private MediaRecorder recorder = null;
    private String tempFile = null;
    private MediaPlayer player = null;
    private boolean prepareOnly = true;
    private int seekOnPrepared = 0;

    public AudioPlayer(AudioHandler handler, String id2, String file) {
        this.handler = handler;
        this.id = id2;
        this.audioFile = file;
        this.recorder = new MediaRecorder();
        this.tempFile = Environment.getExternalStorageState().equals("mounted") ? Environment.getExternalStorageDirectory().getAbsolutePath() + "/tmprecording.3gp" : "/data/data/" + handler.cordova.getActivity().getPackageName() + "/cache/tmprecording.3gp";
    }

    public void destroy() {
        if (this.player != null) {
            if (this.state == STATE.MEDIA_RUNNING || this.state == STATE.MEDIA_PAUSED) {
                this.player.stop();
                this.setState(STATE.MEDIA_STOPPED);
            }
            this.player.release();
            this.player = null;
        }
        if (this.recorder != null) {
            this.stopRecording();
            this.recorder.release();
            this.recorder = null;
        }
    }

    public void startRecording(String file) {
        switch (this.mode) {
            case PLAY: {
                Log.d((String)LOG_TAG, (String)"AudioPlayer Error: Can't record in play mode.");
                this.sendErrorStatus(MEDIA_ERR_ABORTED);
                break;
            }
            case NONE: {
                this.audioFile = file;
                this.recorder.setAudioSource(1);
                this.recorder.setOutputFormat(0);
                this.recorder.setAudioEncoder(0);
                this.recorder.setOutputFile(this.tempFile);
                try {
                    this.recorder.prepare();
                    this.recorder.start();
                    this.setState(STATE.MEDIA_RUNNING);
                    return;
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.sendErrorStatus(MEDIA_ERR_ABORTED);
                break;
            }
            case RECORD: {
                Log.d((String)LOG_TAG, (String)"AudioPlayer Error: Already recording.");
                this.sendErrorStatus(MEDIA_ERR_ABORTED);
            }
        }
    }

    public void moveFile(String file) {
        File f = new File(this.tempFile);
        if (!file.startsWith("/")) {
            file = Environment.getExternalStorageState().equals("mounted") ? Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + file : "/data/data/" + this.handler.cordova.getActivity().getPackageName() + "/cache/" + file;
        }
        String logMsg = "renaming " + this.tempFile + " to " + file;
        Log.d((String)LOG_TAG, (String)logMsg);
        if (!f.renameTo(new File(file))) {
            Log.e((String)LOG_TAG, (String)("FAILED " + logMsg));
        }
    }

    public void stopRecording() {
        if (this.recorder != null) {
            try {
                if (this.state == STATE.MEDIA_RUNNING) {
                    this.recorder.stop();
                    this.setState(STATE.MEDIA_STOPPED);
                }
                this.recorder.reset();
                this.moveFile(this.audioFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void startPlaying(String file) {
        if (this.readyPlayer(file) && this.player != null) {
            this.player.start();
            this.setState(STATE.MEDIA_RUNNING);
            this.seekOnPrepared = 0;
        } else {
            this.prepareOnly = false;
        }
    }

    public void seekToPlaying(int milliseconds) {
        if (this.readyPlayer(this.audioFile)) {
            this.player.seekTo(milliseconds);
            Log.d((String)LOG_TAG, (String)"Send a onStatus update for the new seek");
            this.sendStatusChange(MEDIA_POSITION, null, Float.valueOf((float)milliseconds / 1000.0f));
        } else {
            this.seekOnPrepared = milliseconds;
        }
    }

    public void pausePlaying() {
        if (this.state == STATE.MEDIA_RUNNING && this.player != null) {
            this.player.pause();
            this.setState(STATE.MEDIA_PAUSED);
        } else {
            Log.d((String)LOG_TAG, (String)("AudioPlayer Error: pausePlaying() called during invalid state: " + this.state.ordinal()));
            this.sendErrorStatus(MEDIA_ERR_NONE_ACTIVE);
        }
    }

    public void stopPlaying() {
        if (this.state == STATE.MEDIA_RUNNING || this.state == STATE.MEDIA_PAUSED) {
            this.player.pause();
            this.player.seekTo(0);
            Log.d((String)LOG_TAG, (String)"stopPlaying is calling stopped");
            this.setState(STATE.MEDIA_STOPPED);
        } else {
            Log.d((String)LOG_TAG, (String)("AudioPlayer Error: stopPlaying() called during invalid state: " + this.state.ordinal()));
            this.sendErrorStatus(MEDIA_ERR_NONE_ACTIVE);
        }
    }

    public void onCompletion(MediaPlayer player) {
        Log.d((String)LOG_TAG, (String)"on completion is calling stopped");
        this.setState(STATE.MEDIA_STOPPED);
    }

    public long getCurrentPosition() {
        if (this.state == STATE.MEDIA_RUNNING || this.state == STATE.MEDIA_PAUSED) {
            int curPos = this.player.getCurrentPosition();
            this.sendStatusChange(MEDIA_POSITION, null, Float.valueOf((float)curPos / 1000.0f));
            return curPos;
        }
        return -1L;
    }

    public boolean isStreaming(String file) {
        return file.contains("http://") || file.contains("https://");
    }

    public float getDuration(String file) {
        if (this.recorder != null) {
            return -2.0f;
        }
        if (this.player != null) {
            return this.duration;
        }
        this.prepareOnly = true;
        this.startPlaying(file);
        return this.duration;
    }

    public void onPrepared(MediaPlayer player) {
        this.player.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.seekToPlaying(this.seekOnPrepared);
        if (!this.prepareOnly) {
            this.player.start();
            this.setState(STATE.MEDIA_RUNNING);
            this.seekOnPrepared = 0;
        } else {
            this.setState(STATE.MEDIA_STARTING);
        }
        this.duration = this.getDurationInSeconds();
        this.prepareOnly = true;
        this.sendStatusChange(MEDIA_DURATION, null, Float.valueOf(this.duration));
    }

    private float getDurationInSeconds() {
        return (float)this.player.getDuration() / 1000.0f;
    }

    public boolean onError(MediaPlayer player, int arg1, int arg2) {
        Log.d((String)LOG_TAG, (String)("AudioPlayer.onError(" + arg1 + ", " + arg2 + ")"));
        this.player.stop();
        this.player.release();
        this.sendErrorStatus(arg1);
        return false;
    }

    private void setState(STATE state) {
        if (this.state != state) {
            this.sendStatusChange(MEDIA_STATE, null, Float.valueOf(state.ordinal()));
        }
        this.state = state;
    }

    private void setMode(MODE mode) {
        if (this.mode != mode) {
            // empty if block
        }
        this.mode = mode;
    }

    public int getState() {
        return this.state.ordinal();
    }

    public void setVolume(float volume) {
        this.player.setVolume(volume, volume);
    }

    private boolean playMode() {
        switch (this.mode) {
            case NONE: {
                this.setMode(MODE.PLAY);
                break;
            }
            case PLAY: {
                break;
            }
            case RECORD: {
                Log.d((String)LOG_TAG, (String)"AudioPlayer Error: Can't play in record mode.");
                this.sendErrorStatus(MEDIA_ERR_ABORTED);
                return false;
            }
        }
        return true;
    }

    private boolean readyPlayer(String file) {
        if (this.playMode()) {
            switch (this.state) {
                case MEDIA_NONE: {
                    if (this.player == null) {
                        this.player = new MediaPlayer();
                    }
                    try {
                        this.loadAudioFile(file);
                    }
                    catch (Exception e) {
                        this.sendErrorStatus(MEDIA_ERR_ABORTED);
                    }
                    return false;
                }
                case MEDIA_LOADING: {
                    Log.d((String)LOG_TAG, (String)("AudioPlayer Loading: startPlaying() called during media preparation: " + STATE.MEDIA_STARTING.ordinal()));
                    this.prepareOnly = false;
                    return false;
                }
                case MEDIA_STARTING: 
                case MEDIA_RUNNING: 
                case MEDIA_PAUSED: {
                    return true;
                }
                case MEDIA_STOPPED: {
                    if (this.audioFile.compareTo(file) == 0) {
                        this.player.seekTo(0);
                        this.player.pause();
                        return true;
                    }
                    this.player.reset();
                    try {
                        this.loadAudioFile(file);
                    }
                    catch (Exception e) {
                        this.sendErrorStatus(MEDIA_ERR_ABORTED);
                    }
                    return false;
                }
            }
            Log.d((String)LOG_TAG, (String)("AudioPlayer Error: startPlaying() called during invalid state: " + (Object)((Object)this.state)));
            this.sendErrorStatus(MEDIA_ERR_ABORTED);
        }
        return false;
    }

    private void loadAudioFile(String file) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (this.isStreaming(file)) {
            this.player.setDataSource(file);
            this.player.setAudioStreamType(3);
            this.setMode(MODE.PLAY);
            this.setState(STATE.MEDIA_STARTING);
            this.player.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.player.prepareAsync();
        } else {
            if (file.startsWith("/android_asset/")) {
                String f = file.substring(15);
                AssetFileDescriptor fd = this.handler.cordova.getActivity().getAssets().openFd(f);
                this.player.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getLength());
            } else {
                File fp = new File(file);
                if (fp.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.player.setDataSource(fileInputStream.getFD());
                    fileInputStream.close();
                } else {
                    this.player.setDataSource(Environment.getExternalStorageDirectory().getPath() + "/" + file);
                }
            }
            this.setState(STATE.MEDIA_STARTING);
            this.player.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.player.prepare();
            this.duration = this.getDurationInSeconds();
        }
    }

    private void sendErrorStatus(int errorCode) {
        this.sendStatusChange(MEDIA_ERROR, errorCode, null);
    }

    private void sendStatusChange(int messageType, Integer additionalCode, Float value) {
        if (additionalCode != null && value != null) {
            throw new IllegalArgumentException("Only one of additionalCode or value can be specified, not both");
        }
        JSONObject statusDetails = new JSONObject();
        try {
            statusDetails.put("id", (Object)this.id);
            statusDetails.put("msgType", messageType);
            if (additionalCode != null) {
                JSONObject code = new JSONObject();
                code.put("code", additionalCode.intValue());
                statusDetails.put("value", (Object)code);
            } else if (value != null) {
                statusDetails.put("value", (double)value.floatValue());
            }
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)"Failed to create status details", (Throwable)e);
        }
        this.handler.sendEventMessage("status", statusDetails);
    }

    public static enum STATE {
        MEDIA_NONE,
        MEDIA_STARTING,
        MEDIA_RUNNING,
        MEDIA_PAUSED,
        MEDIA_STOPPED,
        MEDIA_LOADING;

    }

    public static enum MODE {
        NONE,
        PLAY,
        RECORD;

    }
}

