/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.inappbrowser;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.Config;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.inappbrowser.InAppBrowserDialog;
import org.apache.cordova.inappbrowser.InAppChromeClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class InAppBrowser
extends CordovaPlugin {
    private static final String NULL = "null";
    protected static final String LOG_TAG = "InAppBrowser";
    private static final String SELF = "_self";
    private static final String SYSTEM = "_system";
    private static final String EXIT_EVENT = "exit";
    private static final String LOCATION = "location";
    private static final String ZOOM = "zoom";
    private static final String HIDDEN = "hidden";
    private static final String LOAD_START_EVENT = "loadstart";
    private static final String LOAD_STOP_EVENT = "loadstop";
    private static final String LOAD_ERROR_EVENT = "loaderror";
    private static final String CLEAR_ALL_CACHE = "clearcache";
    private static final String CLEAR_SESSION_CACHE = "clearsessioncache";
    private static final String HARDWARE_BACK_BUTTON = "hardwareback";
    private InAppBrowserDialog dialog;
    private WebView inAppWebView;
    private EditText edittext;
    private CallbackContext callbackContext;
    private boolean showLocationBar = true;
    private boolean showZoomControls = true;
    private boolean openWindowHidden = false;
    private boolean clearAllCache = false;
    private boolean clearSessionCache = false;
    private boolean hadwareBackButton = true;

    @Override
    public boolean execute(String action, CordovaArgs args, final CallbackContext callbackContext) throws JSONException {
        if (action.equals("open")) {
            this.callbackContext = callbackContext;
            final String url = args.getString(0);
            String t = args.optString(1);
            if (t == null || t.equals("") || t.equals(NULL)) {
                t = SELF;
            }
            final String target = t;
            final HashMap<String, Boolean> features = this.parseFeature(args.optString(2));
            Log.d((String)LOG_TAG, (String)("target = " + target));
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String result = "";
                    if (InAppBrowser.SELF.equals(target)) {
                        Log.d((String)InAppBrowser.LOG_TAG, (String)"in self");
                        Boolean shouldAllowNavigation = null;
                        if (url.startsWith("javascript:")) {
                            shouldAllowNavigation = true;
                        }
                        if (shouldAllowNavigation == null) {
                            try {
                                Method iuw = Config.class.getMethod("isUrlWhiteListed", String.class);
                                shouldAllowNavigation = (Boolean)iuw.invoke(null, url);
                            }
                            catch (NoSuchMethodException iuw) {
                            }
                            catch (IllegalAccessException iuw) {
                            }
                            catch (InvocationTargetException iuw) {
                                // empty catch block
                            }
                        }
                        if (shouldAllowNavigation == null) {
                            try {
                                Method gpm = InAppBrowser.this.webView.getClass().getMethod("getPluginManager", new Class[0]);
                                PluginManager pm = (PluginManager)gpm.invoke((Object)InAppBrowser.this.webView, new Object[0]);
                                Method san = pm.getClass().getMethod("shouldAllowNavigation", String.class);
                                shouldAllowNavigation = (Boolean)san.invoke((Object)pm, url);
                            }
                            catch (NoSuchMethodException gpm) {
                            }
                            catch (IllegalAccessException gpm) {
                            }
                            catch (InvocationTargetException gpm) {
                                // empty catch block
                            }
                        }
                        if (Boolean.TRUE.equals(shouldAllowNavigation)) {
                            Log.d((String)InAppBrowser.LOG_TAG, (String)"loading in webview");
                            InAppBrowser.this.webView.loadUrl(url);
                        } else if (url.startsWith("tel:")) {
                            try {
                                Log.d((String)InAppBrowser.LOG_TAG, (String)"loading in dialer");
                                Intent intent = new Intent("android.intent.action.DIAL");
                                intent.setData(Uri.parse((String)url));
                                InAppBrowser.this.cordova.getActivity().startActivity(intent);
                            }
                            catch (ActivityNotFoundException e) {
                                LOG.e(InAppBrowser.LOG_TAG, "Error dialing " + url + ": " + e.toString());
                            }
                        } else {
                            Log.d((String)InAppBrowser.LOG_TAG, (String)"loading in InAppBrowser");
                            result = InAppBrowser.this.showWebPage(url, features);
                        }
                    } else if (InAppBrowser.SYSTEM.equals(target)) {
                        Log.d((String)InAppBrowser.LOG_TAG, (String)"in system");
                        result = InAppBrowser.this.openExternal(url);
                    } else {
                        Log.d((String)InAppBrowser.LOG_TAG, (String)"in blank");
                        result = InAppBrowser.this.showWebPage(url, features);
                    }
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, result);
                    pluginResult.setKeepCallback(true);
                    callbackContext.sendPluginResult(pluginResult);
                }
            });
        } else if (action.equals("close")) {
            this.closeDialog();
        } else if (action.equals("injectScriptCode")) {
            String jsWrapper = null;
            if (args.getBoolean(1)) {
                jsWrapper = String.format("prompt(JSON.stringify([eval(%%s)]), 'gap-iab://%s')", callbackContext.getCallbackId());
            }
            this.injectDeferredObject(args.getString(0), jsWrapper);
        } else if (action.equals("injectScriptFile")) {
            String jsWrapper = args.getBoolean(1) ? String.format("(function(d) { var c = d.createElement('script'); c.src = %%s; c.onload = function() { prompt('', 'gap-iab://%s'); }; d.body.appendChild(c); })(document)", callbackContext.getCallbackId()) : "(function(d) { var c = d.createElement('script'); c.src = %s; d.body.appendChild(c); })(document)";
            this.injectDeferredObject(args.getString(0), jsWrapper);
        } else if (action.equals("injectStyleCode")) {
            String jsWrapper = args.getBoolean(1) ? String.format("(function(d) { var c = d.createElement('style'); c.innerHTML = %%s; d.body.appendChild(c); prompt('', 'gap-iab://%s');})(document)", callbackContext.getCallbackId()) : "(function(d) { var c = d.createElement('style'); c.innerHTML = %s; d.body.appendChild(c); })(document)";
            this.injectDeferredObject(args.getString(0), jsWrapper);
        } else if (action.equals("injectStyleFile")) {
            String jsWrapper = args.getBoolean(1) ? String.format("(function(d) { var c = d.createElement('link'); c.rel='stylesheet'; c.type='text/css'; c.href = %%s; d.head.appendChild(c); prompt('', 'gap-iab://%s');})(document)", callbackContext.getCallbackId()) : "(function(d) { var c = d.createElement('link'); c.rel='stylesheet'; c.type='text/css'; c.href = %s; d.head.appendChild(c); })(document)";
            this.injectDeferredObject(args.getString(0), jsWrapper);
        } else if (action.equals("show")) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    InAppBrowser.this.dialog.show();
                }
            });
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK);
            pluginResult.setKeepCallback(true);
            this.callbackContext.sendPluginResult(pluginResult);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void onReset() {
        this.closeDialog();
    }

    @Override
    public void onDestroy() {
        this.closeDialog();
    }

    private void injectDeferredObject(String source, String jsWrapper) {
        String scriptToInject;
        if (jsWrapper != null) {
            JSONArray jsonEsc = new JSONArray();
            jsonEsc.put((Object)source);
            String jsonRepr = jsonEsc.toString();
            String jsonSourceString = jsonRepr.substring(1, jsonRepr.length() - 1);
            scriptToInject = String.format(jsWrapper, jsonSourceString);
        } else {
            scriptToInject = source;
        }
        final String finalScriptToInject = scriptToInject;
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            @SuppressLint(value={"NewApi"})
            public void run() {
                if (Build.VERSION.SDK_INT < 19) {
                    InAppBrowser.this.inAppWebView.loadUrl("javascript:" + finalScriptToInject);
                } else {
                    InAppBrowser.this.inAppWebView.evaluateJavascript(finalScriptToInject, null);
                }
            }
        });
    }

    private HashMap<String, Boolean> parseFeature(String optString) {
        if (optString.equals(NULL)) {
            return null;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        StringTokenizer features = new StringTokenizer(optString, ",");
        while (features.hasMoreElements()) {
            StringTokenizer option = new StringTokenizer(features.nextToken(), "=");
            if (!option.hasMoreElements()) continue;
            String key = option.nextToken();
            Boolean value = option.nextToken().equals("no") ? Boolean.FALSE : Boolean.TRUE;
            map.put(key, value);
        }
        return map;
    }

    public String openExternal(String url) {
        try {
            Intent intent = null;
            intent = new Intent("android.intent.action.VIEW");
            Uri uri = Uri.parse((String)url);
            if ("file".equals(uri.getScheme())) {
                intent.setDataAndType(uri, this.webView.getResourceApi().getMimeType(uri));
            } else {
                intent.setData(uri);
            }
            intent.putExtra("com.android.browser.application_id", this.cordova.getActivity().getPackageName());
            this.cordova.getActivity().startActivity(intent);
            return "";
        }
        catch (ActivityNotFoundException e) {
            Log.d((String)LOG_TAG, (String)("InAppBrowser: Error loading url " + url + ":" + e.toString()));
            return e.toString();
        }
    }

    public void closeDialog() {
        final WebView childView = this.inAppWebView;
        if (childView == null) {
            return;
        }
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                childView.setWebViewClient(new WebViewClient(){

                    public void onPageFinished(WebView view, String url) {
                        if (InAppBrowser.this.dialog != null) {
                            InAppBrowser.this.dialog.dismiss();
                        }
                    }
                });
                childView.loadUrl("about:blank");
            }
        });
        try {
            JSONObject obj = new JSONObject();
            obj.put("type", (Object)EXIT_EVENT);
            this.sendUpdate(obj, false);
        }
        catch (JSONException ex) {
            Log.d((String)LOG_TAG, (String)"Should never happen");
        }
    }

    public void goBack() {
        if (this.inAppWebView.canGoBack()) {
            this.inAppWebView.goBack();
        }
    }

    public boolean canGoBack() {
        return this.inAppWebView.canGoBack();
    }

    public boolean hardwareBack() {
        return this.hadwareBackButton;
    }

    private void goForward() {
        if (this.inAppWebView.canGoForward()) {
            this.inAppWebView.goForward();
        }
    }

    private void navigate(String url) {
        InputMethodManager imm = (InputMethodManager)this.cordova.getActivity().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.edittext.getWindowToken(), 0);
        if (!url.startsWith("http") && !url.startsWith("file:")) {
            this.inAppWebView.loadUrl("http://" + url);
        } else {
            this.inAppWebView.loadUrl(url);
        }
        this.inAppWebView.requestFocus();
    }

    private boolean getShowLocationBar() {
        return this.showLocationBar;
    }

    private boolean getShowZoomControls() {
        return this.showZoomControls;
    }

    private InAppBrowser getInAppBrowser() {
        return this;
    }

    public String showWebPage(final String url, HashMap<String, Boolean> features) {
        this.showLocationBar = true;
        this.showZoomControls = true;
        this.openWindowHidden = false;
        if (features != null) {
            Boolean cache;
            Boolean hardwareBack;
            Boolean hidden;
            Boolean zoom;
            Boolean show = features.get(LOCATION);
            if (show != null) {
                this.showLocationBar = show;
            }
            if ((zoom = features.get(ZOOM)) != null) {
                this.showZoomControls = zoom;
            }
            if ((hidden = features.get(HIDDEN)) != null) {
                this.openWindowHidden = hidden;
            }
            if ((hardwareBack = features.get(HARDWARE_BACK_BUTTON)) != null) {
                this.hadwareBackButton = hardwareBack;
            }
            if ((cache = features.get(CLEAR_ALL_CACHE)) != null) {
                this.clearAllCache = cache;
            } else {
                cache = features.get(CLEAR_SESSION_CACHE);
                if (cache != null) {
                    this.clearSessionCache = cache;
                }
            }
        }
        final CordovaWebView thatWebView = this.webView;
        Runnable runnable = new Runnable(){

            private int dpToPixels(int dipValue) {
                int value = (int)TypedValue.applyDimension((int)1, (float)dipValue, (DisplayMetrics)InAppBrowser.this.cordova.getActivity().getResources().getDisplayMetrics());
                return value;
            }

            @Override
            @SuppressLint(value={"NewApi"})
            public void run() {
                boolean enableDatabase;
                InAppBrowser.this.dialog = new InAppBrowserDialog((Context)InAppBrowser.this.cordova.getActivity(), 16973830);
                ((InAppBrowser)InAppBrowser.this).dialog.getWindow().getAttributes().windowAnimations = 16973826;
                InAppBrowser.this.dialog.requestWindowFeature(1);
                InAppBrowser.this.dialog.setCancelable(true);
                InAppBrowser.this.dialog.setInAppBroswer(InAppBrowser.this.getInAppBrowser());
                LinearLayout main = new LinearLayout((Context)InAppBrowser.this.cordova.getActivity());
                main.setOrientation(1);
                RelativeLayout toolbar = new RelativeLayout((Context)InAppBrowser.this.cordova.getActivity());
                toolbar.setBackgroundColor(-3355444);
                toolbar.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.dpToPixels(44)));
                toolbar.setPadding(this.dpToPixels(2), this.dpToPixels(2), this.dpToPixels(2), this.dpToPixels(2));
                toolbar.setHorizontalGravity(3);
                toolbar.setVerticalGravity(48);
                RelativeLayout actionButtonContainer = new RelativeLayout((Context)InAppBrowser.this.cordova.getActivity());
                actionButtonContainer.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
                actionButtonContainer.setHorizontalGravity(3);
                actionButtonContainer.setVerticalGravity(16);
                actionButtonContainer.setId(Integer.parseInt("1"));
                Button back = new Button((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams backLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
                backLayoutParams.addRule(5);
                back.setLayoutParams((ViewGroup.LayoutParams)backLayoutParams);
                back.setContentDescription((CharSequence)"Back Button");
                back.setId(Integer.parseInt("2"));
                Resources activityRes = InAppBrowser.this.cordova.getActivity().getResources();
                int backResId = activityRes.getIdentifier("ic_action_previous_item", "drawable", InAppBrowser.this.cordova.getActivity().getPackageName());
                Drawable backIcon = activityRes.getDrawable(backResId);
                if (Build.VERSION.SDK_INT < 16) {
                    back.setBackgroundDrawable(backIcon);
                } else {
                    back.setBackground(backIcon);
                }
                back.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InAppBrowser.this.goBack();
                    }
                });
                Button forward = new Button((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams forwardLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
                forwardLayoutParams.addRule(1, 2);
                forward.setLayoutParams((ViewGroup.LayoutParams)forwardLayoutParams);
                forward.setContentDescription((CharSequence)"Forward Button");
                forward.setId(Integer.parseInt("3"));
                int fwdResId = activityRes.getIdentifier("ic_action_next_item", "drawable", InAppBrowser.this.cordova.getActivity().getPackageName());
                Drawable fwdIcon = activityRes.getDrawable(fwdResId);
                if (Build.VERSION.SDK_INT < 16) {
                    forward.setBackgroundDrawable(fwdIcon);
                } else {
                    forward.setBackground(fwdIcon);
                }
                forward.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InAppBrowser.this.goForward();
                    }
                });
                InAppBrowser.this.edittext = new EditText((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams textLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
                textLayoutParams.addRule(1, 1);
                textLayoutParams.addRule(0, 5);
                InAppBrowser.this.edittext.setLayoutParams((ViewGroup.LayoutParams)textLayoutParams);
                InAppBrowser.this.edittext.setId(Integer.parseInt("4"));
                InAppBrowser.this.edittext.setSingleLine(true);
                InAppBrowser.this.edittext.setText((CharSequence)url);
                InAppBrowser.this.edittext.setInputType(16);
                InAppBrowser.this.edittext.setImeOptions(2);
                InAppBrowser.this.edittext.setInputType(0);
                InAppBrowser.this.edittext.setOnKeyListener(new View.OnKeyListener(){

                    public boolean onKey(View v, int keyCode, KeyEvent event) {
                        if (event.getAction() == 0 && keyCode == 66) {
                            InAppBrowser.this.navigate(InAppBrowser.this.edittext.getText().toString());
                            return true;
                        }
                        return false;
                    }
                });
                Button close = new Button((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams closeLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
                closeLayoutParams.addRule(11);
                close.setLayoutParams((ViewGroup.LayoutParams)closeLayoutParams);
                forward.setContentDescription((CharSequence)"Close Button");
                close.setId(Integer.parseInt("5"));
                int closeResId = activityRes.getIdentifier("ic_action_remove", "drawable", InAppBrowser.this.cordova.getActivity().getPackageName());
                Drawable closeIcon = activityRes.getDrawable(closeResId);
                if (Build.VERSION.SDK_INT < 16) {
                    close.setBackgroundDrawable(closeIcon);
                } else {
                    close.setBackground(closeIcon);
                }
                close.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InAppBrowser.this.closeDialog();
                    }
                });
                InAppBrowser.this.inAppWebView = new WebView((Context)InAppBrowser.this.cordova.getActivity());
                InAppBrowser.this.inAppWebView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                InAppBrowser.this.inAppWebView.setWebChromeClient((WebChromeClient)new InAppChromeClient(thatWebView));
                InAppBrowserClient client = new InAppBrowserClient(thatWebView, InAppBrowser.this.edittext);
                InAppBrowser.this.inAppWebView.setWebViewClient((WebViewClient)client);
                WebSettings settings = InAppBrowser.this.inAppWebView.getSettings();
                settings.setJavaScriptEnabled(true);
                settings.setJavaScriptCanOpenWindowsAutomatically(true);
                settings.setBuiltInZoomControls(InAppBrowser.this.getShowZoomControls());
                settings.setPluginState(WebSettings.PluginState.ON);
                Bundle appSettings = InAppBrowser.this.cordova.getActivity().getIntent().getExtras();
                boolean bl = enableDatabase = appSettings == null ? true : appSettings.getBoolean("InAppBrowserStorageEnabled", true);
                if (enableDatabase) {
                    String databasePath = InAppBrowser.this.cordova.getActivity().getApplicationContext().getDir("inAppBrowserDB", 0).getPath();
                    settings.setDatabasePath(databasePath);
                    settings.setDatabaseEnabled(true);
                }
                settings.setDomStorageEnabled(true);
                if (InAppBrowser.this.clearAllCache) {
                    CookieManager.getInstance().removeAllCookie();
                } else if (InAppBrowser.this.clearSessionCache) {
                    CookieManager.getInstance().removeSessionCookie();
                }
                InAppBrowser.this.inAppWebView.loadUrl(url);
                InAppBrowser.this.inAppWebView.setId(Integer.parseInt("6"));
                InAppBrowser.this.inAppWebView.getSettings().setLoadWithOverviewMode(true);
                InAppBrowser.this.inAppWebView.getSettings().setUseWideViewPort(true);
                InAppBrowser.this.inAppWebView.requestFocus();
                InAppBrowser.this.inAppWebView.requestFocusFromTouch();
                actionButtonContainer.addView((View)back);
                actionButtonContainer.addView((View)forward);
                toolbar.addView((View)actionButtonContainer);
                toolbar.addView((View)InAppBrowser.this.edittext);
                toolbar.addView((View)close);
                if (InAppBrowser.this.getShowLocationBar()) {
                    main.addView((View)toolbar);
                }
                main.addView((View)InAppBrowser.this.inAppWebView);
                WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
                lp.copyFrom(InAppBrowser.this.dialog.getWindow().getAttributes());
                lp.width = -1;
                lp.height = -1;
                InAppBrowser.this.dialog.setContentView((View)main);
                InAppBrowser.this.dialog.show();
                InAppBrowser.this.dialog.getWindow().setAttributes(lp);
                if (InAppBrowser.this.openWindowHidden) {
                    InAppBrowser.this.dialog.hide();
                }
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
        return "";
    }

    private void sendUpdate(JSONObject obj, boolean keepCallback) {
        this.sendUpdate(obj, keepCallback, PluginResult.Status.OK);
    }

    private void sendUpdate(JSONObject obj, boolean keepCallback, PluginResult.Status status) {
        if (this.callbackContext != null) {
            PluginResult result = new PluginResult(status, obj);
            result.setKeepCallback(keepCallback);
            this.callbackContext.sendPluginResult(result);
            if (!keepCallback) {
                this.callbackContext = null;
            }
        }
    }

    public class InAppBrowserClient
    extends WebViewClient {
        EditText edittext;
        CordovaWebView webView;

        public InAppBrowserClient(CordovaWebView webView, EditText mEditText) {
            this.webView = webView;
            this.edittext = mEditText;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Intent intent;
            super.onPageStarted(view, url, favicon);
            String newloc = "";
            if (url.startsWith("http:") || url.startsWith("https:") || url.startsWith("file:")) {
                newloc = url;
            } else if (url.startsWith("tel:")) {
                try {
                    intent = new Intent("android.intent.action.DIAL");
                    intent.setData(Uri.parse((String)url));
                    InAppBrowser.this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(InAppBrowser.LOG_TAG, "Error dialing " + url + ": " + e.toString());
                }
            } else if (url.startsWith("geo:") || url.startsWith("mailto:") || url.startsWith("market:")) {
                try {
                    intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    InAppBrowser.this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(InAppBrowser.LOG_TAG, "Error with " + url + ": " + e.toString());
                }
            } else if (url.startsWith("sms:")) {
                try {
                    intent = new Intent("android.intent.action.VIEW");
                    String address = null;
                    int parmIndex = url.indexOf(63);
                    if (parmIndex == -1) {
                        address = url.substring(4);
                    } else {
                        address = url.substring(4, parmIndex);
                        Uri uri = Uri.parse((String)url);
                        String query = uri.getQuery();
                        if (query != null && query.startsWith("body=")) {
                            intent.putExtra("sms_body", query.substring(5));
                        }
                    }
                    intent.setData(Uri.parse((String)("sms:" + address)));
                    intent.putExtra("address", address);
                    intent.setType("vnd.android-dir/mms-sms");
                    InAppBrowser.this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(InAppBrowser.LOG_TAG, "Error sending sms " + url + ":" + e.toString());
                }
            } else {
                newloc = "http://" + url;
            }
            if (!newloc.equals(this.edittext.getText().toString())) {
                this.edittext.setText((CharSequence)newloc);
            }
            try {
                JSONObject obj = new JSONObject();
                obj.put("type", (Object)InAppBrowser.LOAD_START_EVENT);
                obj.put("url", (Object)newloc);
                InAppBrowser.this.sendUpdate(obj, true);
            }
            catch (JSONException ex) {
                Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
            }
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            try {
                JSONObject obj = new JSONObject();
                obj.put("type", (Object)InAppBrowser.LOAD_STOP_EVENT);
                obj.put("url", (Object)url);
                InAppBrowser.this.sendUpdate(obj, true);
            }
            catch (JSONException ex) {
                Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            try {
                JSONObject obj = new JSONObject();
                obj.put("type", (Object)InAppBrowser.LOAD_ERROR_EVENT);
                obj.put("url", (Object)failingUrl);
                obj.put("code", errorCode);
                obj.put("message", (Object)description);
                InAppBrowser.this.sendUpdate(obj, true, PluginResult.Status.ERROR);
            }
            catch (JSONException ex) {
                Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
            }
        }
    }
}

