/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CoreAndroid;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.ResumeCallback;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
public class CordovaInterfaceImpl
implements CordovaInterface {
    private static final String TAG = "CordovaInterfaceImpl";
    protected Activity activity;
    protected ExecutorService threadPool;
    protected PluginManager pluginManager;
    protected ActivityResultHolder savedResult;
    protected CordovaPlugin activityResultCallback;
    protected CordovaPlugin permissionResultCallback;
    protected String initCallbackService;
    protected int activityResultRequestCode;
    protected boolean activityWasDestroyed = false;
    protected Bundle savedPluginState;

    public CordovaInterfaceImpl(Activity activity) {
        this(activity, Executors.newCachedThreadPool());
    }

    public CordovaInterfaceImpl(Activity activity, ExecutorService threadPool) {
        this.activity = activity;
        this.threadPool = threadPool;
    }

    @Override
    public void startActivityForResult(CordovaPlugin command, Intent intent, int requestCode) {
        this.setActivityResultCallback(command);
        try {
            this.activity.startActivityForResult(intent, requestCode);
        }
        catch (RuntimeException e) {
            this.activityResultCallback = null;
            throw e;
        }
    }

    @Override
    public void setActivityResultCallback(CordovaPlugin plugin) {
        if (this.activityResultCallback != null) {
            this.activityResultCallback.onActivityResult(this.activityResultRequestCode, 0, null);
        }
        this.activityResultCallback = plugin;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public Object onMessage(String id, Object data) {
        if ("exit".equals(id)) {
            this.activity.finish();
        }
        return null;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void onCordovaInit(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        if (this.savedResult != null) {
            this.onActivityResult(this.savedResult.requestCode, this.savedResult.resultCode, this.savedResult.intent);
        } else if (this.activityWasDestroyed) {
            CoreAndroid appPlugin;
            this.activityWasDestroyed = false;
            if (pluginManager != null && (appPlugin = (CoreAndroid)pluginManager.getPlugin("CoreAndroid")) != null) {
                JSONObject obj = new JSONObject();
                try {
                    obj.put("action", (Object)"resume");
                }
                catch (JSONException e) {
                    LOG.e(TAG, "Failed to create event message", e);
                }
                appPlugin.sendResumeEvent(new PluginResult(PluginResult.Status.OK, obj));
            }
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent intent) {
        CordovaPlugin callback = this.activityResultCallback;
        if (callback == null && this.initCallbackService != null) {
            this.savedResult = new ActivityResultHolder(requestCode, resultCode, intent);
            if (this.pluginManager != null && (callback = this.pluginManager.getPlugin(this.initCallbackService)) != null) {
                callback.onRestoreStateForActivityResult(this.savedPluginState.getBundle(callback.getServiceName()), new ResumeCallback(callback.getServiceName(), this.pluginManager));
            }
        }
        this.activityResultCallback = null;
        if (callback != null) {
            Log.d((String)TAG, (String)"Sending activity result to plugin");
            this.initCallbackService = null;
            this.savedResult = null;
            callback.onActivityResult(requestCode, resultCode, intent);
            return true;
        }
        Log.w((String)TAG, (String)("Got an activity result, but no plugin was registered to receive it" + (this.savedResult != null ? " yet!" : "")));
        return false;
    }

    public void setActivityResultRequestCode(int requestCode) {
        this.activityResultRequestCode = requestCode;
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.activityResultCallback != null) {
            String serviceName = this.activityResultCallback.getServiceName();
            outState.putString("callbackService", serviceName);
        }
        if (this.pluginManager != null) {
            outState.putBundle("plugin", this.pluginManager.onSaveInstanceState());
        }
    }

    public void restoreInstanceState(Bundle savedInstanceState) {
        this.initCallbackService = savedInstanceState.getString("callbackService");
        this.savedPluginState = savedInstanceState.getBundle("plugin");
        this.activityWasDestroyed = true;
    }

    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        if (this.permissionResultCallback != null) {
            this.permissionResultCallback.onRequestPermissionResult(requestCode, permissions, grantResults);
            this.permissionResultCallback = null;
        }
    }

    @Override
    public void requestPermission(CordovaPlugin plugin, int requestCode, String permission) {
        this.permissionResultCallback = plugin;
        String[] permissions = new String[]{permission};
        if (Build.VERSION.SDK_INT >= 23) {
            this.getActivity().requestPermissions(permissions, requestCode);
        }
    }

    @Override
    public void requestPermissions(CordovaPlugin plugin, int requestCode, String[] permissions) {
        this.permissionResultCallback = plugin;
        if (Build.VERSION.SDK_INT >= 23) {
            this.getActivity().requestPermissions(permissions, requestCode);
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        if (Build.VERSION.SDK_INT >= 23) {
            int result = this.activity.checkSelfPermission(permission);
            return 0 == result;
        }
        return true;
    }

    private static class ActivityResultHolder {
        private int requestCode;
        private int resultCode;
        private Intent intent;

        public ActivityResultHolder(int requestCode, int resultCode, Intent intent) {
            this.requestCode = requestCode;
            this.resultCode = resultCode;
            this.intent = intent;
        }
    }
}

