/*
 * Decompiled with CFR 0.152.
 */
package OnePoint.CordovaPlugin.Utils;

import OnePoint.Common.Utils;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import com.opg.survey.o;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Locale;
import org.json.JSONObject;

public class FileUtils {
    static final String L = "FileUtils";
    private static final String G = "MediaID";
    public static Comparator<File> sComparator = new Comparator<File>(){

        public int B(File arg0, File arg1) {
            return arg0.getName().toLowerCase(Locale.US).compareTo(arg1.getName().toLowerCase(Locale.US));
        }
    };
    public static FileFilter sDirFilter;
    public static final String HIDDEN_PREFIX = ".";
    public static FileFilter sFileFilter;

    public static String getJSONPathObj(String arg0) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("path", (Object)arg0);
            jSONObject = jSONObject2;
        }
        catch (Exception exception) {
            jSONObject = jSONObject2;
        }
        return jSONObject.toString();
    }

    public static String getExtension(String arg0) {
        if (arg0 == null) {
            return null;
        }
        int n2 = arg0.lastIndexOf(HIDDEN_PREFIX);
        if (n2 >= 0) {
            return arg0.substring(n2);
        }
        return "";
    }

    private /* synthetic */ FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Bitmap getThumbnail(Context arg0, Uri arg1, String arg2) {
        if (!FileUtils.isMediaUri(arg1)) {
            return null;
        }
        Bitmap bitmap = null;
        if (arg1 != null) {
            Cursor cursor;
            Cursor cursor2;
            block12: {
                ContentResolver contentResolver = arg0.getContentResolver();
                cursor2 = null;
                try {
                    cursor2 = contentResolver.query(arg1, null, null, null, null);
                    if (cursor2.moveToFirst()) {
                        int n2 = cursor2.getInt(0);
                        if (arg2.contains("video/")) {
                            bitmap = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)n2, (int)1, null);
                            cursor = cursor2;
                            break block12;
                        }
                        if (arg2.contains("image/*")) {
                            bitmap = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)n2, (int)1, null);
                        }
                    }
                    cursor = cursor2;
                }
                catch (Exception exception) {
                    if (cursor2 != null) {
                        cursor2.close();
                        return bitmap;
                    }
                    catch (Throwable throwable) {
                        if (cursor2 != null) {
                            cursor2.close();
                        }
                        throw throwable;
                    }
                }
            }
            if (cursor != null) {
                cursor2.close();
                return bitmap;
            }
        }
        return bitmap;
    }

    public static String getMimeType(File arg0) {
        String string = FileUtils.getExtension(arg0.getName());
        if (string.length() > 0) {
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(string.substring(1));
        }
        return "application/octet-stream";
    }

    public static boolean isExternalStorageDocument(Uri arg0) {
        return "com.android.externalstorage.documents".equals(arg0.getAuthority());
    }

    public static Uri getUri(File arg0) {
        if (arg0 != null) {
            return Uri.fromFile((File)arg0);
        }
        return null;
    }

    public static Bitmap getThumbnail(Context arg0, Uri arg1) {
        Context context = arg0;
        return FileUtils.getThumbnail(context, arg1, FileUtils.getMimeType(context, arg1));
    }

    public static boolean isMediaDocument(Uri arg0) {
        return "com.android.providers.media.documents".equals(arg0.getAuthority());
    }

    public static String getMimeType(Context arg0, Uri arg1) {
        return FileUtils.getMimeType(new File(FileUtils.getPath(arg0, arg1)));
    }

    public static String getReadableFileSize(int arg0) {
        int n2 = 1024;
        DecimalFormat decimalFormat = new DecimalFormat("###.#");
        String string = " KB";
        String string2 = " MB";
        String string3 = " GB";
        float f2 = 0.0f;
        String string4 = " KB";
        if (arg0 > 1024) {
            float f3;
            f2 = arg0 / 1024;
            if (f3 > 1024.0f) {
                float f4;
                f2 /= 1024.0f;
                if (f4 > 1024.0f) {
                    f2 /= 1024.0f;
                    string4 = " GB";
                } else {
                    string4 = " MB";
                }
            }
        }
        return String.valueOf(new StringBuilder().insert(0, decimalFormat.format(f2)).append(string4).toString());
    }

    public static File getPathWithoutFilename(File arg0) {
        if (arg0 != null) {
            String string;
            if (arg0.isDirectory()) {
                return arg0;
            }
            File file = arg0;
            String string2 = file.getName();
            String string3 = string = file.getAbsolutePath();
            String string4 = string3.substring(0, string3.length() - string2.length());
            if (string4.endsWith("\"")) {
                String string5 = string4;
                string4 = string5.substring(0, string5.length() - 1);
            }
            return new File(string4);
        }
        return null;
    }

    public static String getJSONMediaPathObj(String arg0, String arg1) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put(G, (Object)arg0);
            jSONObject2.put("path", (Object)arg1);
            jSONObject = jSONObject2;
        }
        catch (Exception exception) {
            jSONObject = jSONObject2;
        }
        return jSONObject.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context arg0, Uri arg1, String arg2, String[] arg3) {
        Cursor cursor = null;
        String string = "_data";
        String[] stringArray = new String[]{"_data"};
        try {
            cursor = arg0.getContentResolver().query(arg1, stringArray, arg2, arg3, null);
            if (cursor != null && cursor.moveToFirst()) {
                Cursor cursor2 = cursor;
                int n2 = cursor2.getColumnIndexOrThrow("_data");
                String string2 = cursor2.getString(n2);
                if (string2 == null) {
                    String string3;
                    File file;
                    InputStream inputStream = arg0.getContentResolver().openInputStream(arg1);
                    File file2 = new File(Environment.getExternalStorageDirectory() + File.separator + Utils.getApplicationName(arg0) + File.separator + "media" + "/");
                    File file3 = new File(file2 + "/Opg_Image/");
                    if (!file3.exists()) {
                        file3.mkdir();
                    }
                    String string4 = String.format(Locale.ENGLISH, "%%0%dd", 3);
                    while ((file = new File(file3, string3 = new StringBuilder().insert(0, "image_capture_").append(String.format(Locale.ENGLISH, string4, System.currentTimeMillis() / 1000L)).append(".jpeg").toString())).exists()) {
                    }
                    File file4 = file;
                    FileUtils.B(inputStream, file4);
                    string3 = file4.getAbsolutePath();
                    return string3;
                }
                String string5 = string2;
                return string5;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static Bitmap getThumbnail(Context arg0, File arg1) {
        return FileUtils.getThumbnail(arg0, FileUtils.getUri(arg1), FileUtils.getMimeType(arg1));
    }

    @TargetApi(value=19)
    public static String getPath(Context arg0, Uri arg1) {
        boolean bl;
        boolean bl2 = bl = Build.VERSION.SDK_INT >= 19;
        if (bl && DocumentsContract.isDocumentUri((Context)arg0, (Uri)arg1)) {
            if (FileUtils.isExternalStorageDocument(arg1)) {
                String string = DocumentsContract.getDocumentId((Uri)arg1);
                String[] stringArray = string.split(":");
                String string2 = stringArray[0];
                if ("primary".equalsIgnoreCase(string2)) {
                    return Environment.getExternalStorageDirectory() + "\"" + stringArray[1];
                }
            } else {
                if (FileUtils.B(arg1)) {
                    String string = DocumentsContract.getDocumentId((Uri)arg1);
                    Uri uri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(string));
                    return FileUtils.getDataColumn(arg0, uri, null, null);
                }
                if (FileUtils.isMediaDocument(arg1)) {
                    String string = DocumentsContract.getDocumentId((Uri)arg1);
                    String[] stringArray = string.split(":");
                    String string3 = stringArray[0];
                    Uri uri = null;
                    if ("image".equals(string3)) {
                        uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(string3)) {
                        uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(string3)) {
                        uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String string4 = "_id=?";
                    String[] stringArray2 = new String[]{stringArray[1]};
                    return FileUtils.getDataColumn(arg0, uri, "_id=?", stringArray2);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(arg1.getScheme())) {
                return FileUtils.getDataColumn(arg0, arg1, null, null);
            }
            if ("file".equalsIgnoreCase(arg1.getScheme())) {
                return arg1.getPath();
            }
        }
        return null;
    }

    public static long getFileSize(String arg0) {
        File file = new File(arg0);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public static boolean B(Uri arg0) {
        return "com.android.providers.downloads.documents".equals(arg0.getAuthority());
    }

    public static byte[] convertFileToByteArray(File arg0) throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(arg0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        try {
            int n2;
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public static boolean isGooglePhotosUri(Uri arg0) {
        return "com.google.android.apps.photos.content".equals(arg0.getAuthority());
    }

    public static File getFile(Context arg0, Uri arg1) {
        String string;
        if (arg1 != null && (string = FileUtils.getPath(arg0, arg1)) != null && FileUtils.isLocal(string)) {
            return new File(string);
        }
        return null;
    }

    public static boolean isLocal(String arg0) {
        return arg0 != null && !arg0.startsWith("http://") && !arg0.startsWith("https://");
    }

    public static Intent createGetContentIntent() {
        Intent intent;
        Intent intent2 = intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent2.addCategory(o.B("^\t[\u0015P\u000e[IV\tK\u0002Q\u0013\u0011\u0004^\u0013Z\u0000P\u0015FIp7z)~%s\""));
        return intent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ boolean B(InputStream arg0, File arg1) {
        if (arg0 == null || arg1 == null) {
            return false;
        }
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(arg1);){
                int n2;
                byte[] byArray = new byte[4096];
                while ((n2 = arg0.read(byArray)) >= 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isMediaUri(Uri arg0) {
        return "media".equalsIgnoreCase(arg0.getAuthority());
    }

    static {
        sFileFilter = new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                File file = arg0;
                String string = file.getName();
                return file.isFile() && !string.startsWith(FileUtils.HIDDEN_PREFIX);
            }
        };
        sDirFilter = new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                File file = arg0;
                String string = file.getName();
                return file.isDirectory() && !string.startsWith(FileUtils.HIDDEN_PREFIX);
            }
        };
    }
}

