/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.networkinformation;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkManager
extends CordovaPlugin {
    public static int NOT_REACHABLE = 0;
    public static int REACHABLE_VIA_CARRIER_DATA_NETWORK = 1;
    public static int REACHABLE_VIA_WIFI_NETWORK = 2;
    public static final String WIFI = "wifi";
    public static final String WIMAX = "wimax";
    public static final String MOBILE = "mobile";
    public static final String CELLULAR = "cellular";
    public static final String GSM = "gsm";
    public static final String GPRS = "gprs";
    public static final String EDGE = "edge";
    public static final String CDMA = "cdma";
    public static final String UMTS = "umts";
    public static final String HSPA = "hspa";
    public static final String HSUPA = "hsupa";
    public static final String HSDPA = "hsdpa";
    public static final String ONEXRTT = "1xrtt";
    public static final String EHRPD = "ehrpd";
    public static final String LTE = "lte";
    public static final String UMB = "umb";
    public static final String HSPA_PLUS = "hspa+";
    public static final String TYPE_UNKNOWN = "unknown";
    public static final String TYPE_ETHERNET = "ethernet";
    public static final String TYPE_WIFI = "wifi";
    public static final String TYPE_2G = "2g";
    public static final String TYPE_3G = "3g";
    public static final String TYPE_4G = "4g";
    public static final String TYPE_NONE = "none";
    private static final String LOG_TAG = "NetworkManager";
    private CallbackContext connectionCallbackContext;
    ConnectivityManager sockMan;
    BroadcastReceiver receiver;
    private JSONObject lastInfo = null;

    @Override
    public void initialize(CordovaInterface cordova, CordovaWebView webView) {
        super.initialize(cordova, webView);
        this.sockMan = (ConnectivityManager)cordova.getActivity().getSystemService("connectivity");
        this.connectionCallbackContext = null;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        if (this.receiver == null) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (NetworkManager.this.webView != null) {
                        NetworkManager.this.updateConnectionInfo(NetworkManager.this.sockMan.getActiveNetworkInfo());
                    }
                }
            };
            webView.getContext().registerReceiver(this.receiver, intentFilter);
        }
    }

    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) {
        if (action.equals("getConnectionInfo")) {
            this.connectionCallbackContext = callbackContext;
            NetworkInfo info = this.sockMan.getActiveNetworkInfo();
            String connectionType = "";
            try {
                connectionType = this.getConnectionInfo(info).get("type").toString();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, connectionType);
            pluginResult.setKeepCallback(true);
            callbackContext.sendPluginResult(pluginResult);
            return true;
        }
        return false;
    }

    @Override
    public void onDestroy() {
        if (this.receiver != null) {
            try {
                this.webView.getContext().unregisterReceiver(this.receiver);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("Error unregistering network receiver: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.receiver = null;
            }
        }
    }

    private void updateConnectionInfo(NetworkInfo info) {
        JSONObject thisInfo = this.getConnectionInfo(info);
        if (!thisInfo.equals(this.lastInfo)) {
            String connectionType = "";
            try {
                connectionType = thisInfo.get("type").toString();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.sendUpdate(connectionType);
            this.lastInfo = thisInfo;
        }
    }

    private JSONObject getConnectionInfo(NetworkInfo info) {
        String type = TYPE_NONE;
        String extraInfo = "";
        if (info != null) {
            type = !info.isConnected() ? TYPE_NONE : this.getType(info);
            extraInfo = info.getExtraInfo();
        }
        Log.d((String)"CordovaNetworkManager", (String)("Connection Type: " + type));
        Log.d((String)"CordovaNetworkManager", (String)("Connection Extra Info: " + extraInfo));
        JSONObject connectionInfo = new JSONObject();
        try {
            connectionInfo.put("type", (Object)type);
            connectionInfo.put("extraInfo", (Object)extraInfo);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return connectionInfo;
    }

    private void sendUpdate(String type) {
        if (this.connectionCallbackContext != null) {
            PluginResult result = new PluginResult(PluginResult.Status.OK, type);
            result.setKeepCallback(true);
            this.connectionCallbackContext.sendPluginResult(result);
        }
        this.webView.postMessage("networkconnection", type);
    }

    private String getType(NetworkInfo info) {
        if (info != null) {
            String type = info.getTypeName();
            if (type.toLowerCase().equals("wifi")) {
                return "wifi";
            }
            if (type.toLowerCase().equals(MOBILE) || type.toLowerCase().equals(CELLULAR)) {
                type = info.getSubtypeName();
                if (type.toLowerCase().equals(GSM) || type.toLowerCase().equals(GPRS) || type.toLowerCase().equals(EDGE)) {
                    return TYPE_2G;
                }
                if (type.toLowerCase().startsWith(CDMA) || type.toLowerCase().equals(UMTS) || type.toLowerCase().equals(ONEXRTT) || type.toLowerCase().equals(EHRPD) || type.toLowerCase().equals(HSUPA) || type.toLowerCase().equals(HSDPA) || type.toLowerCase().equals(HSPA)) {
                    return TYPE_3G;
                }
                if (type.toLowerCase().equals(LTE) || type.toLowerCase().equals(UMB) || type.toLowerCase().equals(HSPA_PLUS)) {
                    return TYPE_4G;
                }
            }
        } else {
            return TYPE_NONE;
        }
        return TYPE_UNKNOWN;
    }
}

