/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.device;

import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import java.util.TimeZone;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Device
extends CordovaPlugin {
    public static final String TAG = "Device";
    public static String platform;
    public static String uuid;
    private static final String ANDROID_PLATFORM = "Android";
    private static final String AMAZON_PLATFORM = "amazon-fireos";
    private static final String AMAZON_DEVICE = "Amazon";

    @Override
    public void initialize(CordovaInterface cordova, CordovaWebView webView) {
        super.initialize(cordova, webView);
        uuid = this.getUuid();
    }

    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (!action.equals("getDeviceInfo")) {
            return false;
        }
        JSONObject r = new JSONObject();
        r.put("uuid", (Object)uuid);
        r.put("version", (Object)this.getOSVersion());
        r.put("platform", (Object)this.getPlatform());
        r.put("model", (Object)this.getModel());
        r.put("manufacturer", (Object)this.getManufacturer());
        callbackContext.success(r);
        return true;
    }

    public String getPlatform() {
        String platform = this.isAmazonDevice() ? AMAZON_PLATFORM : ANDROID_PLATFORM;
        return platform;
    }

    public String getUuid() {
        String uuid = Settings.Secure.getString((ContentResolver)this.cordova.getActivity().getContentResolver(), (String)"android_id");
        return uuid;
    }

    public String getModel() {
        String model = Build.MODEL;
        return model;
    }

    public String getProductName() {
        String productname = Build.PRODUCT;
        return productname;
    }

    public String getManufacturer() {
        String manufacturer = Build.MANUFACTURER;
        return manufacturer;
    }

    public String getOSVersion() {
        String osversion = Build.VERSION.RELEASE;
        return osversion;
    }

    public String getSDKVersion() {
        String sdkversion = Build.VERSION.SDK;
        return sdkversion;
    }

    public String getTimeZoneID() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getID();
    }

    public boolean isAmazonDevice() {
        return Build.MANUFACTURER.equals(AMAZON_DEVICE);
    }
}

