/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.plugins.barcodescanner;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import com.allatori.annotations.DoNotRename;
import com.opg.sdk.OPGR;
import com.opg.sdk.OPGSDKConstant;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.OPGBaseActivity;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BarcodeScanner
extends CordovaPlugin {
    public static final int REQUEST_CODE = 195543262;
    private static final String SCAN = "scan";
    private static final String ENCODE = "encode";
    private static final String CANCELLED = "cancelled";
    private static final String FORMAT = "format";
    private static final String TEXT = "text";
    private static final String DATA = "data";
    private static final String TYPE = "type";
    private static final String SCAN_INTENT = "com.google.zxing.client.android.SCAN";
    private static final String ENCODE_DATA = "ENCODE_DATA";
    private static final String ENCODE_TYPE = "ENCODE_TYPE";
    private static final String ENCODE_INTENT = "com.phonegap.plugins.barcodescanner.ENCODE";
    private static final String TEXT_TYPE = "TEXT_TYPE";
    private static final String EMAIL_TYPE = "EMAIL_TYPE";
    private static final String PHONE_TYPE = "PHONE_TYPE";
    private static final String SMS_TYPE = "SMS_TYPE";
    private static final String CATEGORY_DEFAULT = "android.intent.category.DEFAULT";
    private static final String LOG_TAG = "BarcodeScanner";
    private static final String SCAN_RESULT = "SCAN_RESULT";
    private static final String SCAN_RESULT_FORMAT = "SCAN_RESULT_FORMAT";
    private static final int REQUEST_CODE_ASK_CAMERA_PERMISSIONS = 129;
    private String[] permissions = new String[]{OPGSDKConstant.CAMERA_PERMISSION};
    private CallbackContext callbackContext;

    /*
     * Enabled aggressive block sorting
     */
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) {
        this.callbackContext = callbackContext;
        if (!action.equals(ENCODE)) {
            if (!action.equals(SCAN)) return false;
            if (!this.checkPermission()) return true;
            this.scan();
            return true;
        }
        JSONObject obj = args.optJSONObject(0);
        if (obj == null) {
            callbackContext.error("User did not specify data to encode");
            return true;
        }
        String type = obj.optString(TYPE);
        String data = obj.optString(DATA);
        if (type == null) {
            type = TEXT_TYPE;
        }
        if (data == null) {
            callbackContext.error("User did not specify data to encode");
            return true;
        }
        this.encode(type, data);
        return true;
    }

    public void scan() {
        Intent intentScan = new Intent(SCAN_INTENT);
        intentScan.addCategory(CATEGORY_DEFAULT);
        intentScan.setPackage(this.cordova.getActivity().getApplicationContext().getPackageName());
        if (this.cordova.getActivity() instanceof OPGBaseActivity) {
            ((OPGBaseActivity)this.cordova.getActivity()).enableBackButton = false;
        }
        this.cordova.startActivityForResult((CordovaPlugin)this, intentScan, 195543262);
    }

    @DoNotRename
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == 195543262) {
            if (resultCode == -1 && intent != null) {
                JSONObject obj = new JSONObject();
                try {
                    obj.put(TEXT, (Object)intent.getStringExtra(SCAN_RESULT));
                    obj.put(FORMAT, (Object)intent.getStringExtra(SCAN_RESULT_FORMAT));
                    obj.put(CANCELLED, false);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                this.callbackContext.success(obj);
            } else if (resultCode == 0 && intent != null) {
                JSONObject obj = new JSONObject();
                try {
                    obj.put(TEXT, (Object)"");
                    obj.put(FORMAT, (Object)"");
                    obj.put(CANCELLED, true);
                }
                catch (JSONException e) {
                    try {
                        obj.put(TEXT, (Object)"");
                        obj.put(FORMAT, (Object)"");
                        obj.put(CANCELLED, true);
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
                this.callbackContext.success(obj);
            } else {
                this.callbackContext.error("Unexpected error");
            }
        }
    }

    public void encode(String type, String data) {
        Intent intentEncode = new Intent(ENCODE_INTENT);
        intentEncode.putExtra(ENCODE_TYPE, type);
        intentEncode.putExtra(ENCODE_DATA, data);
        intentEncode.setPackage(this.cordova.getActivity().getApplicationContext().getPackageName());
        this.cordova.getActivity().startActivity(intentEncode);
    }

    private boolean checkPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (ActivityCompat.checkSelfPermission((Context)this.cordova.getActivity(), (String)OPGSDKConstant.CAMERA_PERMISSION) == 0) {
                return true;
            }
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.cordova.getActivity(), (String)OPGSDKConstant.CAMERA_PERMISSION)) {
                ActivityCompat.requestPermissions((Activity)this.cordova.getActivity(), (String[])this.permissions, (int)129);
            } else if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.cordova.getActivity(), (String)OPGSDKConstant.CAMERA_PERMISSION)) {
                this.showAlertDialog();
            }
            return false;
        }
        return true;
    }

    @DoNotRename
    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        for (int r : grantResults) {
            if (r != -1) continue;
            PluginResult result = new PluginResult(PluginResult.Status.ILLEGAL_ACCESS_EXCEPTION);
            this.callbackContext.sendPluginResult(result);
            return;
        }
        switch (requestCode) {
            case 0: {
                this.scan();
            }
        }
    }

    private void showAlertDialog() {
        AlertDialog.Builder builder = Build.VERSION.SDK_INT >= 21 ? new AlertDialog.Builder((Context)this.cordova.getActivity(), 16974374) : new AlertDialog.Builder((Context)this.cordova.getActivity());
        builder.setTitle((CharSequence)OPGR.getString((Context)this.cordova.getActivity(), "string", OPGSDKConstant.RUNTIME_PERMISSION)).setMessage((CharSequence)OPGR.getString((Context)this.cordova.getActivity(), "string", OPGSDKConstant.CAMERA_PERMISSION_MSG)).setPositiveButton((CharSequence)OPGR.getString((Context)this.cordova.getActivity(), "string", OPGSDKConstant.SETTINGS), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                BarcodeScanner.this.goToSettingPage();
            }
        }).setNegativeButton((CharSequence)OPGR.getString((Context)this.cordova.getActivity(), "string", OPGSDKConstant.DENY), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setIcon(17301543).show();
    }

    private void goToSettingPage() {
        Intent intent = new Intent();
        intent.setAction(OPGSDKConstant.APP_DETAILS_SETTINGS);
        Uri uri = Uri.fromParts((String)OPGSDKConstant.PACKAGE, (String)this.cordova.getActivity().getPackageName(), null);
        intent.setData(uri);
        this.cordova.getActivity().startActivity(intent);
    }

    public void onRestoreStateForActivityResult(Bundle state, CallbackContext callbackContext) {
        this.callbackContext = callbackContext;
    }
}

