/*
 * Decompiled with CFR 0.152.
 */
package com.opg.sdk.restclient;

import com.google.gson.Gson;
import com.opg.sdk.models.OPGPanellistProfile;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.json.JSONException;
import org.json.JSONObject;

public class OPGRequest {
    public static String getMd5Hash(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            String md5 = number.toString(16);
            while (md5.length() < 32) {
                md5 = "0" + md5;
            }
            return md5;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static JSONObject getAuthenticateEntity(String userName, String password, String appVersion, String signInTimeUTC) throws JSONException {
        JSONObject authEntity = new JSONObject();
        authEntity.put("UserName", (Object)userName);
        authEntity.put("Password", (Object)OPGRequest.getMd5Hash(password));
        authEntity.put("AppVersion", (Object)appVersion);
        authEntity.put("SigninTimeUtc", (Object)signInTimeUTC);
        return authEntity;
    }

    public static JSONObject getGoogleAuthEntity(String googleTokenID, String appVersion) throws JSONException {
        JSONObject authEntity = new JSONObject();
        authEntity.put("GoogleToken", (Object)googleTokenID);
        authEntity.put("AppVersion", (Object)appVersion);
        return authEntity;
    }

    public static JSONObject getFacebookAuthEntity(String facebookTokenID, String appVersion) throws JSONException {
        JSONObject authEntity = new JSONObject();
        authEntity.put("FacebookToken", (Object)facebookTokenID);
        authEntity.put("AppVersion", (Object)appVersion);
        return authEntity;
    }

    public static JSONObject getForgotPasswordEntity(String emailID, String appVersion) throws JSONException {
        JSONObject forPasswordEntity = new JSONObject();
        forPasswordEntity.put("emailID", (Object)emailID);
        forPasswordEntity.put("AppVersion", (Object)appVersion);
        return forPasswordEntity;
    }

    public static JSONObject getChangePasswordEntity(String uniqueID, String currentPassword, String newPassword) throws JSONException {
        JSONObject changePwdEntity = new JSONObject();
        changePwdEntity.put("SessionID", (Object)uniqueID);
        changePwdEntity.put("CurrentPassword", (Object)OPGRequest.getMd5Hash(currentPassword));
        changePwdEntity.put("NewPassword", (Object)OPGRequest.getMd5Hash(newPassword));
        return changePwdEntity;
    }

    public static JSONObject getSurveyListEntity(String uniqueID) throws JSONException {
        JSONObject getSurveyEntity = new JSONObject();
        getSurveyEntity.put("SessionID", (Object)uniqueID);
        return getSurveyEntity;
    }

    public static JSONObject getCountryListEntity(String uniqueID) throws JSONException {
        JSONObject getSurveyEntity = new JSONObject();
        getSurveyEntity.put("SessionID", (Object)uniqueID);
        return getSurveyEntity;
    }

    public static JSONObject getSurveyListEntityForPanelID(String uniqueID, String panelID) throws JSONException {
        JSONObject getSurveyEntity = new JSONObject();
        getSurveyEntity.put("SessionID", (Object)uniqueID);
        getSurveyEntity.put("PanelID", (Object)panelID);
        return getSurveyEntity;
    }

    public static JSONObject getGeofenceSurveyListEntity(String uniqueID, float latitude, float longitude) throws JSONException {
        JSONObject getGeofenceSurveysEntity = new JSONObject();
        getGeofenceSurveysEntity.put("SessionID", (Object)uniqueID);
        getGeofenceSurveysEntity.put("Latitude", (double)latitude);
        getGeofenceSurveysEntity.put("Longitude", (double)longitude);
        return getGeofenceSurveysEntity;
    }

    public static JSONObject getPanelistProfileEntity(String uniqueID) throws JSONException {
        JSONObject panellistProfileEntity = new JSONObject();
        panellistProfileEntity.put("SessionID", (Object)uniqueID);
        return panellistProfileEntity;
    }

    public static JSONObject getPanellistPanelEntity(String uniqueID) throws JSONException {
        JSONObject panellistPanelEntity = new JSONObject();
        panellistPanelEntity.put("SessionID", (Object)uniqueID);
        return panellistPanelEntity;
    }

    public static JSONObject getPanelPanelistEntity(String uniqueID) throws JSONException {
        JSONObject panelPanelistEntity = new JSONObject();
        panelPanelistEntity.put("SessionID", (Object)uniqueID);
        return panelPanelistEntity;
    }

    public static JSONObject getUpdatePanellistProfileEntity(String uniqueID, OPGPanellistProfile profile) throws JSONException {
        Gson gson = new Gson();
        String jsonResponse = gson.toJson((Object)profile);
        JSONObject updateProfile = new JSONObject(jsonResponse);
        updateProfile.put("SessionID", (Object)uniqueID);
        updateProfile.put("CountryCode", (Object)profile.getStd());
        return updateProfile;
    }

    public static JSONObject getSurveyScriptEntity(String uniqueID, String surveyID) throws JSONException {
        JSONObject surveyScriptEntity = new JSONObject();
        surveyScriptEntity.put("SessionID", (Object)uniqueID);
        surveyScriptEntity.put("SurveyRef", (Object)surveyID);
        return surveyScriptEntity;
    }

    public static JSONObject getNotificationEntity(String uniqueID, String deviceToken, String appVersion, String deviceID) throws JSONException {
        JSONObject surveyScriptEntity = new JSONObject();
        surveyScriptEntity.put("SessionID", (Object)uniqueID);
        surveyScriptEntity.put("DeviceTokenID", (Object)deviceToken);
        surveyScriptEntity.put("Platform", (Object)"2");
        surveyScriptEntity.put("Version", (Object)appVersion);
        surveyScriptEntity.put("DeviceID", (Object)deviceID);
        return surveyScriptEntity;
    }
}

