/*
 * Decompiled with CFR 0.152.
 */
package com.opg.sdk.restclient;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.opg.sdk.OPGPreference;
import com.opg.sdk.OPGR;
import com.opg.sdk.exceptions.OPGException;
import com.opg.sdk.models.OPGAuthenticate;
import com.opg.sdk.models.OPGChangePassword;
import com.opg.sdk.models.OPGCountry;
import com.opg.sdk.models.OPGForgotPassword;
import com.opg.sdk.models.OPGGeofenceSurvey;
import com.opg.sdk.models.OPGPanel;
import com.opg.sdk.models.OPGPanelPanellist;
import com.opg.sdk.models.OPGPanellistPanel;
import com.opg.sdk.models.OPGPanellistProfile;
import com.opg.sdk.models.OPGSurvey;
import com.opg.sdk.models.OPGSurveyPanel;
import com.opg.sdk.models.OPGTheme;
import com.opg.sdk.models.OPGUpdatePanellistProfile;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OPGParseResult {
    private static String CODE_200 = "200";

    private static Gson getGsonInstance() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();
    }

    public static OPGAuthenticate parseAuthenticate(Context context, String authResponse) throws JSONException {
        OPGAuthenticate opgAuthenticate = new OPGAuthenticate();
        if (authResponse != null || !authResponse.isEmpty()) {
            JSONObject opgJsonResponse = new JSONObject(authResponse);
            if (opgJsonResponse.has("Message")) {
                opgAuthenticate.setSuccess(false);
                opgAuthenticate.setStatusMessage(opgJsonResponse.getString("ErrorMessage"));
                opgAuthenticate.setHttpStatusCode(opgJsonResponse.getLong("HttpStatusCode"));
            } else {
                opgAuthenticate.setSuccess(true);
                opgAuthenticate.setStatusMessage("Success");
                opgAuthenticate.setUniqueID(opgJsonResponse.getString("UniqueID"));
                OPGPreference.setUniqueID(opgJsonResponse.getString("UniqueID"), context);
                if (opgJsonResponse.has("Url") && !opgJsonResponse.getString("Url").isEmpty() && !opgJsonResponse.getString("Url").equals(OPGPreference.getApiURL(context))) {
                    OPGPreference.setApiURL(opgJsonResponse.getString("Url"), context);
                }
                if (opgJsonResponse.has("InterviewUrl") && !opgJsonResponse.getString("InterviewUrl").isEmpty() && !opgJsonResponse.getString("InterviewUrl").equals(OPGPreference.getInterviewURL(context))) {
                    OPGPreference.setInterviewURL(opgJsonResponse.getString("InterviewUrl"), context);
                }
            }
            if (opgJsonResponse.has("HttpStatusCode")) {
                opgAuthenticate.setHttpStatusCode(opgJsonResponse.getLong("HttpStatusCode"));
            }
        } else {
            opgAuthenticate.setSuccess(false);
            opgAuthenticate.setStatusMessage("Authorization response is null or empty");
        }
        return opgAuthenticate;
    }

    public static OPGChangePassword parseChangePassword(String changePwdResponse) throws JSONException {
        OPGChangePassword opgChangePassword = new OPGChangePassword();
        JSONObject jsonObject = new JSONObject(changePwdResponse);
        if (jsonObject.getString("HttpStatusCode").equals(CODE_200)) {
            opgChangePassword.setSuccess(true);
            opgChangePassword.setStatusMessage(jsonObject.getString("Message"));
        } else {
            opgChangePassword.setSuccess(false);
            opgChangePassword.setStatusMessage(jsonObject.getString("ErrorMessage"));
            opgChangePassword.setHttpStatusCode(jsonObject.getLong("HttpStatusCode"));
        }
        return opgChangePassword;
    }

    public static OPGForgotPassword parseForgotPassword(Context context, String forgotPwdResponse) throws JSONException {
        OPGForgotPassword opgForgotPassword = new OPGForgotPassword();
        if (forgotPwdResponse != null || !forgotPwdResponse.isEmpty()) {
            JSONObject opgJsonResponse = new JSONObject(forgotPwdResponse);
            opgForgotPassword.setHttpStatusCode(opgJsonResponse.getInt("HttpStatusCode"));
            if (200 == opgJsonResponse.getInt("HttpStatusCode")) {
                opgForgotPassword.setSuccess(true);
                opgForgotPassword.setStatusMessage(opgJsonResponse.getString("Message"));
            } else {
                opgForgotPassword.setSuccess(false);
                opgForgotPassword.setStatusMessage(opgJsonResponse.getString("ErrorMessage"));
            }
        } else {
            opgForgotPassword.setSuccess(false);
            opgForgotPassword.setStatusMessage(OPGR.getString(context, "string", "error_forgot_password"));
        }
        return opgForgotPassword;
    }

    public static OPGPanellistProfile parsePanellistProfile(Context context, String panelistProfileResponse) throws Exception {
        OPGPanellistProfile panelistProfile = new OPGPanellistProfile();
        if (panelistProfileResponse != null && !panelistProfileResponse.isEmpty()) {
            Gson gson = OPGParseResult.getGsonInstance();
            panelistProfile = (OPGPanellistProfile)gson.fromJson(panelistProfileResponse, OPGPanellistProfile.class);
            panelistProfile.setSuccess(true);
            panelistProfile.setStatusMessage("Success");
            if (panelistProfile.getErrorMessage() != null) {
                panelistProfile.setSuccess(false);
                panelistProfile.setStatusMessage(panelistProfile.getErrorMessage());
            } else {
                JSONObject jsonObject = new JSONObject(panelistProfileResponse);
                if (jsonObject.has("Country")) {
                    OPGCountry countryGSON = (OPGCountry)gson.fromJson(jsonObject.getJSONObject("Country").toString(), OPGCountry.class);
                    panelistProfile.setCountryName(countryGSON.getCountryName());
                    panelistProfile.setStd(countryGSON.getStd());
                }
            }
        } else {
            panelistProfile.setSuccess(false);
            panelistProfile.setStatusMessage("Response from server for PanelistProfile is null or empty");
        }
        return panelistProfile;
    }

    public static OPGUpdatePanellistProfile parseUpdatePanellistProfile(String updateProfileResponse) throws JSONException {
        OPGUpdatePanellistProfile updatePanelistProfile = new OPGUpdatePanellistProfile();
        if (updateProfileResponse != null && !updateProfileResponse.isEmpty()) {
            JSONObject jsonObject = new JSONObject(updateProfileResponse);
            if (jsonObject.has("HttpStatusCode") && jsonObject.getInt("HttpStatusCode") != 200) {
                updatePanelistProfile.setSuccess(false);
                updatePanelistProfile.setStatusMessage(jsonObject.getString("ErrorMessage"));
            } else {
                updatePanelistProfile.setSuccess(true);
                updatePanelistProfile.setStatusMessage("Success");
            }
        } else {
            updatePanelistProfile.setSuccess(false);
            updatePanelistProfile.setStatusMessage("Response from server for UpdatePanelistProfile is null or empty");
        }
        return updatePanelistProfile;
    }

    public static List<OPGSurvey> parseSurveyList(String surveyListResponse) throws JSONException, OPGException {
        List surveyList = null;
        if (surveyListResponse != null && !surveyListResponse.isEmpty()) {
            if (surveyListResponse.startsWith("[")) {
                Gson gson = OPGParseResult.getGsonInstance();
                Type listType = new TypeToken<List<OPGSurvey>>(){}.getType();
                surveyList = (List)gson.fromJson(surveyListResponse, listType);
            } else {
                JSONObject jsonObject = new JSONObject(surveyListResponse);
                if (jsonObject.has("ErrorMessage")) {
                    throw new OPGException(jsonObject.getString("ErrorMessage"));
                }
            }
        } else {
            throw new OPGException("response from server for getThemes is null or empty.");
        }
        return surveyList;
    }

    public static List<OPGGeofenceSurvey> parseGeofenceSurveyList(String geofenceSurveyListResponse) throws JSONException, OPGException {
        List geofenceSurveyList = null;
        if (geofenceSurveyListResponse != null && !geofenceSurveyListResponse.isEmpty()) {
            if (geofenceSurveyListResponse.startsWith("[")) {
                Gson gson = OPGParseResult.getGsonInstance();
                Type listType = new TypeToken<List<OPGGeofenceSurvey>>(){}.getType();
                geofenceSurveyList = (List)gson.fromJson(geofenceSurveyListResponse, listType);
            } else {
                JSONObject jsonObject = new JSONObject(geofenceSurveyListResponse);
                if (jsonObject.has("ErrorMessage")) {
                    throw new OPGException(jsonObject.getString("ErrorMessage"));
                }
            }
        } else {
            throw new OPGException("Response from server in empty or null");
        }
        return geofenceSurveyList;
    }

    public static List<OPGCountry> parseCountryList(String countryListResponse) throws OPGException, JSONException {
        List opgCountryList = null;
        if (countryListResponse != null && !countryListResponse.isEmpty()) {
            if (countryListResponse.startsWith("[")) {
                Gson gson = OPGParseResult.getGsonInstance();
                Type listType = new TypeToken<List<OPGCountry>>(){}.getType();
                opgCountryList = (List)gson.fromJson(countryListResponse, listType);
            } else {
                JSONObject jsonObject = new JSONObject(countryListResponse);
                if (jsonObject.has("ErrorMessage")) {
                    throw new OPGException(jsonObject.getString("ErrorMessage"));
                }
            }
        } else {
            throw new OPGException("Response from server in empty or null");
        }
        return opgCountryList;
    }

    public static List<OPGTheme> parseThemeList(String themeResponse) throws JSONException, OPGException {
        ArrayList<OPGTheme> themeList = new ArrayList<OPGTheme>();
        if (themeResponse != null && !themeResponse.isEmpty()) {
            JSONObject jsonObject = new JSONObject(themeResponse);
            if (!jsonObject.has("ErrorMessage")) {
                JSONArray jsonArray = jsonObject.getJSONArray("Themes");
                Gson gson = OPGParseResult.getGsonInstance();
                Type listType = new TypeToken<List<OPGTheme>>(){}.getType();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONArray themeArray = jsonArray.getJSONArray(i);
                    themeList.addAll((List)gson.fromJson(themeArray.toString(), listType));
                }
            } else {
                throw new OPGException(jsonObject.getString("ErrorMessage"));
            }
        }
        return themeList;
    }

    public static List<OPGPanel> parsePanelList(String panelsResponse) throws JSONException, OPGException {
        List<OPGPanel> surveyList = new ArrayList<OPGPanel>();
        if (panelsResponse != null && !panelsResponse.isEmpty()) {
            JSONObject jsonObject = new JSONObject(panelsResponse);
            if (!jsonObject.has("ErrorMessage")) {
                Gson gson = OPGParseResult.getGsonInstance();
                JSONArray jsonArray = jsonObject.getJSONArray("Panels");
                Type listType = new TypeToken<List<OPGPanel>>(){}.getType();
                surveyList = (List)gson.fromJson(jsonArray.toString(), listType);
            } else {
                throw new OPGException(jsonObject.getString("ErrorMessage"));
            }
        }
        return surveyList;
    }

    public static List<OPGPanelPanellist> parsePanelPanellist(String panelPanellistJsonResponse) throws JSONException, OPGException {
        List<OPGPanelPanellist> panelPanellistList = new ArrayList<OPGPanelPanellist>();
        if (panelPanellistJsonResponse != null && !panelPanellistJsonResponse.isEmpty()) {
            JSONObject jsonObject = new JSONObject(panelPanellistJsonResponse);
            if (!jsonObject.has("ErrorMessage")) {
                Gson gson = OPGParseResult.getGsonInstance();
                JSONArray jsonArray = jsonObject.getJSONArray("PanelPanellist");
                Type listType = new TypeToken<List<OPGPanelPanellist>>(){}.getType();
                panelPanellistList = (List)gson.fromJson(jsonArray.toString(), listType);
            } else {
                throw new OPGException(jsonObject.getString("ErrorMessage"));
            }
        }
        return panelPanellistList;
    }

    public static List<OPGSurveyPanel> parseSurveyPanel(String panelsResponse) throws JSONException, OPGException {
        List<OPGSurveyPanel> surveyPanelList = new ArrayList<OPGSurveyPanel>();
        if (panelsResponse != null && !panelsResponse.isEmpty()) {
            JSONObject jsonObject = new JSONObject(panelsResponse);
            if (!jsonObject.has("ErrorMessage")) {
                Gson gson = OPGParseResult.getGsonInstance();
                JSONArray jsonArray = jsonObject.getJSONArray("SurveyPanel");
                Type listType = new TypeToken<List<OPGSurveyPanel>>(){}.getType();
                surveyPanelList = (List)gson.fromJson(jsonArray.toString(), listType);
            } else {
                throw new OPGException(jsonObject.getString("ErrorMessage"));
            }
        }
        return surveyPanelList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String parseMediaUpload(Context context, String response) throws OPGException, JSONException {
        String mediaId = null;
        if (response == null) throw new OPGException("Failed to upload the file");
        if (response.isEmpty()) throw new OPGException("Failed to upload the file");
        if (response.startsWith("{")) {
            JSONObject jsonObject = new JSONObject(response);
            StringBuilder builder = new StringBuilder();
            if (jsonObject.has("HttpStatusCode")) {
                builder.append("\nHttpStatusCode:").append(jsonObject.getString("HttpStatusCode"));
            }
            builder.append("Caused by: ");
            if (!jsonObject.has("ErrorMessage")) throw new OPGException(builder.toString());
            if (jsonObject.has("ErrorMessage")) {
                builder.append("\nErrorMessage:").append(jsonObject.getString("ErrorMessage"));
                throw new OPGException(builder.toString());
            } else {
                builder.append("\nErrorMessage:").append(jsonObject.getString("Message"));
            }
            throw new OPGException(builder.toString());
        }
        if (!response.startsWith("[")) throw new OPGException("Failed to upload the file");
        JSONArray array = new JSONArray(response);
        if (array.length() <= 0) return mediaId;
        return array.getString(0);
    }

    public static OPGPanellistPanel parsePanellistPanel(String jsonResponse) throws OPGException, JSONException {
        OPGPanellistPanel opgPanellistPanel = new OPGPanellistPanel();
        if (jsonResponse != null && !jsonResponse.isEmpty()) {
            JSONObject jsonObject = new JSONObject(jsonResponse);
            if (!jsonObject.has("ErrorMessage")) {
                opgPanellistPanel.setPanelPanellistArray(OPGParseResult.parsePanelPanellist(jsonResponse));
                opgPanellistPanel.setPanelArray(OPGParseResult.parsePanelList(jsonResponse));
                opgPanellistPanel.setThemeArray(OPGParseResult.parseThemeList(jsonResponse));
                opgPanellistPanel.setSurveyPanelArray(OPGParseResult.parseSurveyPanel(jsonResponse));
                opgPanellistPanel.setSuccess(true);
                opgPanellistPanel.setStatusMessage("Success");
            } else {
                opgPanellistPanel.setSuccess(false);
                opgPanellistPanel.setStatusMessage(jsonObject.getString("ErrorMessage"));
            }
        }
        return opgPanellistPanel;
    }

    public static boolean parseNotificationResponse(Context context, String notificationResponse) throws JSONException {
        JSONObject opgJsonResponse;
        boolean status = false;
        if (!(notificationResponse == null && notificationResponse.isEmpty() || 200 != (opgJsonResponse = new JSONObject(notificationResponse)).getInt("HttpStatusCode"))) {
            status = true;
        }
        return status;
    }
}

