/*
 * Decompiled with CFR 0.152.
 */
package com.opg.sdk;

import OnePoint.Common.Utils;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.provider.Settings;
import com.google.android.gms.common.api.GoogleApiClient;
import com.opg.sdk.OPGGeofenceMonitor;
import com.opg.sdk.OPGPreference;
import com.opg.sdk.exceptions.InvalidMediaTypeException;
import com.opg.sdk.exceptions.OPGException;
import com.opg.sdk.geofence.OPGGeofenceTriggerEvents;
import com.opg.sdk.models.OPGAuthenticate;
import com.opg.sdk.models.OPGChangePassword;
import com.opg.sdk.models.OPGCountry;
import com.opg.sdk.models.OPGDownloadMedia;
import com.opg.sdk.models.OPGForgotPassword;
import com.opg.sdk.models.OPGGeofenceSurvey;
import com.opg.sdk.models.OPGPanellistPanel;
import com.opg.sdk.models.OPGPanellistProfile;
import com.opg.sdk.models.OPGSurvey;
import com.opg.sdk.models.OPGTheme;
import com.opg.sdk.models.OPGUpdatePanellistProfile;
import com.opg.sdk.restclient.OPGHttpUrlRequest;
import com.opg.sdk.restclient.OPGNetworkRequest;
import com.opg.sdk.restclient.OPGParseResult;
import com.opg.sdk.restclient.OPGRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

class OPGRoot {
    public static OPGRoot getInstance() {
        return new OPGRoot();
    }

    protected static boolean validateEmail(String email) {
        String EMAIL_PATTERN = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public List<OPGGeofenceSurvey> getOpgGeofenceSurveyList(Context context) {
        return OPGPreference.getOPGGeofenceSurveys(context);
    }

    public void setOpgGeofenceSurveyList(Context context, List<OPGGeofenceSurvey> opgGeofenceSurveyList) {
        OPGPreference.clearOPGGeofenceSurveys(context);
        OPGPreference.saveOPGGeofenceSurveys(context, opgGeofenceSurveyList);
    }

    protected void initialize(String username, String sharedKey, Context context) throws OPGException {
        String apiURL = "https://api.1pt.mobi/V3.1/Api/";
        String interviewURL = "https://api.1pt.mobi/i/interview";
        String mediaURL = "https://api.1pt.mobi/i/Media?";
        if (!this.validateString(username) || !this.validateString(sharedKey)) {
            System.err.println("OPGSDK failed to initialize due to null or empty credential values for either admin username or sharedkey");
            throw new OPGException("Caused by: Null or empty credential values for either admin username or sharedkey");
        }
        if (OPGPreference.getApiURL(context) == null || OPGPreference.getApiURL(context).trim().isEmpty()) {
            OPGPreference.setApiURL(apiURL, context);
        }
        if (OPGPreference.getInterviewURL(context) == null || OPGPreference.getInterviewURL(context).trim().isEmpty()) {
            OPGPreference.setInterviewURL(interviewURL, context);
        }
        if (OPGPreference.getDownloadURL(context) == null || OPGPreference.getDownloadURL(context).trim().isEmpty()) {
            OPGPreference.setDownloadURL(mediaURL, context);
        }
        OPGPreference.setUsername(username, context);
        OPGPreference.setSharedKey(sharedKey, context);
        System.out.println("OPGSDK initialised successfully");
    }

    protected void setAppVersion(String appVersion, Context context) throws OPGException {
        if (!this.validateString(appVersion)) {
            throw new OPGException("Caused by: Null or empty  values for appversion");
        }
        OPGPreference.setAppVersion(appVersion, context);
    }

    protected String getAppVersion(Context context) {
        return OPGPreference.getAppVersion(context);
    }

    protected String getUniqueID(Context context) {
        return OPGPreference.getUniqueID(context);
    }

    protected void setUniqueID(String uniqueID, Context context) throws OPGException {
        if (!this.validateString(uniqueID)) {
            throw new OPGException("Null or empty values for uniqueid.");
        }
        OPGPreference.setUniqueID(uniqueID, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ArrayList<OPGSurvey> getUserSurveyList(Context context) throws OPGException {
        try {
            String uniqueID = OPGPreference.getUniqueID(context);
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            if (this.validateString(uniqueID) && this.validateString(sharedkey_auth) && this.validateString(username_auth)) {
                JSONObject surveyEntity = OPGRequest.getSurveyListEntity(uniqueID);
                OPGHttpUrlRequest httpUrlRequest = OPGNetworkRequest.createRequestParams(context, surveyEntity, "Survey/Surveys");
                String surveyListResponse = OPGNetworkRequest.performRequest(httpUrlRequest);
                if (!surveyListResponse.contains("UniqueID does not exist.")) return (ArrayList)OPGParseResult.parseSurveyList(surveyListResponse);
                if (!this.refreshSession(context)) throw new OPGException("Session expired.Please authenticate again");
                httpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getSurveyListEntity(OPGPreference.getUniqueID(context)), "Survey/Surveys");
                surveyListResponse = OPGNetworkRequest.performRequest(httpUrlRequest);
                return (ArrayList)OPGParseResult.parseSurveyList(surveyListResponse);
            }
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(uniqueID)) {
                builder.append("Null or empty values for uniqueid.").append("\n");
            }
            if (!this.validateString(username_auth)) {
                builder.append("Null or empty values for admin username.").append("\n");
            }
            if (this.validateString(sharedkey_auth)) throw new OPGException(builder.toString());
            builder.append("Null or empty values for admin sharedkey.").append("\n");
            throw new OPGException(builder.toString());
        }
        catch (Exception exception) {
            throw new OPGException(exception.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ArrayList<OPGSurvey> getSurveyList(Context context) throws OPGException {
        try {
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            if (this.validateString(sharedkey_auth) && this.validateString(username_auth)) {
                JSONObject surveyEntity = OPGRequest.getSurveyListEntity("");
                OPGHttpUrlRequest httpUrlRequest = OPGNetworkRequest.createRequestParams(context, surveyEntity, "Survey/Surveys");
                String surveyListResponse = OPGNetworkRequest.performRequest(httpUrlRequest);
                if (!surveyListResponse.contains("UniqueID does not exist.")) return (ArrayList)OPGParseResult.parseSurveyList(surveyListResponse);
                if (!this.refreshSession(context)) throw new OPGException("Session expired.Please authenticate again");
                httpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getSurveyListEntity(""), "Survey/Surveys");
                surveyListResponse = OPGNetworkRequest.performRequest(httpUrlRequest);
                return (ArrayList)OPGParseResult.parseSurveyList(surveyListResponse);
            }
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(username_auth)) {
                builder.append("Null or empty values for admin username.").append("\n");
            }
            if (this.validateString(sharedkey_auth)) throw new OPGException(builder.toString());
            builder.append("Null or empty values for admin sharedkey.").append("\n");
            throw new OPGException(builder.toString());
        }
        catch (Exception exception) {
            throw new OPGException(exception.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<OPGSurvey> getSurveys(Context context, String panelID) throws OPGException {
        List<OPGSurvey> surveyList = null;
        try {
            String uniqueID = OPGPreference.getUniqueID(context);
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            if (this.validateString(panelID) && this.validateString(uniqueID) && this.validateString(sharedkey_auth) && this.validateString(username_auth)) {
                JSONObject surveyEntity = OPGRequest.getSurveyListEntityForPanelID(uniqueID, panelID);
                OPGHttpUrlRequest httpUrlRequest = OPGNetworkRequest.createRequestParams(context, surveyEntity, "Survey/Surveys");
                String surveyListResponse = OPGNetworkRequest.performRequest(httpUrlRequest);
                if (!surveyListResponse.contains("UniqueID does not exist.")) return OPGParseResult.parseSurveyList(surveyListResponse);
                if (!this.refreshSession(context)) throw new OPGException("Session expired.Please authenticate again");
                httpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getSurveyListEntityForPanelID(OPGPreference.getUniqueID(context), panelID), "Survey/Surveys");
                surveyListResponse = OPGNetworkRequest.performRequest(httpUrlRequest);
                return OPGParseResult.parseSurveyList(surveyListResponse);
            }
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(panelID)) {
                builder.append("Null or empty values for paneliid.").append("\n");
            }
            if (!this.validateString(uniqueID)) {
                builder.append("Null or empty values for uniqueid.").append("\n");
            }
            if (!this.validateString(username_auth)) {
                builder.append("Null or empty values for admin username.").append("\n");
            }
            if (this.validateString(sharedkey_auth)) throw new OPGException(builder.toString());
            builder.append("Null or empty values for admin sharedkey.").append("\n");
            throw new OPGException(builder.toString());
        }
        catch (Exception exception) {
            throw new OPGException(exception.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<OPGGeofenceSurvey> getGeofenceSurveys(Context context, float latitude, float longitude) throws OPGException {
        List<OPGGeofenceSurvey> geofenceSurveys = null;
        try {
            String uniqueID = OPGPreference.getUniqueID(context);
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            if (this.validateString(String.valueOf(latitude)) && this.validateString(String.valueOf(longitude)) && this.validateString(uniqueID) && this.validateString(sharedkey_auth) && this.validateString(username_auth)) {
                JSONObject geofenceEntity = OPGRequest.getGeofenceSurveyListEntity(uniqueID, latitude, longitude);
                OPGHttpUrlRequest httpUrlRequest = OPGNetworkRequest.createRequestParams(context, geofenceEntity, "Geofencing/Geofencing");
                String geofenceSurveyListResponse = OPGNetworkRequest.performRequest(httpUrlRequest);
                if (!geofenceSurveyListResponse.contains("UniqueID does not exist.")) return OPGParseResult.parseGeofenceSurveyList(geofenceSurveyListResponse);
                if (!this.refreshSession(context)) throw new OPGException("Session expired.Please authenticate again");
                httpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getGeofenceSurveyListEntity(OPGPreference.getUniqueID(context), latitude, longitude), "Geofencing/Geofencing");
                geofenceSurveyListResponse = OPGNetworkRequest.performRequest(httpUrlRequest);
                return OPGParseResult.parseGeofenceSurveyList(geofenceSurveyListResponse);
            }
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(String.valueOf(latitude))) {
                builder.append("Null or empty values for  latitude.").append("\n");
            }
            if (!this.validateString(String.valueOf(longitude))) {
                builder.append("Null or empty values for  longitude.").append("\n");
            }
            if (!this.validateString(uniqueID)) {
                builder.append("Null or empty values for uniqueid.").append("\n");
            }
            if (!this.validateString(username_auth)) {
                builder.append("Null or empty values for admin username.").append("\n");
            }
            if (this.validateString(sharedkey_auth)) throw new OPGException(builder.toString());
            builder.append("Null or empty values for admin sharedkey.").append("\n");
            throw new OPGException(builder.toString());
        }
        catch (Exception exception) {
            throw new OPGException(exception.getMessage());
        }
    }

    protected OPGAuthenticate authenticate(String userName, String password, Context mContext) {
        OPGAuthenticate opgAuthenticate = null;
        String appVersion = OPGPreference.getAppVersion(mContext);
        String username_auth = OPGPreference.getUsername(mContext);
        String sharedkey_auth = OPGPreference.getSharedKey(mContext);
        if (this.validateString(username_auth) && this.validateString(sharedkey_auth) && this.validateString(userName) && this.validateString(password) && this.validateString(appVersion)) {
            try {
                OPGPreference.setAppLoginUsername(mContext, userName);
                OPGPreference.setAppLoginPassword(mContext, password);
                JSONObject authEntity = OPGRequest.getAuthenticateEntity(userName, password, OPGPreference.getAppVersion(mContext), Utils.convertToUTCFromDate(new Date()));
                OPGHttpUrlRequest opgReqObj = OPGNetworkRequest.createRequestParams(mContext, authEntity, "Authentication");
                String authResponse = OPGNetworkRequest.performRequest(opgReqObj);
                opgAuthenticate = OPGParseResult.parseAuthenticate(mContext, authResponse);
            }
            catch (Exception e) {
                opgAuthenticate = new OPGAuthenticate();
                opgAuthenticate.setStatusMessage(e.toString());
                opgAuthenticate.setSuccess(false);
            }
        } else {
            opgAuthenticate = new OPGAuthenticate();
            opgAuthenticate.setSuccess(false);
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(username_auth)) {
                builder.append("Null or empty values for admin username.").append("\n");
            }
            if (!this.validateString(sharedkey_auth)) {
                builder.append("Null or empty values for admin sharedkey.").append("\n");
            }
            if (!this.validateString(userName)) {
                builder.append("Null or empty values for login username.").append("\n");
            }
            if (!this.validateString(password)) {
                builder.append("Null or empty values for login password.").append("\n");
            }
            if (!this.validateString(appVersion)) {
                builder.append("Caused by: Null or empty  values for appversion").append("\n");
            }
            opgAuthenticate.setStatusMessage(builder.toString());
        }
        return opgAuthenticate;
    }

    protected OPGAuthenticate authenticateWithGoogle(String googleTokenID, Context mContext) {
        OPGAuthenticate opgAuthenticate = null;
        String appVersion = OPGPreference.getAppVersion(mContext);
        String username_auth = OPGPreference.getUsername(mContext);
        String sharedkey_auth = OPGPreference.getSharedKey(mContext);
        if (this.validateString(username_auth) && this.validateString(sharedkey_auth) && this.validateString(googleTokenID) && this.validateString(appVersion)) {
            try {
                OPGPreference.setGoogleToken(mContext, googleTokenID);
                JSONObject authEntity = OPGRequest.getGoogleAuthEntity(googleTokenID, appVersion);
                OPGHttpUrlRequest opgReqObj = OPGNetworkRequest.createRequestParams(mContext, authEntity, "SocialLogin/GoogleLogin");
                String authResponse = OPGNetworkRequest.performRequest(opgReqObj);
                opgAuthenticate = OPGParseResult.parseAuthenticate(mContext, authResponse);
            }
            catch (Exception e) {
                opgAuthenticate = new OPGAuthenticate();
                opgAuthenticate.setStatusMessage(e.toString());
                opgAuthenticate.setSuccess(false);
            }
        } else {
            opgAuthenticate = new OPGAuthenticate();
            opgAuthenticate.setSuccess(false);
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(username_auth)) {
                builder.append("Null or empty values for admin username.").append("\n");
            }
            if (!this.validateString(sharedkey_auth)) {
                builder.append("Null or empty values for admin sharedkey.").append("\n");
            }
            if (!this.validateString(googleTokenID)) {
                builder.append("Null or empty values for google tokenID.").append("\n");
            }
            if (!this.validateString(appVersion)) {
                builder.append("Caused by: Null or empty  values for appversion").append("\n");
            }
            opgAuthenticate.setStatusMessage(builder.toString());
        }
        return opgAuthenticate;
    }

    protected OPGAuthenticate authenticateWithFacebook(String facebookTokenID, Context mContext) {
        OPGAuthenticate opgAuthenticate = null;
        String appVersion = OPGPreference.getAppVersion(mContext);
        String username_auth = OPGPreference.getUsername(mContext);
        String sharedkey_auth = OPGPreference.getSharedKey(mContext);
        if (this.validateString(username_auth) && this.validateString(sharedkey_auth) && this.validateString(facebookTokenID) && this.validateString(appVersion)) {
            try {
                OPGPreference.setFacebookToken(mContext, facebookTokenID);
                JSONObject authEntity = OPGRequest.getFacebookAuthEntity(facebookTokenID, appVersion);
                OPGHttpUrlRequest opgReqObj = OPGNetworkRequest.createRequestParams(mContext, authEntity, "SocialLogin/FacebookLogin");
                String authResponse = OPGNetworkRequest.performRequest(opgReqObj);
                opgAuthenticate = OPGParseResult.parseAuthenticate(mContext, authResponse);
            }
            catch (Exception e) {
                opgAuthenticate = new OPGAuthenticate();
                opgAuthenticate.setStatusMessage(e.toString());
                opgAuthenticate.setSuccess(false);
            }
        } else {
            opgAuthenticate = new OPGAuthenticate();
            opgAuthenticate.setSuccess(false);
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(username_auth)) {
                builder.append("Null or empty values for admin username.").append("\n");
            }
            if (!this.validateString(sharedkey_auth)) {
                builder.append("Null or empty values for admin sharedkey.").append("\n");
            }
            if (!this.validateString(facebookTokenID)) {
                builder.append("Null or empty values for facebook tokenID.").append("\n");
            }
            if (!this.validateString(appVersion)) {
                builder.append("Caused by: Null or empty  values for appversion").append("\n");
            }
            opgAuthenticate.setStatusMessage(builder.toString());
        }
        return opgAuthenticate;
    }

    protected OPGChangePassword changePassword(Context context, String currentPassword, String newPassword) {
        OPGChangePassword opgChangePassword = new OPGChangePassword();
        String uniqueID = OPGPreference.getUniqueID(context);
        if (this.validateString(uniqueID) && this.validateString(currentPassword) && this.validateString(newPassword) && !currentPassword.equals(newPassword)) {
            try {
                JSONObject changePwdEntity = OPGRequest.getChangePasswordEntity(uniqueID, currentPassword, newPassword);
                OPGHttpUrlRequest opgReqObj = OPGNetworkRequest.createRequestParams(context, changePwdEntity, "ChangePassword");
                String changePwdResponse = OPGNetworkRequest.performRequest(opgReqObj);
                if (changePwdResponse.contains("UniqueID does not exist.")) {
                    if (this.refreshSession(context)) {
                        opgReqObj = OPGNetworkRequest.createRequestParams(context, OPGRequest.getChangePasswordEntity(OPGPreference.getUniqueID(context), currentPassword, newPassword), "ChangePassword");
                        changePwdResponse = OPGNetworkRequest.performRequest(opgReqObj);
                    } else {
                        opgChangePassword.setSuccess(false);
                        opgChangePassword.setStatusMessage("Session expired.Please authenticate again");
                        return opgChangePassword;
                    }
                }
                if ((opgChangePassword = OPGParseResult.parseChangePassword(changePwdResponse)).isSuccess()) {
                    OPGPreference.setAppLoginPassword(context, newPassword);
                }
            }
            catch (Exception e) {
                opgChangePassword.setSuccess(false);
                opgChangePassword.setStatusMessage(e.toString());
            }
        } else {
            opgChangePassword = new OPGChangePassword();
            opgChangePassword.setSuccess(false);
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(uniqueID)) {
                builder.append("Null or empty values for uniqueid.").append("\n");
            }
            if (!this.validateString(currentPassword)) {
                builder.append("Null or empty values for current password.").append("\n");
            }
            if (!this.validateString(newPassword)) {
                builder.append("Null or empty values for new password.").append("\n");
            } else if (currentPassword.equals(newPassword)) {
                builder.append("Current password and new password should not be same").append("\n");
            }
            opgChangePassword.setStatusMessage(builder.toString());
        }
        return opgChangePassword;
    }

    protected OPGForgotPassword forgotPassword(String emailID, Context context) {
        OPGForgotPassword forgotPassword = new OPGForgotPassword();
        String appVersion = OPGPreference.getAppVersion(context);
        String username_auth = OPGPreference.getUsername(context);
        String sharedkey_auth = OPGPreference.getSharedKey(context);
        if (this.validateString(username_auth) && this.validateString(sharedkey_auth) && this.validateString(appVersion) && this.validateString(emailID) && OPGRoot.validateEmail(emailID)) {
            try {
                JSONObject forPasswordEntity = OPGRequest.getForgotPasswordEntity(emailID, appVersion);
                OPGHttpUrlRequest opgReqObj = OPGNetworkRequest.createRequestParams(context, forPasswordEntity, "ForgotPassword");
                String forPasswordResponse = OPGNetworkRequest.performRequest(opgReqObj);
                forgotPassword = OPGParseResult.parseForgotPassword(context, forPasswordResponse);
            }
            catch (Exception e) {
                forgotPassword.setStatusMessage(e.toString());
                forgotPassword.setSuccess(false);
            }
        } else {
            forgotPassword.setSuccess(false);
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(username_auth)) {
                builder.append("Null or empty values for admin username.").append("\n");
            }
            if (!this.validateString(sharedkey_auth)) {
                builder.append("Null or empty values for admin sharedkey.").append("\n");
            }
            if (!this.validateString(appVersion)) {
                builder.append("Caused by: Null or empty  values for appversion").append("\n");
            }
            if (!this.validateString(emailID)) {
                builder.append("Null or empty values for email id.").append("\n");
            } else if (!OPGRoot.validateEmail(emailID)) {
                builder.append("Invalid email id").append("\n");
            }
            forgotPassword.setStatusMessage(builder.toString());
        }
        return forgotPassword;
    }

    private boolean refreshSession(Context context) {
        OPGAuthenticate authenticate = new OPGAuthenticate();
        switch (OPGPreference.getLoginType(context)) {
            case 0: {
                authenticate = this.authenticate(OPGPreference.getAppLoginUsername(context), OPGPreference.getAppLoginPassword(context), context);
                break;
            }
            case 1: {
                authenticate = this.authenticateWithGoogle(OPGPreference.getGoogleToken(context), context);
                break;
            }
            case 2: {
                authenticate = this.authenticateWithFacebook(OPGPreference.getFacebookToken(context), context);
            }
        }
        return authenticate.isSuccess();
    }

    protected OPGPanellistProfile getPanellistProfile(Context context) {
        OPGPanellistProfile opgPanelistProfile = new OPGPanellistProfile();
        try {
            String uniqueID = OPGPreference.getUniqueID(context);
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            if (this.validateString(uniqueID) && this.validateString(sharedkey_auth) && this.validateString(username_auth)) {
                JSONObject panelistProfileEntity = OPGRequest.getPanelistProfileEntity(uniqueID);
                OPGHttpUrlRequest opgHttpUrlRequest = OPGNetworkRequest.createRequestParams(context, panelistProfileEntity, "PanellistProfile/Profiles");
                String panelistProfileResponse = OPGNetworkRequest.performRequest(opgHttpUrlRequest);
                if (panelistProfileResponse.contains("UniqueID does not exist.")) {
                    if (this.refreshSession(context)) {
                        opgHttpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getPanelistProfileEntity(OPGPreference.getUniqueID(context)), "PanellistProfile/Profiles");
                        panelistProfileResponse = OPGNetworkRequest.performRequest(opgHttpUrlRequest);
                    } else {
                        opgPanelistProfile.setSuccess(false);
                        opgPanelistProfile.setStatusMessage("Session expired.Please authenticate again");
                        return opgPanelistProfile;
                    }
                }
                opgPanelistProfile = OPGParseResult.parsePanellistProfile(context, panelistProfileResponse);
            } else {
                StringBuilder builder = new StringBuilder();
                opgPanelistProfile.setSuccess(false);
                if (!this.validateString(uniqueID)) {
                    builder.append("Null or empty values for uniqueid.").append("\n");
                }
                if (!this.validateString(username_auth)) {
                    builder.append("Null or empty values for admin username.").append("\n");
                }
                if (!this.validateString(sharedkey_auth)) {
                    builder.append("Null or empty values for admin sharedkey.").append("\n");
                }
                opgPanelistProfile.setStatusMessage(builder.toString());
            }
        }
        catch (Exception exception) {
            opgPanelistProfile.setSuccess(false);
            opgPanelistProfile.setStatusMessage(exception.getMessage());
        }
        return opgPanelistProfile;
    }

    protected OPGUpdatePanellistProfile updatePanellistProfile(Context context, OPGPanellistProfile panellistProfile) {
        OPGUpdatePanellistProfile opgUpdatePanellistProfile = new OPGUpdatePanellistProfile();
        try {
            String uniqueID = OPGPreference.getUniqueID(context);
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            if (this.validateString(uniqueID) && this.validateString(sharedkey_auth) && this.validateString(username_auth)) {
                JSONObject jsonObject = OPGRequest.getUpdatePanellistProfileEntity(uniqueID, panellistProfile);
                OPGHttpUrlRequest httpUrlRequest = OPGNetworkRequest.createRequestParams(context, jsonObject, "UpdatePanelList/Update");
                String response = OPGNetworkRequest.performRequest(httpUrlRequest);
                if (response.contains("UniqueID does not exist.")) {
                    if (this.refreshSession(context)) {
                        httpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getUpdatePanellistProfileEntity(OPGPreference.getUniqueID(context), panellistProfile), "UpdatePanelList/Update");
                        response = OPGNetworkRequest.performRequest(httpUrlRequest);
                    } else {
                        opgUpdatePanellistProfile.setSuccess(false);
                        opgUpdatePanellistProfile.setStatusMessage("Session expired.Please authenticate again");
                        return opgUpdatePanellistProfile;
                    }
                }
                opgUpdatePanellistProfile = OPGParseResult.parseUpdatePanellistProfile(response);
            } else {
                StringBuilder builder = new StringBuilder();
                opgUpdatePanellistProfile.setSuccess(false);
                if (!this.validateString(uniqueID)) {
                    builder.append("Null or empty values for uniqueid.").append("\n");
                }
                if (!this.validateString(username_auth)) {
                    builder.append("Null or empty values for admin username.").append("\n");
                }
                if (!this.validateString(sharedkey_auth)) {
                    builder.append("Null or empty values for admin sharedkey.").append("\n");
                }
                opgUpdatePanellistProfile.setStatusMessage(builder.toString());
            }
        }
        catch (Exception exception) {
            opgUpdatePanellistProfile.setSuccess(false);
            opgUpdatePanellistProfile.setStatusMessage(exception.getMessage());
        }
        return opgUpdatePanellistProfile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String uploadMediaFile(Context mContext, String mediaFilePath) throws Exception {
        String mediaID = null;
        String uniqueID = OPGPreference.getUniqueID(mContext);
        String username_auth = OPGPreference.getUsername(mContext);
        String sharedkey_auth = OPGPreference.getSharedKey(mContext);
        if (this.validateString(username_auth) && this.validateString(sharedkey_auth) && this.validateString(mediaFilePath)) {
            File mediaFile = new File(mediaFilePath);
            if (mediaFile == null) throw new OPGException("Caused by:File not found");
            if (!mediaFile.exists()) throw new OPGException("Caused by:File not found");
            String mediaRoute = uniqueID == null ? "Media/Post" : "Media/Post?Data=" + uniqueID;
            String base64auth = OPGNetworkRequest.getBase64Auth(mContext);
            String response = OPGNetworkRequest.uploadMediaRequest(mContext, mediaRoute, base64auth, mediaFilePath, null, 0L);
            if (!response.contains("UniqueID does not exist.")) return OPGParseResult.parseMediaUpload(mContext, response);
            if (!this.refreshSession(mContext)) throw new OPGException("Session expired.Please authenticate again");
            uniqueID = OPGPreference.getUniqueID(mContext);
            mediaRoute = uniqueID == null ? "Media/Post" : "Media/Post?Data=" + uniqueID;
            response = OPGNetworkRequest.uploadMediaRequest(mContext, mediaRoute, base64auth, mediaFilePath, null, 0L);
            return OPGParseResult.parseMediaUpload(mContext, response);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Caused by: ");
        if (!this.validateString(username_auth)) {
            builder.append("Null or empty values for admin username.").append("\n");
        }
        if (!this.validateString(sharedkey_auth)) {
            builder.append("Null or empty values for admin sharedkey.").append("\n");
        }
        if (this.validateString(mediaFilePath)) throw new OPGException(builder.toString());
        builder.append("Null or empty values for media path.").append("\n");
        throw new OPGException(builder.toString());
    }

    protected OPGDownloadMedia downloadMediaFile(Context mContext, String mediaID, String mediaType) {
        OPGDownloadMedia opgDownloadMedia;
        block10: {
            opgDownloadMedia = new OPGDownloadMedia();
            if (this.validateString(mediaID) && this.validateString(mediaType)) {
                try {
                    try {
                        File file;
                        String filePath = this.searchFile(mContext, mediaID, mediaType);
                        if (filePath != null && (file = new File(filePath)).exists()) {
                            file.delete();
                        }
                    }
                    catch (Exception filePath) {
                        // empty catch block
                    }
                    String tempDir = Environment.getExternalStorageDirectory() + File.separator + Utils.getApplicationName(mContext) + File.separator + "OpgMedia/";
                    String fileName = this.getNewFileName(mContext, mediaID, mediaType);
                    boolean downloadStatus = OPGNetworkRequest.downloadMediaRequest(mContext, mediaID, mediaType, fileName, tempDir);
                    if (downloadStatus) {
                        opgDownloadMedia.setSuccess(true);
                        opgDownloadMedia.setStatusMessage("Downloaded the media successfully.");
                        opgDownloadMedia.setMediaPath(tempDir + File.separator + fileName);
                        break block10;
                    }
                    opgDownloadMedia.setSuccess(false);
                    opgDownloadMedia.setStatusMessage("Failed to download  the media.");
                    opgDownloadMedia.setMediaPath(null);
                }
                catch (Exception e) {
                    opgDownloadMedia.setSuccess(false);
                    opgDownloadMedia.setStatusMessage(e.toString());
                    opgDownloadMedia.setMediaPath(null);
                }
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("Caused by: ");
                if (!this.validateString(mediaID)) {
                    builder.append("Null or empty values for media path.").append("\n");
                }
                if (!this.validateString(mediaType)) {
                    builder.append("Null or empty values for media type.").append("\n");
                }
                opgDownloadMedia.setSuccess(false);
                opgDownloadMedia.setStatusMessage(builder.toString());
                opgDownloadMedia.setMediaPath(null);
            }
        }
        return opgDownloadMedia;
    }

    private String searchFile(Context mContext, String mediaID, String mediaType) {
        String tempDir = Environment.getExternalStorageDirectory() + File.separator + Utils.getApplicationName(mContext) + File.separator + "OpgMedia/";
        File[] files = new File(tempDir).listFiles();
        if (files != null) {
            Bitmap bitmap;
            String filepath = null;
            for (File file : files) {
                if (!file.getName().equalsIgnoreCase(mediaID + "." + mediaType)) continue;
                filepath = file.getAbsolutePath();
                break;
            }
            if (filepath != null && (bitmap = BitmapFactory.decodeFile(filepath)) == null) {
                File file = new File(filepath);
                if (file.exists()) {
                    file.delete();
                }
                filepath = null;
            }
            return filepath;
        }
        return null;
    }

    protected void logout(Context context) {
        OPGPreference.clearOPGPreference(context);
    }

    protected boolean validateString(String value) {
        return value != null && !value.isEmpty();
    }

    protected String register(Context context, String deviceToken) {
        String response = null;
        try {
            String uniqueID = OPGPreference.getUniqueID(context);
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            String appVersion = OPGPreference.getAppVersion(context);
            if (this.validateString(deviceToken) && this.validateString(uniqueID) && this.validateString(sharedkey_auth) && this.validateString(username_auth) && this.validateString(appVersion)) {
                String deviceID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                JSONObject notificationRegisterEntity = OPGRequest.getNotificationEntity(uniqueID, deviceToken, appVersion, deviceID);
                OPGHttpUrlRequest httpUrlRequest = OPGNetworkRequest.createRequestParams(context, notificationRegisterEntity, "PushNotification/Post");
                response = OPGNetworkRequest.performRequest(httpUrlRequest);
                if (response.contains("UniqueID does not exist.")) {
                    if (this.refreshSession(context)) {
                        httpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getNotificationEntity(OPGPreference.getUniqueID(context), deviceToken, appVersion, deviceID), "PushNotification/Post");
                        response = OPGNetworkRequest.performRequest(httpUrlRequest);
                    } else {
                        response = "Session expired.Please authenticate again";
                    }
                }
            } else {
                StringBuilder builder = new StringBuilder();
                if (!this.validateString(uniqueID)) {
                    builder.append("Null or empty values for uniqueid.").append("\n");
                }
                if (!this.validateString(username_auth)) {
                    builder.append("Null or empty values for admin username.").append("\n");
                }
                if (!this.validateString(sharedkey_auth)) {
                    builder.append("Null or empty values for admin sharedkey.").append("\n");
                }
                if (!this.validateString(appVersion)) {
                    builder.append("Caused by: Null or empty  values for appversion").append("\n");
                }
                if (!this.validateString(deviceToken)) {
                    builder.append("Null or empty values for Device Token.").append("\n");
                }
                response = builder.toString();
            }
        }
        catch (Exception exception) {
            response = exception.getMessage();
        }
        return response;
    }

    protected String unRegister(Context context, String deviceToken) {
        String response = null;
        try {
            String uniqueID = OPGPreference.getUniqueID(context);
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            String appVersion = OPGPreference.getAppVersion(context);
            if (this.validateString(deviceToken) && this.validateString(uniqueID) && this.validateString(sharedkey_auth) && this.validateString(username_auth) && this.validateString(appVersion)) {
                String deviceID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                JSONObject notificationUnRegisterEntity = OPGRequest.getNotificationEntity(uniqueID, deviceToken, appVersion, deviceID);
                OPGHttpUrlRequest httpUrlRequest = OPGNetworkRequest.createRequestParams(context, notificationUnRegisterEntity, "PushNotification/Delete");
                response = OPGNetworkRequest.performRequest(httpUrlRequest);
                if (response.contains("UniqueID does not exist.")) {
                    if (this.refreshSession(context)) {
                        httpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getNotificationEntity(OPGPreference.getUniqueID(context), deviceToken, appVersion, deviceID), "PushNotification/Delete");
                        response = OPGNetworkRequest.performRequest(httpUrlRequest);
                    } else {
                        response = "Session expired.Please authenticate again";
                    }
                }
            } else {
                StringBuilder builder = new StringBuilder();
                if (!this.validateString(uniqueID)) {
                    builder.append("Null or empty values for uniqueid.").append("\n");
                }
                if (!this.validateString(username_auth)) {
                    builder.append("Null or empty values for admin username.").append("\n");
                }
                if (!this.validateString(sharedkey_auth)) {
                    builder.append("Null or empty values for admin sharedkey.").append("\n");
                }
                if (!this.validateString(appVersion)) {
                    builder.append("Caused by: Null or empty  values for appversion").append("\n");
                }
                if (!this.validateString(deviceToken)) {
                    builder.append("Null or empty values for Device Token.").append("\n");
                }
                response = builder.toString();
            }
        }
        catch (Exception exception) {
            response = exception.getMessage();
        }
        return response;
    }

    protected OPGPanellistPanel getPanellistPanel(Context context) {
        OPGPanellistPanel opgPanellistPanel = new OPGPanellistPanel();
        try {
            String uniqueID = OPGPreference.getUniqueID(context);
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            if (this.validateString(uniqueID) && this.validateString(sharedkey_auth) && this.validateString(username_auth)) {
                JSONObject opgSurveyPanelsEntity = OPGRequest.getPanellistPanelEntity(uniqueID);
                OPGHttpUrlRequest httpUrlRequest = OPGNetworkRequest.createRequestParams(context, opgSurveyPanelsEntity, "PanellistPanel/Panels");
                String response = OPGNetworkRequest.performRequest(httpUrlRequest);
                if (response.contains("UniqueID does not exist.")) {
                    if (this.refreshSession(context)) {
                        httpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getPanellistPanelEntity(OPGPreference.getUniqueID(context)), "PanellistPanel/Panels");
                        response = OPGNetworkRequest.performRequest(httpUrlRequest);
                    } else {
                        throw new OPGException("Session expired.Please authenticate again");
                    }
                }
                opgPanellistPanel = OPGParseResult.parsePanellistPanel(response);
            } else {
                StringBuilder builder = new StringBuilder();
                if (!this.validateString(uniqueID)) {
                    builder.append("Null or empty values for uniqueid.").append("\n");
                }
                if (!this.validateString(username_auth)) {
                    builder.append("Null or empty values for admin username.").append("\n");
                }
                if (!this.validateString(sharedkey_auth)) {
                    builder.append("Null or empty values for admin sharedkey.").append("\n");
                }
                opgPanellistPanel.setSuccess(false);
                opgPanellistPanel.setStatusMessage(builder.toString());
            }
        }
        catch (Exception exception) {
            opgPanellistPanel.setSuccess(false);
            opgPanellistPanel.setStatusMessage(exception.getMessage());
        }
        return opgPanellistPanel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ArrayList<OPGCountry> getCountries(Context context) throws OPGException {
        ArrayList opgCountries = null;
        try {
            String uniqueID = OPGPreference.getUniqueID(context);
            String sharedkey_auth = OPGPreference.getSharedKey(context);
            String username_auth = OPGPreference.getUsername(context);
            if (this.validateString(uniqueID) && this.validateString(sharedkey_auth) && this.validateString(username_auth)) {
                JSONObject surveyEntity = OPGRequest.getCountryListEntity(uniqueID);
                OPGHttpUrlRequest httpUrlRequest = OPGNetworkRequest.createRequestParams(context, surveyEntity, "UpdatePanelList/Country");
                String response = OPGNetworkRequest.performRequest(httpUrlRequest);
                if (!response.contains("UniqueID does not exist.")) return (ArrayList)OPGParseResult.parseCountryList(response);
                if (!this.refreshSession(context)) throw new OPGException("Session expired.Please authenticate again");
                httpUrlRequest = OPGNetworkRequest.createRequestParams(context, OPGRequest.getCountryListEntity(OPGPreference.getUniqueID(context)), "UpdatePanelList/Country");
                response = OPGNetworkRequest.performRequest(httpUrlRequest);
                return (ArrayList)OPGParseResult.parseCountryList(response);
            }
            StringBuilder builder = new StringBuilder();
            if (!this.validateString(uniqueID)) {
                builder.append("Null or empty values for uniqueid.").append("\n");
            }
            if (!this.validateString(username_auth)) {
                builder.append("Null or empty values for admin username.").append("\n");
            }
            if (this.validateString(sharedkey_auth)) throw new OPGException(builder.toString());
            builder.append("Null or empty values for admin sharedkey.").append("\n");
            throw new OPGException(builder.toString());
        }
        catch (Exception exception) {
            throw new OPGException(exception.getMessage());
        }
    }

    String getNewFileName(Context mContext, String mediaID, String mediaType) throws InvalidMediaTypeException {
        StringBuilder fileName = new StringBuilder();
        fileName.append(mediaID).append(".").append(mediaType);
        return fileName.toString();
    }

    protected void startGeofencingMonitor(Context mContext, GoogleApiClient googleApiClient, List<OPGGeofenceSurvey> opgGeofencesList, OPGGeofenceTriggerEvents opgGeofenceTriggerEvents) throws OPGException {
        OPGGeofenceMonitor.getInstance().startGeofencingMonitor(mContext, googleApiClient, opgGeofencesList, opgGeofenceTriggerEvents);
    }

    protected void stopGeofencingMonitor(Context mContext, GoogleApiClient googleApiClient, OPGGeofenceTriggerEvents opgGeofenceTriggerEvents) throws OPGException {
        OPGGeofenceMonitor.getInstance().stopGeofencingMonitor(mContext, googleApiClient, opgGeofenceTriggerEvents);
    }

    public OPGGeofenceTriggerEvents getOpgGeofenceTriggerEvents() {
        return OPGGeofenceMonitor.getInstance().getOpgGeofenceTriggerEvents();
    }

    public void setOpgGeofenceTriggerEvents(OPGGeofenceTriggerEvents opgGeofenceTriggerEvents) {
        OPGGeofenceMonitor.getInstance().setOpgGeofenceTriggerEvents(opgGeofenceTriggerEvents);
    }

    protected HashMap<String, String> getThemesForPanel(Context context, long panelThemeTemplateID, List<OPGTheme> opgThemes) {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        for (OPGTheme opgTheme : opgThemes) {
            if (panelThemeTemplateID != opgTheme.getThemeTemplateID()) continue;
            hashMap.put(opgTheme.getName(), opgTheme.getValue());
        }
        return hashMap;
    }
}

