/*
 * Decompiled with CFR 0.152.
 */
package OnePoint.CordovaPlugin;

import android.content.Context;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.json.JSONException;
import org.json.JSONObject;

public class RootPlugin
extends CordovaPlugin {
    public static final String DOLLAR_SIGN = "$";
    public static final String ACTION_NETWORK = "_network";
    public static final String ACTION_DATABASE = "_database";
    public static final String ACTION_LOGIN = "login";
    public static final String ACTION_PANELS = "panels";
    public static final String ACTION_FETCH_PROFILE = "fetchProfile";
    public static final String ACTION_EDIT_PROFILE = "editProfile";
    public static final String ACTION_CHANGE_PASSWORD = "changePassword";
    public static final String ACTION_FORGOT_PASSWORD = "forgotPassword";
    public static final String ACTION_ENABLE_GPS = "enableGPS";
    public static final String ACTION_SURVEY = "survey";
    public static final String ACTION_MEDIA_UPLOAD = "mediaUpload";
    public static final String ACTION_MEDIA_DOWNLOAD = "mediaDownload";
    public static final String ACTION_PICK_MEDIA = "local";
    public static final String ACTION_LOCAL_STORAGE_GET = "get";
    public static final String ACTION_LOCAL_STORAGE_SET = "set";
    public static final String ACTION_TAKE_SURVEY = "takeSurvey";
    public static final String ACTION_UPDATE_TAKE_SURVEY = "updateTakeSurvey";
    public static final String ACTION_LOGOUT = "logout";
    public static final String ACTION_CHECK_FOR_UPDATES = "checkForUpdatesPlugin";
    public static final String ACTION_KEYBOARD_SHOW = "show";
    public static final String ACTION_KEYBOARD_HIDE = "hide";
    public static final String ACTION_FETCH_ABSELUTE_PATH = "_getPath";
    public static final String ACTION_APPUPDATE = "appUpdate";
    public static final String ACTION_OPEN_IN_BROWSER = "openWindow";
    public static final String ACTION_UPLOAD_OFFLINE_SURVEY_RESULTS = "uploadOfflineResults";
    public static final String ACTION_LOAD_NOTIFICATIONS = "loadNotifications";
    public static final String ACTION_DELETE_NOTIFICATIONS = "deleteNotification";
    public static final String ACTION_UPDATE_NOTIFICATIONS = "updateNotification";
    public static final String ACTION_LOAD_GEOLOCATIONS = "loadGeoLocations";
    public static final String ACTION_SEND_LOCAL_NOTIFICATIONS = "sendLocalNotifications";
    public static final String ACTION_MEDIA_PICK_MAGE_FROM_CAMERA = "pickImageFromCamera";
    public static final String ACTION_MEDIA_PICK_IMAGE_FROM_GALLERY = "pickImageFromGallery";
    public static final String ACTION_MEDIA_PICK_AUDIO_FROM_GALLERY = "pickAudioFromGallery";
    public static final String ACTION_MEDIA_START_RECORDING_AUDIO = "startRecordingAudio";
    public static final String ACTION_MEDIA_STOP_RECORDING_AUDIO = "stopRecordingAudio";
    public static final String ACTION_MEDIA_START_PLAYING_RECORDED_AUDIO = "startPlayingRecordedAudio";
    public static final String ACTION_MEDIA_STOP_PALYING_RECORDED_AUDIO = "stopPlayingRecordedAudio";
    public static final String ACTION_MEDIA_PICK_VIDEO_FROM_CAMERA = "pickVideoFromCamera";
    public static final String ACTION_MEDIA_PICK_VIDEO_FROM_GALLERY = "pickVideoFromGallery";
    public static final String ACTION_MEDIA_PLAY_VIDEO_FROM_SELECTEDPATH = "playVideoSelectedPath";
    public static final String ACTION_MEDIA_SHOW_IMAGE_FROM_PATH = "showImageFromPath";
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private static CallbackContext callback;
    private final String SUCCESS = "Success";
    private final String INVALID_REQUEST = "Invalid Request";
    private final String INVALID_ACTION = "Invalid Action Name";
    private final String NO_INTERNET = "No Internet Connection";
    private final String INVALID_USR_PWD = "Wrong Username/Password";
    private final String ERROR = "Error";
    private final String UNKNOWN_ERROR = "Unknown Error";

    public static void notifyNetworkStatus(int code, String message) {
        if (callback != null) {
            JSONObject jobj = new JSONObject();
            try {
                jobj.put(CODE, code);
                jobj.put(MESSAGE, (Object)message);
                callback.error(DOLLAR_SIGN + jobj.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void init(Context con, CallbackContext callbackContext) {
        callback = callbackContext;
    }

    protected void sendResult(String result) {
        PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, result);
        pluginResult.setKeepCallback(true);
        callback.sendPluginResult(pluginResult);
    }

    public String getReplyJsonString(int code) {
        JSONObject jobj = new JSONObject();
        try {
            jobj.put(CODE, code);
            switch (code) {
                case 100: {
                    jobj.put(MESSAGE, (Object)"Success");
                    break;
                }
                case 101: {
                    jobj.put(MESSAGE, (Object)"No Internet Connection");
                    break;
                }
                case 102: {
                    jobj.put(MESSAGE, (Object)"Invalid Request");
                    break;
                }
                case 103: {
                    jobj.put(MESSAGE, (Object)"Wrong Username/Password");
                    break;
                }
                case 105: {
                    jobj.put(MESSAGE, (Object)"Error");
                    break;
                }
                case 106: {
                    jobj.put(MESSAGE, (Object)"Invalid Action Name");
                    break;
                }
                default: {
                    jobj.put(MESSAGE, (Object)"Unknown Error");
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jobj.toString();
    }

    public boolean isOnline() {
        ConnectivityManager cm = (ConnectivityManager)this.cordova.getActivity().getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnectedOrConnecting();
    }

    public boolean isGPSEnabled() {
        LocationManager locationManager = (LocationManager)this.cordova.getActivity().getSystemService("location");
        return locationManager.isProviderEnabled("gps");
    }

    public String readPanelListCachePathFromDevice() {
        return null;
    }
}

