/*
 * Decompiled with CFR 0.152.
 */
package OnePoint.CordovaPlugin;

import OnePoint.Common.OPGSharedPreference;
import OnePoint.CordovaPlugin.ProgressUpdater;
import OnePoint.CordovaPlugin.RootPlugin;
import OnePoint.CordovaPlugin.Utils.FileUtils;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.AsyncTask;
import com.allatori.annotations.DoNotRename;
import com.opg.sdk.OPGSDK;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.PluginResult;
import org.json.JSONException;
import org.json.JSONObject;

@DoNotRename
public class MediaPlugin
extends RootPlugin
implements ProgressUpdater {
    public static final String MEDIA_PREFERENCES = "MediaPrefs";
    public static final String MEDIA_FORMAT_KEY = "mediaformat";
    public static boolean isOfflineMedia = false;
    public static String MediaFileFormat;
    private final String MEDIA_PATH_KEY = "mediaPath";
    private final String COMMENTS_KEY = "comments";
    private final String MEDIA_TYPE_KEY = "mediaType";
    private final String MEDIA_ID_KEY = "mediaID";
    private final String[] ANDROID_IMAGE_FORMATS = new String[]{"jpg", "gif", "png", "bmp", "webp"};
    private final String[] ANDROID_AUDIO_FORMATS = new String[]{"3gp", "mp4", "m4a", "3ga", "3gpp", "aac", "ts", "flac", "mp3", "ogg", "mkv", "mid", "xmf", "mxmf", "rtttl", "rtx", "ota", "imy", "wav"};
    private final String[] ANDROID_VIDEO_FORMATS = new String[]{"3gp", "mp4", "ts", "mkv", "webm"};
    private final String URI = "uri";
    private final String OPG_SURVEYS_MEDIA = "/OPG_Surveys_Media/";
    private final String MEDIAID = "MediaID";
    private final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd_hh_mm_ss";
    private final String FAILED = "Failed";
    private final String PERCENT = "Percent";
    Context context;
    PluginResult pluginResult;
    String mediaPath;
    String comments;
    String mediaType;
    String meidaID;
    SharedPreferences mediaFilePreferences;
    private CallbackContext callback;
    private ProgressDialog pDialog;

    @DoNotRename
    public boolean execute(String action, CordovaArgs args, CallbackContext callbackContext) {
        this.context = this.cordova.getActivity();
        this.callback = callbackContext;
        try {
            JSONObject obj = args.getJSONObject(0);
            if (action.equalsIgnoreCase("mediaUpload_network")) {
                if (isOfflineMedia) {
                    this.offlineUpload(obj);
                } else {
                    this.onlineUpload(obj);
                }
            } else if (action.equalsIgnoreCase("mediaUpload_database")) {
                if (isOfflineMedia) {
                    this.offlineUpload(obj);
                } else {
                    this.onlineUpload(obj);
                }
            } else if (action.equalsIgnoreCase("mediaDownload_network")) {
                if (isOfflineMedia) {
                    this.offlineDownload(obj);
                } else {
                    this.onlineDownload(obj);
                }
            } else if (action.equalsIgnoreCase("mediaDownload_database")) {
                if (isOfflineMedia) {
                    this.offlineDownload(obj);
                } else {
                    this.onlineDownload(obj);
                }
            } else if (action.equalsIgnoreCase("startPlayingRecordedAudio")) {
                this.playRecording((Uri)obj.get("uri"));
            } else if (action.equalsIgnoreCase("mediaUpload_getPath")) {
                this.mediaPath = obj.get("mediaPath").toString();
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, FileUtils.getJSONPathObj(this.mediaPath));
                pluginResult.setKeepCallback(true);
                this.callback.sendPluginResult(pluginResult);
                isOfflineMedia = false;
            } else {
                this.callback.error(this.getReplyJsonString(102));
            }
        }
        catch (JSONException e) {
            this.callback.error(this.getReplyJsonString(102));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private void onlineUpload(JSONObject obj) throws JSONException {
        this.mediaPath = obj.get("mediaPath").toString();
        this.comments = obj.get("comments").toString();
        if (this.isOnline()) {
            new UploadOnlineMediaTask().execute(new Void[0]);
        } else {
            this.callback.error(this.getReplyJsonString(101));
        }
    }

    private void onlineDownload(JSONObject obj) throws JSONException {
        this.mediaType = obj.get("mediaType").toString();
        this.meidaID = obj.get("mediaID").toString();
        if (this.meidaID.equalsIgnoreCase("0")) {
            this.callback.error(this.getReplyJsonString(101));
        } else if (!OPGSharedPreference.getMedia(this.meidaID, (Activity)this.context).equalsIgnoreCase("")) {
            this.pluginResult = new PluginResult(PluginResult.Status.OK, FileUtils.getJSONPathObj(OPGSharedPreference.getMedia(this.meidaID, (Activity)this.context)));
            this.pluginResult.setKeepCallback(true);
            this.callback.sendPluginResult(this.pluginResult);
        } else if (!this.isOnline()) {
            this.callback.error(this.getReplyJsonString(101));
        }
    }

    private void offlineUpload(JSONObject obj) throws JSONException {
        this.mediaPath = obj.get("mediaPath").toString();
        this.comments = obj.get("comments").toString();
        File savDir = new File(this.context.getCacheDir() + "/OPG_Surveys_Media/");
        File srce = new File(this.mediaPath);
        if (!savDir.exists()) {
            savDir.mkdirs();
        }
        String localMediaID = this.moveFile(srce.getParent() + "/", srce.getName(), savDir.getPath() + "/");
        JSONObject mediajson = new JSONObject();
        mediajson.put("MediaID", (Object)localMediaID);
        PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, mediajson.toString());
        pluginResult.setKeepCallback(true);
        this.callback.sendPluginResult(pluginResult);
    }

    public String moveFile(String inputPath, String inputFile, String outputPath) {
        FileInputStream in = null;
        FileOutputStream out = null;
        this.mediaFilePreferences = this.context.getSharedPreferences(MEDIA_PREFERENCES, 0);
        String extn = "";
        String mediaIdCallBack = null;
        try {
            int read;
            File dir = new File(outputPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String mediaFile = OPGSharedPreference.getMediaFileFormat((Activity)this.context);
            Date today = new Date();
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_hh_mm_ss", Locale.ENGLISH);
            String date = DATE_FORMAT.format(today);
            String newFileFormat = mediaFile + "-" + UUID.randomUUID().toString().toUpperCase(Locale.US) + "-" + date + "." + extn;
            in = new FileInputStream(inputPath + inputFile);
            out = new FileOutputStream(outputPath + inputFile);
            byte[] buffer = new byte[1024];
            while ((read = ((InputStream)in).read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            ((InputStream)in).close();
            in = null;
            out.flush();
            ((OutputStream)out).close();
            out = null;
            File from = new File(outputPath, inputFile);
            File to = new File(outputPath, newFileFormat);
            from.renameTo(to);
            new File(inputPath + inputFile).delete();
            mediaIdCallBack = newFileFormat;
        }
        catch (Exception e) {
            this.callback.error(e.getLocalizedMessage());
        }
        return mediaIdCallBack;
    }

    private void offlineDownload(JSONObject obj) throws JSONException {
        this.mediaType = obj.get("mediaType").toString();
        this.meidaID = obj.get("mediaID").toString();
        this.DownloadOfflineMedia();
    }

    private void DownloadOfflineMedia() {
        block6: {
            try {
                if (this.meidaID.equalsIgnoreCase("0")) {
                    this.callback.error(this.getReplyJsonString(101));
                    break block6;
                }
                if (!OPGSharedPreference.getMedia(this.meidaID, (Activity)this.context).equalsIgnoreCase("")) {
                    this.pluginResult = new PluginResult(PluginResult.Status.OK, FileUtils.getJSONPathObj(OPGSharedPreference.getMedia(this.meidaID, (Activity)this.context)));
                    this.pluginResult.setKeepCallback(true);
                    this.callback.sendPluginResult(this.pluginResult);
                    break block6;
                }
                this.callback.error(this.getReplyJsonString(101));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.callback.error(e.getLocalizedMessage());
            }
        }
    }

    public void saveImage(String fileName, Bitmap bitmap) {
    }

    @Override
    public void updateProgress(String update, long progress, long totalSize) {
        int percent = (int)((float)progress / (float)totalSize * 100.0f);
        if (this.callback != null) {
            JSONObject resultJSON = new JSONObject();
            try {
                resultJSON.put("Percent", percent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pluginResult = new PluginResult(PluginResult.Status.OK, resultJSON.toString());
            this.pluginResult.setKeepCallback(true);
            this.callback.sendPluginResult(this.pluginResult);
        }
    }

    private void playRecording(Uri audioFileUri) {
        MediaPlayer mediaPlayer = MediaPlayer.create((Context)this.context, (Uri)audioFileUri);
        mediaPlayer.start();
        this.callback.success(this.getReplyJsonString(100));
    }

    class UploadOnlineMediaTask
    extends AsyncTask<Void, Void, String> {
        private Exception exception;

        UploadOnlineMediaTask() {
        }

        protected String doInBackground(Void ... arg0) {
            String response = null;
            try {
                String mediaID = new OPGSDK().uploadMediaFile(MediaPlugin.this.mediaPath, MediaPlugin.this.context);
                response = mediaID + ":" + MediaPlugin.this.mediaPath;
            }
            catch (Exception e) {
                this.exception = e;
            }
            return response;
        }

        protected void onPostExecute(String result) {
            super.onPostExecute((Object)result);
            if (result != null) {
                String[] response = result.split(":");
                if (response.length == 2) {
                    PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, FileUtils.getJSONMediaPathObj(response[0], response[1]));
                    pluginResult.setKeepCallback(true);
                    MediaPlugin.this.callback.sendPluginResult(pluginResult);
                } else {
                    MediaPlugin.this.callback.error("Failed :" + result);
                }
            } else if (this.exception != null) {
                MediaPlugin.this.callback.error("Failed :" + this.exception.getMessage());
            }
        }
    }
}

