/*
 * Decompiled with CFR 0.152.
 */
package OnePoint.CordovaPlugin;

import OnePoint.Common.Utils;
import OnePoint.CordovaPlugin.ImageLoadingUtils;
import OnePoint.CordovaPlugin.RootPlugin;
import OnePoint.CordovaPlugin.Utils.FileUtils;
import android.app.Activity;
import android.app.Dialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.ExifInterface;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import com.allatori.annotations.DoNotRename;
import com.opg.sdk.OPGR;
import com.opg.sdk.OPGSDKConstant;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.json.JSONObject;

@DoNotRename
public class MediaPickerAndPreviewPlugin
extends RootPlugin {
    private static final int REQUEST_CODE_STORAGE_PERMISSION = 129;
    private static final int REQUEST_CODE_CAMERA_PERMISSIONS = 126;
    private static final int REQUEST_CODE_AUDIO_PERMISSIONS = 127;
    private static final int REQUEST_CODE_RECORD_PERMISSIONS = 128;
    public static String mediaFilename;
    private static boolean isGallery;
    private static int MAX_IMAGE_SIZE;
    private final int PICK_IMAGE_FROM_CAMERA = 1;
    private final int PICK_IMAGE_FROM_GALLARY = 2;
    private final int PICK_AUDIO_FROM_GALLARY = 4;
    private final int PICK_VIDEO_FROM_CAMERA = 5;
    private final int PICK_VIDEO_FROM_GALLARY = 6;
    private final int CROP_IMAGE_FROM_CAMERA = 7;
    public String _CurrentMediaPath = "";
    Context context;
    PluginResult pluginResult;
    private CallbackContext callback;
    private ImageLoadingUtils utils;
    private String _CapturedAuioPath = null;
    private MediaRecorder mRecorder = null;
    private MediaPlayer mPlayer = null;
    private Dialog progressDialog;

    @DoNotRename
    public boolean execute(String action, CordovaArgs args, CallbackContext callbackContext) {
        this.context = this.cordova.getActivity();
        this.callback = callbackContext;
        this.utils = new ImageLoadingUtils(this.context);
        try {
            System.out.println(action);
            if (action.equalsIgnoreCase("pickImageFromCamera")) {
                this.pickImageFromCamera();
            } else if (action.equalsIgnoreCase("pickImageFromGallery")) {
                this.pickImageFromGallery();
            } else if (action.equalsIgnoreCase("pickAudioFromGallery")) {
                this.pickAudioFromGallery();
            } else if (action.equalsIgnoreCase("startRecordingAudio")) {
                this.startRecordingAudio();
            } else if (action.equalsIgnoreCase("stopRecordingAudio")) {
                this.stopRecordingAudio();
            } else if (action.equalsIgnoreCase("startPlayingRecordedAudio")) {
                JSONObject obj = args.getJSONObject(0);
                if (obj.opt(OPGSDKConstant.MEDIA_PATH_KEY) != null) {
                    this.startPlayingAudio(obj.getString(OPGSDKConstant.MEDIA_PATH_KEY));
                }
            } else if (action.equalsIgnoreCase("stopPlayingRecordedAudio")) {
                this.stopPlayingRecordedAudio();
            } else if (action.equalsIgnoreCase("pickVideoFromCamera")) {
                this.pickVideoFromCamera();
            } else if (action.equalsIgnoreCase("pickVideoFromGallery")) {
                this.pickVideoFromGallery();
            } else if (action.equalsIgnoreCase("playVideoSelectedPath")) {
                JSONObject obj = args.getJSONObject(0);
                if (obj.opt(OPGSDKConstant.MEDIA_PATH_KEY) != null) {
                    this.playVideoFromPath(obj.getString(OPGSDKConstant.MEDIA_PATH_KEY));
                }
            } else if (action.equalsIgnoreCase("showImageFromPath")) {
                JSONObject obj = args.getJSONObject(0);
                if (obj.opt(OPGSDKConstant.MEDIA_PATH_KEY) != null) {
                    this.showImageFromPath(obj.getString(OPGSDKConstant.MEDIA_PATH_KEY));
                }
            } else {
                this.callback.error(this.getReplyJsonString(102));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public void pickImageFromCamera() {
        if (this.checkPermission(126)) {
            File saveFile;
            File vitaccessMediaDir = new File(Environment.getExternalStorageDirectory() + OPGSDKConstant.FILE_SEPARATOR + Utils.getApplicationName(this.context) + OPGSDKConstant.FILE_SEPARATOR + "media" + "/");
            File vitaccessMediaImageDir = new File(vitaccessMediaDir + "/Opg_Image/");
            if (!vitaccessMediaImageDir.exists()) {
                vitaccessMediaImageDir.mkdirs();
            }
            String format = String.format(Locale.ENGLISH, "%%0%dd", 3);
            do {
                String filename = "image_capture_" + String.format(Locale.ENGLISH, format, System.currentTimeMillis() / 1000L) + ".jpeg";
                saveFile = new File(vitaccessMediaImageDir, filename);
                mediaFilename = filename;
            } while (saveFile.exists());
            Intent intent = new Intent(OPGSDKConstant.IMAGE_CAPTURE);
            this._CurrentMediaPath = saveFile.getAbsolutePath();
            if (Build.VERSION.SDK_INT >= 24) {
                intent.setFlags(1);
                Uri contentUri = FileProvider.getUriForFile((Context)this.context, (String)this.context.getPackageName(), (File)saveFile);
                intent.putExtra(OPGSDKConstant.EXTRA_OUTPUT, (Parcelable)contentUri);
            } else {
                intent.putExtra(OPGSDKConstant.EXTRA_OUTPUT, (Parcelable)Uri.fromFile((File)saveFile));
            }
            this.cordova.startActivityForResult((CordovaPlugin)this, intent, 1);
        }
    }

    public void pickImageFromGallery() {
        if (this.checkStoragePermission()) {
            Intent intent = new Intent(OPGSDKConstant.ACTION_PICK, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            intent.putExtra(OPGSDKConstant.EXTRA_LOCAL_ONLY, true);
            ComponentName componentName = intent.resolveActivity(this.context.getPackageManager());
            if (componentName != null) {
                this.cordova.startActivityForResult((CordovaPlugin)this, intent, 2);
            } else {
                Intent intent2 = new Intent(OPGSDKConstant.ACTION_GET_CONTENT);
                intent2.setType("image/*");
                componentName = intent2.resolveActivity(this.context.getPackageManager());
                if (componentName != null) {
                    this.cordova.startActivityForResult((CordovaPlugin)this, Intent.createChooser((Intent)intent2, (CharSequence)"Select Image "), 2);
                }
            }
        }
    }

    public void showImageFromPath(String path) {
        File f = new File(path);
        if (f.exists() && !f.isDirectory()) {
            Uri uri = Uri.parse((String)("file://" + path));
            Intent intent = new Intent(OPGSDKConstant.ACTION_VIEW);
            intent.setDataAndType(uri, "image/*");
            this.cordova.getActivity().startActivity(intent);
        } else {
            this.callback.error("Failed : Error in Preview");
        }
    }

    public void pickAudioFromGallery() {
        if (this.checkStoragePermission()) {
            Intent audioChooser = new Intent(OPGSDKConstant.ACTION_PICK, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
            ComponentName componentName = audioChooser.resolveActivity(this.context.getPackageManager());
            if (componentName != null) {
                this.cordova.startActivityForResult((CordovaPlugin)this, audioChooser, 4);
            } else {
                Intent intent = new Intent(OPGSDKConstant.ACTION_GET_CONTENT);
                intent.setType("audio/*");
                componentName = intent.resolveActivity(this.context.getPackageManager());
                if (componentName != null) {
                    this.cordova.startActivityForResult((CordovaPlugin)this, Intent.createChooser((Intent)intent, (CharSequence)"Select Audio "), 4);
                }
            }
        }
    }

    private boolean showStoragePermissionDialog() {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.cordova.getActivity(), (String)OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION) && ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.cordova.getActivity(), (String)OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION);
    }

    private boolean showCameraPermissionDialog() {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.cordova.getActivity(), (String)OPGSDKConstant.CAMERA_PERMISSION);
    }

    private boolean showAudioPermissionDialog() {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.cordova.getActivity(), (String)OPGSDKConstant.AUDIO_PERMISSION);
    }

    private boolean isPermissionGranted(String permission2) {
        return ActivityCompat.checkSelfPermission((Context)this.context, (String)permission2) == 0;
    }

    private boolean checkPermission(int requestCode) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.isPermissionGranted(OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION) && this.isPermissionGranted(OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION) && (requestCode == 126 && this.isPermissionGranted(OPGSDKConstant.CAMERA_PERMISSION) || requestCode == 127 && this.isPermissionGranted(OPGSDKConstant.AUDIO_PERMISSION) || requestCode == 128 && this.isPermissionGranted(OPGSDKConstant.CAMERA_PERMISSION) && this.isPermissionGranted(OPGSDKConstant.AUDIO_PERMISSION))) {
                return true;
            }
            if (requestCode == 126 && this.showCameraPermissionDialog() && this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.CAMERA_PERMISSION, OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION, OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION}, requestCode);
            } else if (requestCode == 126 && this.showCameraPermissionDialog() && !this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.CAMERA_PERMISSION}, requestCode);
            } else if (requestCode == 127 && this.showAudioPermissionDialog() && this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.AUDIO_PERMISSION, OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION, OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION}, requestCode);
            } else if (requestCode == 127 && this.showAudioPermissionDialog() && !this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.AUDIO_PERMISSION}, requestCode);
            } else if (requestCode == 128 && this.showCameraPermissionDialog() && this.showAudioPermissionDialog() && this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.CAMERA_PERMISSION, OPGSDKConstant.AUDIO_PERMISSION, OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION, OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION}, requestCode);
            } else if (requestCode == 128 && this.showCameraPermissionDialog() && this.showAudioPermissionDialog() && !this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.CAMERA_PERMISSION, OPGSDKConstant.AUDIO_PERMISSION}, requestCode);
            } else if (requestCode == 128 && this.showCameraPermissionDialog() && !this.showAudioPermissionDialog() && !this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.CAMERA_PERMISSION}, requestCode);
            } else if (requestCode == 128 && !this.showCameraPermissionDialog() && this.showAudioPermissionDialog() && !this.showStoragePermissionDialog()) {
                ActivityCompat.requestPermissions((Activity)this.cordova.getActivity(), (String[])new String[]{OPGSDKConstant.AUDIO_PERMISSION}, (int)requestCode);
            } else if (requestCode == 128 && this.showCameraPermissionDialog() && !this.showAudioPermissionDialog() && this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.CAMERA_PERMISSION, OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION, OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION}, requestCode);
            } else if (requestCode == 128 && !this.showCameraPermissionDialog() && this.showAudioPermissionDialog() && this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.AUDIO_PERMISSION, OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION, OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION}, requestCode);
            } else if (this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION, OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION}, requestCode);
            } else {
                this.showAlertDialog(requestCode);
            }
            return false;
        }
        return true;
    }

    @DoNotRename
    private boolean checkStoragePermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.isPermissionGranted(OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION) && this.isPermissionGranted(OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION)) {
                return true;
            }
            if (this.showStoragePermissionDialog()) {
                this.requestRuntimePermissions(new String[]{OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION, OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION}, 129);
            } else {
                this.showAlertDialog(129);
            }
            return false;
        }
        return true;
    }

    private void requestRuntimePermissions(String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions((Activity)this.cordova.getActivity(), (String[])permissions, (int)requestCode);
    }

    private void showAlertDialog(int requestCode) {
        AlertDialog.Builder builder = Build.VERSION.SDK_INT >= 21 ? new AlertDialog.Builder(this.context, 16974374) : new AlertDialog.Builder(this.context);
        String message = "";
        if (requestCode == 126) {
            if (!this.isPermissionGranted(OPGSDKConstant.CAMERA_PERMISSION)) {
                message = OPGR.getString(this.context, "string", OPGSDKConstant.CAMERA_PERMISSION_MSG);
            }
        } else if (requestCode == 127) {
            if (!this.isPermissionGranted(OPGSDKConstant.AUDIO_PERMISSION)) {
                message = OPGR.getString(this.context, "string", OPGSDKConstant.AUDIO_PERMISSION_MSG);
            }
        } else if (!(requestCode != 128 || this.isPermissionGranted(OPGSDKConstant.CAMERA_PERMISSION) && this.isPermissionGranted(OPGSDKConstant.AUDIO_PERMISSION))) {
            message = OPGR.getString(this.context, "string", OPGSDKConstant.RECORD_PERMISSION_MSG);
        }
        if (!this.isPermissionGranted(OPGSDKConstant.WRITE_EXTRENAL_STORAGE_PERMISSION) && !this.isPermissionGranted(OPGSDKConstant.READ_EXTRENAL_STORAGE_PERMISSION)) {
            if (!message.isEmpty()) {
                message = message + "\n";
            }
            message = message + OPGR.getString(this.context, "string", OPGSDKConstant.ACCESS_PERMISSION_MSG);
        }
        builder.setTitle((CharSequence)OPGR.getString(this.context, "string", OPGSDKConstant.RUNTIME_PERMISSION)).setMessage((CharSequence)message).setPositiveButton((CharSequence)OPGR.getString(this.context, "string", OPGSDKConstant.SETTINGS), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                MediaPickerAndPreviewPlugin.this.goToSettingPage();
            }
        }).setNegativeButton((CharSequence)OPGR.getString(this.context, "string", OPGSDKConstant.DENY), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setIcon(17301543).show();
    }

    private void goToSettingPage() {
        Intent intent = new Intent();
        intent.setAction(OPGSDKConstant.APP_DETAILS_SETTINGS);
        Uri uri = Uri.fromParts((String)OPGSDKConstant.PACKAGE, (String)this.cordova.getActivity().getPackageName(), null);
        intent.setData(uri);
        this.cordova.getActivity().startActivity(intent);
    }

    public void startRecordingAudio() throws IOException {
        if (this.checkPermission(127)) {
            String filename;
            File saveFile;
            File vitaccessMediaDir = new File(Environment.getExternalStorageDirectory() + OPGSDKConstant.FILE_SEPARATOR + Utils.getApplicationName(this.context) + OPGSDKConstant.FILE_SEPARATOR + "media" + "/");
            File vitaccessMediaAudioDir = new File(vitaccessMediaDir + "/Opg_Audio/");
            if (!vitaccessMediaAudioDir.exists()) {
                vitaccessMediaAudioDir.mkdirs();
            }
            String format = String.format(Locale.ENGLISH, "%%0%dd", 3);
            while ((saveFile = new File(vitaccessMediaAudioDir, filename = "audio_capture_" + String.format(Locale.ENGLISH, format, System.currentTimeMillis()) + ".wav")).exists()) {
            }
            this._CapturedAuioPath = saveFile.getAbsolutePath();
            this.mRecorder = new MediaRecorder();
            this.mRecorder.setAudioSource(1);
            this.mRecorder.setOutputFile(this._CapturedAuioPath);
            this.mRecorder.setAudioSamplingRate(44100);
            this.mRecorder.setAudioEncodingBitRate(96000);
            this.mRecorder.setOutputFormat(2);
            this.mRecorder.setAudioEncoder(3);
            this.mRecorder.prepare();
            this.mRecorder.start();
        }
    }

    public void stopRecordingAudio() {
        if (this.mRecorder != null) {
            this.mRecorder.stop();
            this.mRecorder.release();
        }
        this.mRecorder = null;
        this.sendResul(this._CapturedAuioPath);
    }

    public void startPlayingAudio(String path) throws IOException {
        File f = new File(path);
        if (f.exists() && !f.isDirectory()) {
            this.mPlayer = new MediaPlayer();
            this.mPlayer.setDataSource(path);
            this.mPlayer.prepare();
            this.mPlayer.start();
            this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    MediaPickerAndPreviewPlugin.this.sendResul("COMPLETED");
                }
            });
        } else {
            this.callback.error("Failed : Error in Preview");
        }
    }

    public void stopPlayingRecordedAudio() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        this.mPlayer = null;
    }

    public void pickVideoFromCamera() {
        Intent takeVideoIntent;
        if (this.checkPermission(128) && (takeVideoIntent = new Intent(OPGSDKConstant.VIDEO_CAPTURE)).resolveActivity(this.cordova.getActivity().getPackageManager()) != null) {
            this.cordova.startActivityForResult((CordovaPlugin)this, takeVideoIntent, 5);
        }
    }

    public void pickVideoFromGallery() {
        if (this.checkStoragePermission()) {
            Intent videoChooser = new Intent(OPGSDKConstant.ACTION_PICK, MediaStore.Video.Media.INTERNAL_CONTENT_URI);
            videoChooser.putExtra(OPGSDKConstant.EXTRA_LOCAL_ONLY, true);
            ComponentName componentName = videoChooser.resolveActivity(this.context.getPackageManager());
            if (componentName != null) {
                videoChooser.setType("video/*");
                this.cordova.startActivityForResult((CordovaPlugin)this, videoChooser, 6);
            } else {
                Intent videoChooser2 = new Intent(OPGSDKConstant.ACTION_GET_CONTENT);
                videoChooser2.setType("video/*");
                componentName = videoChooser2.resolveActivity(this.context.getPackageManager());
                if (componentName != null) {
                    this.cordova.startActivityForResult((CordovaPlugin)this, videoChooser2, 6);
                }
            }
        }
    }

    public void playVideoFromPath(String path) {
        File f = new File(path);
        if (f.exists() && !f.isDirectory()) {
            Intent intent = new Intent(OPGSDKConstant.ACTION_VIEW);
            ComponentName componentName = intent.resolveActivity(this.context.getPackageManager());
            if (componentName != null) {
                if (Build.VERSION.SDK_INT >= 24) {
                    intent.setFlags(1);
                    Uri contentUri = FileProvider.getUriForFile((Context)this.context, (String)this.context.getPackageName(), (File)f);
                    intent.setDataAndType(contentUri, "video/*");
                } else {
                    Uri uri = Uri.parse((String)("file://" + path));
                    intent.setDataAndType(uri, "video/*");
                }
                this.cordova.getActivity().startActivity(intent);
            } else {
                this.callback.error("Failed : Error in Preview");
            }
        } else {
            this.callback.error("Failed : Error in Preview");
        }
    }

    @DoNotRename
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        switch (requestCode) {
            case 2: {
                isGallery = true;
                if (resultCode != -1) break;
                Uri imageUri = intent.getData();
                this._CurrentMediaPath = imageUri.toString();
                try {
                    this._CurrentMediaPath = FileUtils.getPath(this.context, Uri.parse((String)this._CurrentMediaPath));
                }
                catch (Exception e) {
                    this._CurrentMediaPath = this._CurrentMediaPath.replaceFirst(this._CurrentMediaPath.substring(0, this._CurrentMediaPath.indexOf(":")), "");
                    this._CurrentMediaPath = this._CurrentMediaPath.replaceAll(":", "");
                }
                new CompressImage(this._CurrentMediaPath).execute(new Void[0]);
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                isGallery = false;
                this.sendResult();
                break;
            }
            case 4: {
                if (resultCode != -1) break;
                Uri audioUri = intent.getData();
                this._CurrentMediaPath = audioUri.toString();
                try {
                    this._CurrentMediaPath = FileUtils.getPath(this.context, Uri.parse((String)this._CurrentMediaPath));
                }
                catch (Exception e) {
                    this._CurrentMediaPath = this._CurrentMediaPath.replaceFirst(this._CurrentMediaPath.substring(0, this._CurrentMediaPath.indexOf(":")), "");
                    this._CurrentMediaPath = this._CurrentMediaPath.replaceAll(":", "");
                }
                this._CapturedAuioPath = this._CurrentMediaPath;
                this.sendResult();
                break;
            }
            case 5: {
                if (resultCode != -1) break;
                Uri videoUri1 = intent.getData();
                this._CurrentMediaPath = videoUri1.toString();
                try {
                    this._CurrentMediaPath = FileUtils.getPath(this.context, Uri.parse((String)this._CurrentMediaPath));
                }
                catch (Exception e) {
                    this._CurrentMediaPath = this._CurrentMediaPath.replaceFirst(this._CurrentMediaPath.substring(0, this._CurrentMediaPath.indexOf(":")), "");
                    this._CurrentMediaPath = this._CurrentMediaPath.replaceAll(":", "");
                }
                this.CopyVideo(this._CurrentMediaPath);
                break;
            }
            case 6: {
                if (resultCode != -1) break;
                Uri videoUri2 = intent.getData();
                this._CurrentMediaPath = videoUri2.toString();
                try {
                    this._CurrentMediaPath = FileUtils.getPath(this.context, Uri.parse((String)this._CurrentMediaPath));
                }
                catch (Exception e) {
                    this._CurrentMediaPath = this._CurrentMediaPath.replaceFirst(this._CurrentMediaPath.substring(0, this._CurrentMediaPath.indexOf(":")), "");
                    this._CurrentMediaPath = this._CurrentMediaPath.replaceAll(":", "");
                }
                this.CopyVideo(this._CurrentMediaPath);
            }
        }
    }

    private void CopyVideo(String _CurrentMediaPath2) {
        File saveFile;
        String filename = null;
        File vitaccessMediaDir = new File(Environment.getExternalStorageDirectory() + OPGSDKConstant.FILE_SEPARATOR + Utils.getApplicationName(this.context) + OPGSDKConstant.FILE_SEPARATOR + "media" + "/");
        File vitaccessMediaVideoDir = new File(vitaccessMediaDir + "/Opg_Video/");
        if (!vitaccessMediaVideoDir.exists()) {
            vitaccessMediaVideoDir.mkdirs();
        }
        String format = String.format(Locale.ENGLISH, "%%0%dd", 3);
        do {
            String videofilename = "video_" + String.format(Locale.ENGLISH, format, System.currentTimeMillis() / 1000L) + ".mp4";
            saveFile = new File(vitaccessMediaVideoDir, videofilename);
            mediaFilename = videofilename;
        } while (saveFile.exists());
        File sourceFile = new File(_CurrentMediaPath2);
        try {
            _CurrentMediaPath2 = filename = this.copyDirectory(sourceFile, saveFile.getAbsoluteFile()).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._CurrentMediaPath = _CurrentMediaPath2;
        this.sendResult();
    }

    private void sendResult() {
        if (this._CurrentMediaPath.contains("image_capture_")) {
            new CompressImage(this._CurrentMediaPath).execute(new Void[0]);
            return;
        }
        this.pluginResult = new PluginResult(PluginResult.Status.OK, FileUtils.getJSONPathObj(this._CurrentMediaPath));
        this.pluginResult.setKeepCallback(true);
        if (this.callback != null) {
            this.callback.sendPluginResult(this.pluginResult);
        }
    }

    public boolean compressImage(String imageUri) {
        try {
            String filePath = imageUri;
            Bitmap scaledBitmap = null;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            Bitmap bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            int actualHeight = options.outHeight;
            int actualWidth = options.outWidth;
            float maxHeight = actualHeight;
            float maxWidth = actualWidth;
            float imgRatio = actualWidth / actualHeight;
            float maxRatio = maxWidth / maxHeight;
            if ((float)actualHeight > maxHeight || (float)actualWidth > maxWidth) {
                if (imgRatio < maxRatio) {
                    imgRatio = maxHeight / (float)actualHeight;
                    actualWidth = (int)(imgRatio * (float)actualWidth);
                    actualHeight = (int)maxHeight;
                } else if (imgRatio > maxRatio) {
                    imgRatio = maxWidth / (float)actualWidth;
                    actualHeight = (int)(imgRatio * (float)actualHeight);
                    actualWidth = (int)maxWidth;
                } else {
                    actualHeight = (int)maxHeight;
                    actualWidth = (int)maxWidth;
                }
            }
            options.inSampleSize = this.utils.calculateInSampleSize(options, actualWidth, actualHeight);
            options.inJustDecodeBounds = false;
            options.inDither = false;
            options.inPurgeable = true;
            options.inInputShareable = true;
            options.inTempStorage = new byte[16384];
            try {
                bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            }
            catch (OutOfMemoryError exception) {
                exception.printStackTrace();
            }
            try {
                scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError exception) {
                exception.printStackTrace();
            }
            float ratioX = (float)actualWidth / (float)options.outWidth;
            float ratioY = (float)actualHeight / (float)options.outHeight;
            float middleX = (float)actualWidth / 2.0f;
            float middleY = (float)actualHeight / 2.0f;
            Matrix scaleMatrix = new Matrix();
            scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
            Canvas canvas = new Canvas(scaledBitmap);
            canvas.setMatrix(scaleMatrix);
            canvas.drawBitmap(bmp, middleX - (float)(bmp.getWidth() / 2), middleY - (float)(bmp.getHeight() / 2), new Paint(2));
            try {
                ExifInterface exif = new ExifInterface(filePath);
                int orientation = exif.getAttributeInt("Orientation", 0);
                Matrix matrix = new Matrix();
                if (orientation == 6) {
                    matrix.postRotate(90.0f);
                } else if (orientation == 3) {
                    matrix.postRotate(180.0f);
                } else if (orientation == 8) {
                    matrix.postRotate(270.0f);
                }
                scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FileOutputStream out = null;
            String filename = null;
            if (isGallery) {
                File saveFile;
                File vitaccessMediaDir = new File(Environment.getExternalStorageDirectory() + OPGSDKConstant.FILE_SEPARATOR + Utils.getApplicationName(this.context) + OPGSDKConstant.FILE_SEPARATOR + "media" + "/");
                File vitaccessMediaImageDir = new File(vitaccessMediaDir + "/Opg_Image/");
                if (!vitaccessMediaImageDir.exists()) {
                    vitaccessMediaImageDir.mkdirs();
                }
                String format = String.format(Locale.ENGLISH, "%%0%dd", 3);
                do {
                    String imagefilename = "image_gallery_" + String.format(Locale.ENGLISH, format, System.currentTimeMillis() / 1000L) + ".jpeg";
                    saveFile = new File(vitaccessMediaImageDir, imagefilename);
                    mediaFilename = imagefilename;
                } while (saveFile.exists());
                File sourceFile = new File(this._CurrentMediaPath);
                try {
                    this._CurrentMediaPath = filename = this.copyDirectory(sourceFile, saveFile.getAbsoluteFile()).getAbsolutePath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                filename = this._CurrentMediaPath;
            }
            try {
                int compressionRate = 90;
                if (FileUtils.getFileSize(this._CurrentMediaPath) > (long)MAX_IMAGE_SIZE) {
                    do {
                        out = new FileOutputStream(filename);
                        scaledBitmap.compress(Bitmap.CompressFormat.JPEG, compressionRate, (OutputStream)out);
                        compressionRate = (int)((double)compressionRate * 0.9);
                    } while (FileUtils.getFileSize(filename) > (long)MAX_IMAGE_SIZE);
                }
                Log.i((String)"FinalFileSize", (String)(FileUtils.getFileSize(this._CurrentMediaPath) + ""));
                return true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public File copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists() && !targetLocation.mkdirs()) {
                throw new IOException("Cannot create dir " + targetLocation.getAbsolutePath());
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            File directory = targetLocation.getParentFile();
            if (directory != null && !directory.exists() && !directory.mkdirs()) {
                throw new IOException("Cannot create dir " + directory.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        return targetLocation;
    }

    private void sendResul(String path) {
        this.pluginResult = new PluginResult(PluginResult.Status.OK, FileUtils.getJSONPathObj(path));
        this.pluginResult.setKeepCallback(true);
        this.callback.sendPluginResult(this.pluginResult);
    }

    static {
        isGallery = false;
        MAX_IMAGE_SIZE = 921600;
    }

    private class CompressImage
    extends AsyncTask<Void, Void, Boolean> {
        String imageURI;

        public CompressImage(String imageURI) {
            this.imageURI = imageURI;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            MediaPickerAndPreviewPlugin.this.progressDialog = new Dialog((Context)MediaPickerAndPreviewPlugin.this.cordova.getActivity(), 16973839);
            MediaPickerAndPreviewPlugin.this.progressDialog.requestWindowFeature(1);
            MediaPickerAndPreviewPlugin.this.progressDialog.setContentView(OPGR.getId(MediaPickerAndPreviewPlugin.this.context, "layout", "progress_dialog"));
            MediaPickerAndPreviewPlugin.this.progressDialog.setCancelable(false);
            MediaPickerAndPreviewPlugin.this.progressDialog.show();
        }

        protected Boolean doInBackground(Void ... voids) {
            return MediaPickerAndPreviewPlugin.this.compressImage(this.imageURI);
        }

        protected void onPostExecute(Boolean aBoolean) {
            super.onPostExecute((Object)aBoolean);
            try {
                if (MediaPickerAndPreviewPlugin.this.callback != null && MediaPickerAndPreviewPlugin.this._CurrentMediaPath != null) {
                    MediaPickerAndPreviewPlugin.this.pluginResult = new PluginResult(PluginResult.Status.OK, FileUtils.getJSONPathObj(MediaPickerAndPreviewPlugin.this._CurrentMediaPath));
                    MediaPickerAndPreviewPlugin.this.pluginResult.setKeepCallback(true);
                    MediaPickerAndPreviewPlugin.this.callback.sendPluginResult(MediaPickerAndPreviewPlugin.this.pluginResult);
                }
                if (MediaPickerAndPreviewPlugin.this.progressDialog != null && MediaPickerAndPreviewPlugin.this.progressDialog.isShowing()) {
                    MediaPickerAndPreviewPlugin.this.progressDialog.dismiss();
                }
            }
            catch (Exception e) {
                Log.e((String)MediaPickerAndPreviewPlugin.this.cordova.getActivity().getClass().getName(), (String)e.toString());
            }
            MediaPickerAndPreviewPlugin.this.progressDialog = null;
        }
    }
}

